/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile_Multi_Banked/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile_Multi_Banked/include/Types.h"
#include <sstream>
using namespace std;

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile_multi_banked {


  string Parameters::msg_error(void)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"msg_error","Begin");

    string msg = "";

    if ((_nb_port_read  * 
	 _nb_port_write * 
	 _nb_word       *
	 _size_word     *
	 _nb_bank       ) == 0)
      {
        msg += "  - All paramameters must be > 0\n";
      }

    if (not is_multiple(_nb_port_read,_nb_bank))
      {
        msg += "  - nb_port_read must be a multiple of nb_bank\n";
        msg +=  "    * nb_port_read                    : " + toString(_nb_port_read ) + "\n";
	msg +=  "    * nb_bank                         : " + toString(_nb_bank      ) + "\n";
      }

    if (not is_multiple(_nb_port_write,_nb_bank))
      {
        msg += "  - nb_port_write must be a multiple of nb_bank\n";
        msg +=  "    * nb_port_write                   : " + toString(_nb_port_write) + "\n";
	msg +=  "    * nb_bank                         : " + toString(_nb_bank      ) + "\n";
      }

    if (not is_multiple(_nb_word,_nb_bank))
      {
        msg += "  - nb_word must be a multiple of nb_bank\n";
        msg +=  "    * nb_word                         : " + toString(_nb_word      ) + "\n";
	msg +=  "    * nb_bank                         : " + toString(_nb_bank      ) + "\n";
      }

    if ((8*sizeof(Tdata_t)) < _size_word)
      {
        msg += "  - type \"Tdata_t\" is too little to the size defined by size_word\n";
        msg +=  "    * size_word                       : " + toString(_size_word) + "\n";
	msg +=  "    * Tdata_t                   (bits): " + toString(8*(sizeof(Tdata_t))) + "\n";
      }

    if ((8*sizeof(Taddress_t)) < log2(_nb_word))
      {
        msg += "  - type \"Taddress_t\" is too little to the size defined by nb_word\n";
        msg +=  "    * nb_word                         : " + toString(_nb_word)    + "\n";
	msg +=  "      > size                   (bits) : " + toString(log2(_nb_word)) + "\n";
	msg +=  "    * Taddress_t               (bits) : " + toString(8*(sizeof(Taddress_t))) + "\n";
      }

    if (_nb_word < 2)
      {
        msg += "  - nb_word must be >= 2\n";
        msg += "    * nb_word                         : " + toString(_nb_word)    + "\n";
      }


    return msg;

    log_printf(FUNC,RegisterFile_Multi_Banked,"msg_error","End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
