/*
 * $Id$
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  16
#define CYCLE_MAX     (1024*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::prediction_unit_glue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Prediction_unit_Glue * _Prediction_unit_Glue = new Prediction_unit_Glue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_PREDICT_VAL                         ," in_PREDICT_VAL                        ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_ACK                         ,"out_PREDICT_ACK                        ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_PREDICT_PC_PREVIOUS                 ," in_PREDICT_PC_PREVIOUS                ",Taddress_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_PREDICT_PC_CURRENT                  ," in_PREDICT_PC_CURRENT                 ",Taddress_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_PREDICT_PC_CURRENT_IS_DS_TAKE       ," in_PREDICT_PC_CURRENT_IS_DS_TAKE      ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_PC_NEXT                     ,"out_PREDICT_PC_NEXT                    ",Taddress_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_PC_NEXT_IS_DS_TAKE          ,"out_PREDICT_PC_NEXT_IS_DS_TAKE         ",Tcontrol_t         ,_param->_nb_context);
  ALLOC2_SC_SIGNAL(out_PREDICT_INSTRUCTION_ENABLE          ,"out_PREDICT_INSTRUCTION_ENABLE         ",Tcontrol_t         ,_param->_nb_context,_param->_nb_instruction[it1]);
  ALLOC1_SC_SIGNAL(out_PREDICT_INST_IFETCH_PTR             ,"out_PREDICT_INST_IFETCH_PTR            ",Tinst_ifetch_ptr_t ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_STATE                ,"out_PREDICT_BRANCH_STATE               ",Tbranch_state_t    ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID ,"out_PREDICT_BRANCH_UPDATE_PREDICTION_ID",Tprediction_ptr_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_BTB_VAL                     ,"out_PREDICT_BTB_VAL                    ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_ACK                     ," in_PREDICT_BTB_ACK                    ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_BTB_CONTEXT_ID              ,"out_PREDICT_BTB_CONTEXT_ID             ",Tcontext_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_BTB_ADDRESS                 ,"out_PREDICT_BTB_ADDRESS                ",Taddress_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_HIT                     ," in_PREDICT_BTB_HIT                    ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_ADDRESS_SRC             ," in_PREDICT_BTB_ADDRESS_SRC            ",Taddress_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_ADDRESS_DEST            ," in_PREDICT_BTB_ADDRESS_DEST           ",Taddress_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_CONDITION               ," in_PREDICT_BTB_CONDITION              ",Tbranch_condition_t,_param->_nb_inst_branch_predict);
//ALLOC1_SC_SIGNAL( in_PREDICT_BTB_LAST_TAKE               ," in_PREDICT_BTB_LAST_TAKE              ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_IS_ACCURATE             ," in_PREDICT_BTB_IS_ACCURATE            ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_DIR_VAL                     ,"out_PREDICT_DIR_VAL                    ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_DIR_ACK                     ," in_PREDICT_DIR_ACK                    ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_DIR_ADDRESS_SRC             ,"out_PREDICT_DIR_ADDRESS_SRC            ",Taddress_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_DIR_STATIC                  ,"out_PREDICT_DIR_STATIC                 ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
//ALLOC1_SC_SIGNAL(out_PREDICT_DIR_LAST_TAKE               ,"out_PREDICT_DIR_LAST_TAKE              ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
//ALLOC1_SC_SIGNAL( in_PREDICT_DIR_HISTORY                 ," in_PREDICT_DIR_HISTORY                ",Thistory_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_DIR_DIRECTION               ," in_PREDICT_DIR_DIRECTION              ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_RAS_VAL                     ,"out_PREDICT_RAS_VAL                    ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_RAS_ACK                     ," in_PREDICT_RAS_ACK                    ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_RAS_CONTEXT_ID              ,"out_PREDICT_RAS_CONTEXT_ID             ",Tcontext_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_RAS_HIT                     ," in_PREDICT_RAS_HIT                    ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_RAS_PUSH                    ,"out_PREDICT_RAS_PUSH                   ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_RAS_ADDRESS_PUSH            ,"out_PREDICT_RAS_ADDRESS_PUSH           ",Taddress_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_RAS_ADDRESS_POP             ," in_PREDICT_RAS_ADDRESS_POP            ",Taddress_t         ,_param->_nb_inst_branch_predict);
//ALLOC1_SC_SIGNAL( in_PREDICT_RAS_INDEX                   ," in_PREDICT_RAS_INDEX                  ",Tptr_t             ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_UPT_VAL                     ,"out_PREDICT_UPT_VAL                    ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_UPT_ACK                     ," in_PREDICT_UPT_ACK                    ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_UPT_CONTEXT_ID              ,"out_PREDICT_UPT_CONTEXT_ID             ",Tcontext_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_UPT_BRANCH_UPDATE_PREDICTION_ID ,"out_PREDICT_UPT_BRANCH_UPDATE_PREDICTION_ID",Tprediction_ptr_t  ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_UPT_BTB_ADDRESS_SRC         ,"out_PREDICT_UPT_BTB_ADDRESS_SRC        ",Taddress_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_UPT_BTB_ADDRESS_DEST        ,"out_PREDICT_UPT_BTB_ADDRESS_DEST       ",Taddress_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_UPT_BTB_CONDITION           ,"out_PREDICT_UPT_BTB_CONDITION          ",Tbranch_condition_t,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_UPT_BTB_LAST_TAKE           ,"out_PREDICT_UPT_BTB_LAST_TAKE          ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_UPT_BTB_IS_ACCURATE         ,"out_PREDICT_UPT_BTB_IS_ACCURATE        ",Tcontrol_t         ,_param->_nb_inst_branch_predict);
//ALLOC1_SC_SIGNAL(out_PREDICT_UPT_DIR_HISTORY             ,"out_PREDICT_UPT_DIR_HISTORY            ",Thistory_t         ,_param->_nb_inst_branch_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_UPT_RAS_ADDRESS             ,"out_PREDICT_UPT_RAS_ADDRESS            ",Taddress_t         ,_param->_nb_inst_branch_predict);
//ALLOC1_SC_SIGNAL(out_PREDICT_UPT_RAS_INDEX               ,"out_PREDICT_UPT_RAS_INDEX              ",Tptr_t             ,_param->_nb_inst_branch_predict);
//   ALLOC1_SC_SIGNAL( in_DEPTH_UPT_NB_BRANCH                 ," in_DEPTH_UPT_NB_BRANCH                ",Tdepth_t           ,_param->_nb_context);
//   ALLOC1_SC_SIGNAL( in_DEPTH_UPT_TAIL                      ," in_DEPTH_UPT_TAIL                     ",Tdepth_t           ,_param->_nb_context);
//   ALLOC1_SC_SIGNAL(out_DEPTH_NB_BRANCH                     ,"out_DEPTH_NB_BRANCH                    ",Tdepth_t           ,_param->_nb_context);
//   ALLOC1_SC_SIGNAL(out_DEPTH_TAIL                          ,"out_DEPTH_TAIL                         ",Tdepth_t           ,_param->_nb_context);

  ALLOC2_SC_SIGNAL( in_DECOD_VAL                        ," in_DECOD_VAL                        ",Tcontrol_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL(out_DECOD_ACK                        ,"out_DECOD_ACK                        ",Tcontrol_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_CONTEXT_ID                 ," in_DECOD_CONTEXT_ID                 ",Tcontext_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_MATCH_INST_IFETCH_PTR      ," in_DECOD_MATCH_INST_IFETCH_PTR      ",Tcontrol_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_BRANCH_STATE               ," in_DECOD_BRANCH_STATE               ",Tbranch_state_t    ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_BRANCH_UPDATE_PREDICTION_ID," in_DECOD_BRANCH_UPDATE_PREDICTION_ID",Tprediction_ptr_t  ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_BRANCH_CONDITION           ," in_DECOD_BRANCH_CONDITION           ",Tbranch_condition_t,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_BRANCH_DIRECTION           ," in_DECOD_BRANCH_DIRECTION           ",Tcontrol_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_ADDRESS_SRC                ," in_DECOD_ADDRESS_SRC                ",Taddress_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_ADDRESS_DEST               ," in_DECOD_ADDRESS_DEST               ",Taddress_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  ALLOC1_SC_SIGNAL(out_DECOD_BTB_VAL                    ,"out_DECOD_BTB_VAL                    ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_BTB_ACK                    ," in_DECOD_BTB_ACK                    ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_BTB_CONTEXT_ID             ,"out_DECOD_BTB_CONTEXT_ID             ",Tcontext_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_BTB_ADDRESS_SRC            ,"out_DECOD_BTB_ADDRESS_SRC            ",Taddress_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_BTB_ADDRESS_DEST           ,"out_DECOD_BTB_ADDRESS_DEST           ",Taddress_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_BTB_CONDITION              ,"out_DECOD_BTB_CONDITION              ",Tbranch_condition_t,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_BTB_LAST_TAKE              ,"out_DECOD_BTB_LAST_TAKE              ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_BTB_MISS_PREDICTION        ,"out_DECOD_BTB_MISS_PREDICTION        ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_BTB_IS_ACCURATE            ,"out_DECOD_BTB_IS_ACCURATE            ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_RAS_VAL                    ,"out_DECOD_RAS_VAL                    ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_RAS_ACK                    ," in_DECOD_RAS_ACK                    ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_RAS_CONTEXT_ID             ,"out_DECOD_RAS_CONTEXT_ID             ",Tcontext_t         ,_param->_nb_inst_branch_decod); 
  ALLOC1_SC_SIGNAL( in_DECOD_RAS_HIT                    ," in_DECOD_RAS_HIT                    ",Tcontrol_t         ,_param->_nb_inst_branch_decod); 
  ALLOC1_SC_SIGNAL(out_DECOD_RAS_PUSH                   ,"out_DECOD_RAS_PUSH                   ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_RAS_ADDRESS_PUSH           ,"out_DECOD_RAS_ADDRESS_PUSH           ",Taddress_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_RAS_ADDRESS_POP            ," in_DECOD_RAS_ADDRESS_POP            ",Taddress_t         ,_param->_nb_inst_branch_decod);
//ALLOC1_SC_SIGNAL( in_DECOD_RAS_INDEX                  ," in_DECOD_RAS_INDEX                  ",Tptr_t             ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_RAS_MISS_PREDICTION        ,"out_DECOD_RAS_MISS_PREDICTION        ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_UPT_VAL                    ,"out_DECOD_UPT_VAL                    ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_UPT_ACK                    ," in_DECOD_UPT_ACK                    ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_UPT_CONTEXT_ID             ,"out_DECOD_UPT_CONTEXT_ID             ",Tcontext_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_UPT_BTB_ADDRESS_SRC        ,"out_DECOD_UPT_BTB_ADDRESS_SRC        ",Taddress_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_UPT_BTB_ADDRESS_DEST       ,"out_DECOD_UPT_BTB_ADDRESS_DEST       ",Taddress_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_UPT_BTB_CONDITION          ,"out_DECOD_UPT_BTB_CONDITION          ",Tbranch_condition_t,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_UPT_BTB_LAST_TAKE          ,"out_DECOD_UPT_BTB_LAST_TAKE          ",Tcontrol_t         ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_UPT_RAS_ADDRESS            ,"out_DECOD_UPT_RAS_ADDRESS            ",Taddress_t         ,_param->_nb_inst_branch_decod);
//ALLOC1_SC_SIGNAL(out_DECOD_UPT_RAS_INDEX              ,"out_DECOD_UPT_RAS_INDEX              ",Tptr_t             ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_UPT_MISS_IFETCH            ,"out_DECOD_UPT_MISS_IFETCH            ",Tcontrol_t         ,_param->_nb_inst_branch_decod); 
  ALLOC1_SC_SIGNAL(out_DECOD_UPT_MISS_DECOD             ,"out_DECOD_UPT_MISS_DECOD             ",Tcontrol_t         ,_param->_nb_inst_branch_decod); 
  ALLOC1_SC_SIGNAL(out_DECOD_UPT_UPDATE_PREDICTION_ID   ,"out_DECOD_UPT_UPDATE_PREDICTION_ID   ",Tprediction_ptr_t  ,_param->_nb_inst_branch_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_UPT_IS_ACCURATE            ,"out_DECOD_UPT_IS_ACCURATE            ",Tcontrol_t         ,_param->_nb_inst_branch_decod); 
  
  ALLOC1_SC_SIGNAL(out_UPDATE_BTB_VAL                  ,"out_UPDATE_BTB_VAL                  ",Tcontrol_t         ,_param->_nb_inst_branch_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_BTB_ACK                  ," in_UPDATE_BTB_ACK                  ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_BTB_CONTEXT_ID           ,"out_UPDATE_BTB_CONTEXT_ID           ",Tcontext_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_BTB_ADDRESS_SRC          ,"out_UPDATE_BTB_ADDRESS_SRC          ",Taddress_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_BTB_ADDRESS_DEST         ,"out_UPDATE_BTB_ADDRESS_DEST         ",Taddress_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_BTB_CONDITION            ,"out_UPDATE_BTB_CONDITION            ",Tbranch_condition_t,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_BTB_LAST_TAKE            ,"out_UPDATE_BTB_LAST_TAKE            ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_BTB_MISS_PREDICTION      ,"out_UPDATE_BTB_MISS_PREDICTION      ",Tcontrol_t         ,_param->_nb_inst_branch_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_DIR_VAL                  ,"out_UPDATE_DIR_VAL                  ",Tcontrol_t         ,_param->_nb_inst_branch_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_DIR_ACK                  ," in_UPDATE_DIR_ACK                  ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_DIR_ADDRESS              ,"out_UPDATE_DIR_ADDRESS              ",Taddress_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_DIR_HISTORY              ,"out_UPDATE_DIR_HISTORY              ",Thistory_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_DIR_DIRECTION            ,"out_UPDATE_DIR_DIRECTION            ",Tcontrol_t         ,_param->_nb_inst_branch_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_RAS_VAL                  ,"out_UPDATE_RAS_VAL                  ",Tcontrol_t         ,_param->_nb_inst_branch_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_RAS_ACK                  ," in_UPDATE_RAS_ACK                  ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_RAS_CONTEXT_ID           ,"out_UPDATE_RAS_CONTEXT_ID           ",Tcontext_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_RAS_PUSH                 ,"out_UPDATE_RAS_PUSH                 ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_RAS_ADDRESS              ,"out_UPDATE_RAS_ADDRESS              ",Taddress_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_RAS_INDEX                ,"out_UPDATE_RAS_INDEX                ",Tptr_t             ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_RAS_MISS_PREDICTION      ,"out_UPDATE_RAS_MISS_PREDICTION      ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL(out_UPDATE_RAS_PREDICTION_IFETCH    ,"out_UPDATE_RAS_PREDICTION_IFETCH    ",Tcontrol_t         ,_param->_nb_inst_branch_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_UPT_VAL                  ," in_UPDATE_UPT_VAL                  ",Tcontrol_t         ,_param->_nb_inst_branch_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_UPT_ACK                  ,"out_UPDATE_UPT_ACK                  ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL( in_UPDATE_UPT_CONTEXT_ID           ," in_UPDATE_UPT_CONTEXT_ID           ",Tcontext_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL( in_UPDATE_UPT_MISS_PREDICTION      ," in_UPDATE_UPT_MISS_PREDICTION      ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL( in_UPDATE_UPT_DIRECTION_GOOD       ," in_UPDATE_UPT_DIRECTION_GOOD       ",Tcontrol_t         ,_param->_nb_inst_branch_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_UPT_BTB_VAL              ," in_UPDATE_UPT_BTB_VAL              ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL( in_UPDATE_UPT_BTB_ADDRESS_SRC      ," in_UPDATE_UPT_BTB_ADDRESS_SRC      ",Taddress_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL( in_UPDATE_UPT_BTB_ADDRESS_DEST     ," in_UPDATE_UPT_BTB_ADDRESS_DEST     ",Taddress_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL( in_UPDATE_UPT_BTB_CONDITION        ," in_UPDATE_UPT_BTB_CONDITION        ",Tbranch_condition_t,_param->_nb_inst_branch_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_UPT_DIR_VAL              ," in_UPDATE_UPT_DIR_VAL              ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL( in_UPDATE_UPT_DIR_HISTORY          ," in_UPDATE_UPT_DIR_HISTORY          ",Thistory_t         ,_param->_nb_inst_branch_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_UPT_RAS_VAL              ," in_UPDATE_UPT_RAS_VAL              ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL( in_UPDATE_UPT_RAS_PUSH             ," in_UPDATE_UPT_RAS_PUSH             ",Tcontrol_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL( in_UPDATE_UPT_RAS_ADDRESS          ," in_UPDATE_UPT_RAS_ADDRESS          ",Taddress_t         ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL( in_UPDATE_UPT_RAS_INDEX            ," in_UPDATE_UPT_RAS_INDEX            ",Tptr_t             ,_param->_nb_inst_branch_update);
//ALLOC1_SC_SIGNAL( in_UPDATE_UPT_RAS_PREDICTION_IFETCH," in_UPDATE_UPT_RAS_PREDICTION_IFETCH",Tcontrol_t         ,_param->_nb_inst_branch_update);

  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Prediction_unit_Glue.\n"),name.c_str());

  (*(_Prediction_unit_Glue->in_CLOCK))        (*(in_CLOCK));
  (*(_Prediction_unit_Glue->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_VAL                         ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_ACK                         ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_PC_PREVIOUS                 ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_PC_CURRENT                  ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_PC_CURRENT_IS_DS_TAKE       ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_PC_NEXT                     ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_PC_NEXT_IS_DS_TAKE          ,_param->_nb_context);
  INSTANCE2_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_INSTRUCTION_ENABLE          ,_param->_nb_context,_param->_nb_instruction[it1]);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_BRANCH_STATE                ,_param->_nb_context);
  for (uint32_t i=0; i<_param->_nb_context; i++)
    {
      if (_param->_have_port_inst_ifetch_ptr)
        INSTANCE_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_INST_IFETCH_PTR [i]);
      if (_param->_have_port_depth)
	INSTANCE_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [i]);
    }

  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_BTB_VAL                     ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_BTB_ACK                     ,_param->_nb_inst_branch_predict);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_BTB_CONTEXT_ID              ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_BTB_ADDRESS                 ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_BTB_HIT                     ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_BTB_ADDRESS_SRC             ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_BTB_ADDRESS_DEST            ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_BTB_CONDITION               ,_param->_nb_inst_branch_predict);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_BTB_LAST_TAKE               ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_BTB_IS_ACCURATE             ,_param->_nb_inst_branch_predict);

  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_DIR_VAL                     ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_DIR_ACK                     ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_DIR_ADDRESS_SRC             ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_DIR_STATIC                  ,_param->_nb_inst_branch_predict);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_DIR_LAST_TAKE               ,_param->_nb_inst_branch_predict);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_DIR_HISTORY                 ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_DIR_DIRECTION               ,_param->_nb_inst_branch_predict);

  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_RAS_VAL                     ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_RAS_ACK                     ,_param->_nb_inst_branch_predict);

  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_RAS_CONTEXT_ID              ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_RAS_HIT                     ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_RAS_PUSH                    ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_RAS_ADDRESS_PUSH            ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_RAS_ADDRESS_POP             ,_param->_nb_inst_branch_predict);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_RAS_INDEX                   ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_UPT_VAL                     ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_UPT_ACK                     ,_param->_nb_inst_branch_predict);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_UPT_CONTEXT_ID              ,_param->_nb_inst_branch_predict);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_PREDICT_UPT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_UPT_BTB_ADDRESS_SRC         ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_UPT_BTB_ADDRESS_DEST        ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_UPT_BTB_CONDITION           ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_UPT_BTB_LAST_TAKE           ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_UPT_BTB_IS_ACCURATE         ,_param->_nb_inst_branch_predict);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_UPT_DIR_HISTORY             ,_param->_nb_inst_branch_predict);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_UPT_RAS_ADDRESS             ,_param->_nb_inst_branch_predict);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_PREDICT_UPT_RAS_INDEX               ,_param->_nb_inst_branch_predict);

  INSTANCE2_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_VAL                        ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_ACK                        ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_CONTEXT_ID                 ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_MATCH_INST_IFETCH_PTR      ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_BRANCH_STATE               ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  if (_param->_have_port_depth)
  INSTANCE2_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_BRANCH_CONDITION           ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_BRANCH_DIRECTION           ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_ADDRESS_SRC                ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_ADDRESS_DEST               ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_BTB_VAL                    ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_BTB_ACK                    ,_param->_nb_inst_branch_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_BTB_CONTEXT_ID             ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_BTB_ADDRESS_SRC            ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_BTB_ADDRESS_DEST           ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_BTB_CONDITION              ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_BTB_LAST_TAKE              ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_BTB_MISS_PREDICTION        ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_BTB_IS_ACCURATE            ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_RAS_VAL                    ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_RAS_ACK                    ,_param->_nb_inst_branch_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_RAS_CONTEXT_ID             ,_param->_nb_inst_branch_decod); 
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_RAS_HIT                    ,_param->_nb_inst_branch_decod); 
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_RAS_PUSH                   ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_RAS_ADDRESS_PUSH           ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_RAS_ADDRESS_POP            ,_param->_nb_inst_branch_decod);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_RAS_INDEX                  ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_RAS_MISS_PREDICTION        ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_VAL                    ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_DECOD_UPT_ACK                    ,_param->_nb_inst_branch_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_CONTEXT_ID             ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_BTB_ADDRESS_SRC        ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_BTB_ADDRESS_DEST       ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_BTB_CONDITION          ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_BTB_LAST_TAKE          ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_RAS_ADDRESS            ,_param->_nb_inst_branch_decod);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_RAS_INDEX              ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_MISS_IFETCH            ,_param->_nb_inst_branch_decod); 
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_MISS_DECOD             ,_param->_nb_inst_branch_decod); 
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_UPDATE_PREDICTION_ID   ,_param->_nb_inst_branch_decod);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_DECOD_UPT_IS_ACCURATE            ,_param->_nb_inst_branch_decod); 

  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_BTB_VAL                  ,_param->_nb_inst_branch_update);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_BTB_ACK                  ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_BTB_CONTEXT_ID           ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_BTB_ADDRESS_SRC          ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_BTB_ADDRESS_DEST         ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_BTB_CONDITION            ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_BTB_LAST_TAKE            ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_BTB_MISS_PREDICTION      ,_param->_nb_inst_branch_update);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_DIR_VAL                  ,_param->_nb_inst_branch_update);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_DIR_ACK                  ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_DIR_ADDRESS              ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_DIR_HISTORY              ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_DIR_DIRECTION            ,_param->_nb_inst_branch_update);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_RAS_VAL                  ,_param->_nb_inst_branch_update);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_RAS_ACK                  ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_RAS_CONTEXT_ID           ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_RAS_PUSH                 ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_RAS_ADDRESS              ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_RAS_INDEX                ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_RAS_MISS_PREDICTION      ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_RAS_PREDICTION_IFETCH    ,_param->_nb_inst_branch_update);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_VAL                  ,_param->_nb_inst_branch_update);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue,out_UPDATE_UPT_ACK                  ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_CONTEXT_ID           ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_MISS_PREDICTION      ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_DIRECTION_GOOD       ,_param->_nb_inst_branch_update);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_BTB_VAL              ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_BTB_ADDRESS_SRC      ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_BTB_ADDRESS_DEST     ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_BTB_CONDITION        ,_param->_nb_inst_branch_update);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_DIR_VAL              ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_DIR_HISTORY          ,_param->_nb_inst_branch_update);
  INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_RAS_VAL              ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_RAS_PUSH             ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_RAS_ADDRESS          ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_RAS_INDEX            ,_param->_nb_inst_branch_update);
//INSTANCE1_SC_SIGNAL(_Prediction_unit_Glue, in_UPDATE_UPT_RAS_PREDICTION_IFETCH,_param->_nb_inst_branch_update);

//   for (uint32_t i=0; i<_param->_nb_context; i++)
//     {
//       if (_param->_have_port_depth)
// 	{
// 	  INSTANCE_SC_SIGNAL(_Prediction_unit_Glue, in_DEPTH_UPT_TAIL      [i]);
// 	  INSTANCE_SC_SIGNAL(_Prediction_unit_Glue,out_DEPTH_TAIL          [i]);
// 	}
// 	  INSTANCE_SC_SIGNAL(_Prediction_unit_Glue, in_DEPTH_UPT_NB_BRANCH [i]);
// 	  INSTANCE_SC_SIGNAL(_Prediction_unit_Glue,out_DEPTH_NB_BRANCH     [i]);
//     }

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation
  const bool test1 = false;
  const bool test2 = true ;
  const bool test3 = false;
  const bool test4 = false;

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  int32_t percent_transaction_predict =  75;
  int32_t percent_transaction_decod   =  75;

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");

  for (uint32_t i=0; i<_param->_nb_context; i++)
    in_PREDICT_VAL [i]->write(0);
  for (uint32_t i=0; i<_param->_nb_inst_branch_predict; i++)
    {
      in_PREDICT_BTB_ACK         [i]->write(0);
      in_PREDICT_DIR_ACK         [i]->write(0);
      in_PREDICT_RAS_ACK         [i]->write(0);
      in_PREDICT_UPT_ACK         [i]->write(0);

      in_PREDICT_BTB_IS_ACCURATE [i]->write(1);
    }
  for (uint32_t i=0; i<_param->_nb_decod_unit; i++)
    for (uint32_t j=0; j<_param->_nb_inst_decod[i]; j++)
      in_DECOD_VAL [i][j]->write(0);

  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");


  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      if (test1)
      {
	LABEL("Test sequential");
	uint32_t context = rand()%_param->_nb_context;
	LABEL("context : %d",context);

	for (uint32_t i=0; i<_param->_nb_instruction [context]; i++)
	  {
	    Taddress_t addr = (1<<(_param->_nb_instruction[context]+4))+i;
	    
	    in_PREDICT_PC_PREVIOUS           [context]->write(0);
	    in_PREDICT_PC_CURRENT            [context]->write(addr);
	    in_PREDICT_PC_CURRENT_IS_DS_TAKE [context]->write(0);

	    bool find = false;

	    do
	      {
		for (uint32_t j=0; j<_param->_nb_inst_branch_predict; j++)
		  in_PREDICT_BTB_ACK [j]->write(0);

		in_PREDICT_VAL [context]->write((rand()%100)<percent_transaction_predict);

		SC_START(0);

		uint32_t port;
		for (port=0; port<_param->_nb_inst_branch_predict; port++)
		  {
		    if (_param->_have_port_context_id)
		    LABEL(" * BTB context : 0x%x",out_PREDICT_BTB_CONTEXT_ID [port]->read());
		    LABEL(" * BTB address : 0x%x",out_PREDICT_BTB_ADDRESS    [port]->read());
		    if ((out_PREDICT_BTB_CONTEXT_ID [port]->read() == context) and
			(out_PREDICT_BTB_ADDRESS    [port]->read() == addr   ))
		      {
			in_PREDICT_BTB_ACK [port]->write((rand()%100)<percent_transaction_predict);
			in_PREDICT_BTB_HIT [port]->write(0);
			break;
		      }
		  }

		SC_START(0);

		if (in_PREDICT_VAL[context]->read() and out_PREDICT_ACK[context]->read())
		  {
		    LABEL ("PREDICT         [%d] - Transaction accepted",context);
		    find = true;

		    TEST(Taddress_t        ,out_PREDICT_PC_NEXT                     [context]->read(),addr-i+_param->_nb_instruction[context]);
		    TEST(Tcontrol_t        ,out_PREDICT_PC_NEXT_IS_DS_TAKE          [context]->read(),0);
		    TEST(Tinst_ifetch_ptr_t,out_PREDICT_INST_IFETCH_PTR             [context]->read(),0);
		    TEST(Tbranch_state_t   ,out_PREDICT_BRANCH_STATE                [context]->read(),BRANCH_STATE_NONE);
		    TEST(Tprediction_ptr_t ,out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [context]->read(),0);
		    
		    for (uint32_t j=0; j<i; j++)
		      TEST(Tcontrol_t        ,out_PREDICT_INSTRUCTION_ENABLE [context][j]->read(),0);
		    for (uint32_t j=i; j<_param->_nb_instruction[context]; j++)
		      TEST(Tcontrol_t        ,out_PREDICT_INSTRUCTION_ENABLE [context][j]->read(),1);
		    
		    TEST(Tcontrol_t        ,out_PREDICT_BTB_VAL        [port]->read(),1); 
		    TEST(Tcontext_t        ,out_PREDICT_BTB_CONTEXT_ID [port]->read(),context);
		    TEST(Taddress_t        ,out_PREDICT_BTB_ADDRESS    [port]->read(),addr);
		  }

		SC_START(1);

	      } while(not find);

	  
	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      in_PREDICT_VAL [i]->write(0);
	    for (uint32_t i=0; i<_param->_nb_inst_branch_predict; i++)
	      {
		in_PREDICT_BTB_ACK [i]->write(0);
		in_PREDICT_DIR_ACK [i]->write(0);
		in_PREDICT_RAS_ACK [i]->write(0);
		in_PREDICT_UPT_ACK [i]->write(0);
	      }
	  }
      }

      if (test2)
      {
      	LABEL("Test no sequential - L.J");
	uint32_t context = rand()%_param->_nb_context;
	
	LABEL("context : %d",context);

	for (uint32_t i=0; i<_param->_nb_instruction [context]; i++)
	  {
	    Taddress_t pc_current  = (1<<(_param->_nb_instruction[context]+3));
            Taddress_t pc_previous = pc_current-1;
	    Taddress_t addr_src  = pc_current+i;
	    Taddress_t addr_dest = 0xdeadbeef;
	    Tcontrol_t is_ds_take= rand()%2;

	    in_PREDICT_PC_PREVIOUS           [context]->write(pc_previous);
	    in_PREDICT_PC_CURRENT            [context]->write(pc_current);
	    in_PREDICT_PC_CURRENT_IS_DS_TAKE [context]->write(is_ds_take);

	    bool find = false;
	    
	    do
	      {
		for (uint32_t j=0; j<_param->_nb_inst_branch_predict; j++)
		  in_PREDICT_BTB_ACK [j]->write(0);

		in_PREDICT_VAL [context]->write((rand()%100)<percent_transaction_predict);

		SC_START(0);

		uint32_t port;
		for (port=0; port<_param->_nb_inst_branch_predict; port++)
		  {
		    if (_param->_have_port_context_id)
		    LABEL(" * BTB context : 0x%x",out_PREDICT_BTB_CONTEXT_ID [port]->read());
		    LABEL(" * BTB address : 0x%x",out_PREDICT_BTB_ADDRESS    [port]->read());
		    if ((out_PREDICT_BTB_CONTEXT_ID [port]->read() == context) and
			(out_PREDICT_BTB_ADDRESS    [port]->read() == (is_ds_take)?pc_previous:pc_current   ))
		      {
			in_PREDICT_BTB_ACK          [port]->write((rand()%100)<percent_transaction_predict);
			in_PREDICT_BTB_HIT          [port]->write(1);

			in_PREDICT_BTB_ADDRESS_SRC  [port]->write(addr_src );
			in_PREDICT_BTB_ADDRESS_DEST [port]->write(addr_dest);
			in_PREDICT_BTB_CONDITION    [port]->write(BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK); //l.j
		      //in_PREDICT_BTB_LAST_TAKE

			break;
		      }
		  }

		SC_START(0);

                LABEL ("PREDICT_VAL : %d", in_PREDICT_VAL[context]->read());
                LABEL ("PREDICT_ACK : %d",out_PREDICT_ACK[context]->read());
                
		if (in_PREDICT_VAL[context]->read() and out_PREDICT_ACK[context]->read())
		  {
		    LABEL ("PREDICT         [%d] - Transaction accepted",context);
		    LABEL ("  * pc_previous: 0x%x",pc_previous );
		    LABEL ("  * pc_current : 0x%x",pc_current      );
		    LABEL ("  * addr_src   : 0x%x",addr_src  );
		    LABEL ("  * addr_dest  : 0x%x",addr_dest );
		    LABEL ("  * is_ds_take : %d"  ,is_ds_take);

		    find = true;
                    
                    Tcontrol_t next_is_ds_take = (not is_ds_take and (i==(_param->_nb_instruction [context]-1)));

                    TEST(Tcontrol_t        ,out_PREDICT_PC_NEXT_IS_DS_TAKE          [context]->read(), next_is_ds_take);
		    TEST(Taddress_t        ,out_PREDICT_PC_NEXT                     [context]->read(),(next_is_ds_take)?(addr_src+1):addr_dest);
		    TEST(Tinst_ifetch_ptr_t,out_PREDICT_INST_IFETCH_PTR             [context]->read(),i);
                    TEST(Tbranch_state_t   ,out_PREDICT_BRANCH_STATE                [context]->read(),(next_is_ds_take)?BRANCH_STATE_NONE:BRANCH_STATE_NSPEC_TAKE);
// 		    TEST(Tprediction_ptr_t ,out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [context]->read(),0);

		    uint32_t k=((is_ds_take)?1:((next_is_ds_take)?_param->_nb_instruction[context]:((addr_src%_param->_nb_instruction [context])+2)));


// ((addr_src%_param->_nb_instruction[context])==_param->_nb_instruction[context]-1)?_param->_nb_instruction[context]:((addr_src%_param->_nb_instruction[context])+2);

		    LABEL("instruction enable : ");
		    LABEL("  [0:%d[ = 1",k);
		    LABEL("  [%d:%d[ = 0",k,_param->_nb_instruction[context]);
		    for (uint32_t j=0; j<k; j++)
		    TEST(Tcontrol_t        ,out_PREDICT_INSTRUCTION_ENABLE [context][j]->read(),1);
		    for (uint32_t j=k; j<_param->_nb_instruction[context]; j++)
		    TEST(Tcontrol_t        ,out_PREDICT_INSTRUCTION_ENABLE [context][j]->read(),0);

		    TEST(Tcontrol_t        ,out_PREDICT_BTB_VAL        [port]->read(),1); 
		    TEST(Tcontext_t        ,out_PREDICT_BTB_CONTEXT_ID [port]->read(),context);
		    TEST(Taddress_t        ,out_PREDICT_BTB_ADDRESS    [port]->read(),(is_ds_take)?pc_previous:pc_current);
		  }
		
		SC_START(1);

	      } while(not find);	    

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      in_PREDICT_VAL [i]->write(0);
	    for (uint32_t i=0; i<_param->_nb_inst_branch_predict; i++)
	      {
		in_PREDICT_BTB_ACK [i]->write(0);
		in_PREDICT_DIR_ACK [i]->write(0);
		in_PREDICT_RAS_ACK [i]->write(0);
		in_PREDICT_UPT_ACK [i]->write(0);
	      }
	  }
      }
      
      if (test3)
      {
	LABEL("Decod - Ok");
	uint32_t decod_unit = rand()%_param->_nb_decod_unit;
	LABEL("decod_unit : %d",decod_unit);

	for (uint32_t i=0; i<_param->_nb_inst_decod[i];i++)
	  {
	    Tcontext_t context = i%_param->_nb_context;
	    in_DECOD_CONTEXT_ID                  [decod_unit][i]->write(context);
	    in_DECOD_MATCH_INST_IFETCH_PTR       [decod_unit][i]->write(1);
	    in_DECOD_BRANCH_STATE                [decod_unit][i]->write(BRANCH_STATE_NSPEC_TAKE);

	    bool find = false;
	    do
	      {
		in_DECOD_VAL                         [decod_unit][i]->write((rand()%100)<percent_transaction_decod);
		in_DECOD_BRANCH_UPDATE_PREDICTION_ID [decod_unit][i]->write(rand()%_param->_array_size_depth[context]);
		
		in_DECOD_BTB_ACK[0]->write((rand()%100)<percent_transaction_decod);
		in_DECOD_RAS_ACK[0]->write((rand()%100)<percent_transaction_decod);
		in_DECOD_UPT_ACK[0]->write((rand()%100)<percent_transaction_decod);
		
		SC_START(0);
	    
		LABEL("DECOD[%d][%d] - %d %d",decod_unit,i,in_DECOD_VAL[decod_unit][i]->read(),out_DECOD_ACK[decod_unit][i]->read());
		if (in_DECOD_VAL[decod_unit][i]->read() and out_DECOD_ACK[decod_unit][i]->read())
		  {
		    LABEL("DECOD[%d][%d] - Transaction Accepted",decod_unit,i);
		    TEST(Tcontrol_t, in_DECOD_UPT_ACK[0]->read(),1);
		    TEST(Tcontrol_t,out_DECOD_BTB_VAL[0]->read(),0);
		    TEST(Tcontrol_t,out_DECOD_RAS_VAL[0]->read(),0);
		    TEST(Tcontrol_t,out_DECOD_UPT_VAL[0]->read(),1);
		    find = true;
		  }

		SC_START(1);

	      } while (not find);

	    in_DECOD_VAL    [decod_unit][i]->write(0);
	    in_DECOD_BTB_ACK[0]->write(0);
	    in_DECOD_RAS_ACK[0]->write(0);
	    in_DECOD_UPT_ACK[0]->write(0);
	  }
      }

      if (test4)
      {
	LABEL("Decod - Ko");
	uint32_t decod_unit = rand()%_param->_nb_decod_unit;
	LABEL("decod_unit : %d",decod_unit);

	for (uint32_t i=0; i<_param->_nb_inst_decod[i];i++)
	  {
	    Tcontext_t context = i%_param->_nb_context;
	    in_DECOD_CONTEXT_ID                  [decod_unit][i]->write(context);
	    in_DECOD_MATCH_INST_IFETCH_PTR       [decod_unit][i]->write(0);
	    in_DECOD_BRANCH_STATE                [decod_unit][i]->write(BRANCH_STATE_SPEC_TAKE);
	    in_DECOD_BRANCH_UPDATE_PREDICTION_ID [decod_unit][i]->write(i%_param->_size_depth);
	    in_DECOD_BRANCH_CONDITION            [decod_unit][i]->write(BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK);
	    in_DECOD_BRANCH_DIRECTION            [decod_unit][i]->write(1);
	    in_DECOD_ADDRESS_SRC                 [decod_unit][i]->write(0xdeadbeef+i);
	    in_DECOD_ADDRESS_DEST                [decod_unit][i]->write(0x11061979+i);

                                                                                      
	    bool find = false;
	    do
	      {
		in_DECOD_VAL                         [decod_unit][i]->write((rand()%100)<percent_transaction_decod);
		
		in_DECOD_BTB_ACK[0]->write((rand()%100)<percent_transaction_decod);
		in_DECOD_RAS_ACK[0]->write((rand()%100)<percent_transaction_decod);
		in_DECOD_UPT_ACK[0]->write((rand()%100)<percent_transaction_decod);

		in_DECOD_RAS_HIT[0]->write(1);
		in_DECOD_RAS_ADDRESS_POP[0]->write(0xdadedead+i);

		
		SC_START(0);
	    
		LABEL("DECOD[%d][%d] - %d %d",decod_unit,i,in_DECOD_VAL[decod_unit][i]->read(),out_DECOD_ACK[decod_unit][i]->read());
		if (in_DECOD_VAL[decod_unit][i]->read() and out_DECOD_ACK[decod_unit][i]->read())
		  {
		    LABEL("DECOD[%d][%d] - Transaction Accepted",decod_unit,i);
		    TEST(Tcontrol_t         , in_DECOD_UPT_ACK                  [0]->read(),1);
		    TEST(Tcontrol_t         ,out_DECOD_BTB_VAL                  [0]->read(),1);
		    TEST(Tcontrol_t         ,out_DECOD_RAS_VAL                  [0]->read(),1);
		    TEST(Tcontrol_t         ,out_DECOD_UPT_VAL                  [0]->read(),1);

		    TEST(Tcontext_t         ,out_DECOD_BTB_CONTEXT_ID           [0]->read(),context);
		    TEST(Taddress_t         ,out_DECOD_BTB_ADDRESS_SRC          [0]->read(),0xdeadbeef+i);
		    TEST(Taddress_t         ,out_DECOD_BTB_ADDRESS_DEST         [0]->read(),0x11061979+i);
		    TEST(Tbranch_condition_t,out_DECOD_BTB_CONDITION            [0]->read(),BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK);
		    TEST(Tcontrol_t         ,out_DECOD_BTB_LAST_TAKE            [0]->read(),1);
		    TEST(Tcontrol_t         ,out_DECOD_BTB_MISS_PREDICTION      [0]->read(),1);
		    TEST(Tcontrol_t         ,out_DECOD_BTB_IS_ACCURATE          [0]->read(),0);
		    TEST(Tcontext_t         ,out_DECOD_RAS_CONTEXT_ID           [0]->read(),context); 
		    TEST(Tcontrol_t         ,out_DECOD_RAS_PUSH                 [0]->read(),1);
		    TEST(Taddress_t         ,out_DECOD_RAS_ADDRESS_PUSH         [0]->read(),0xdeadbeef+i+2);
		    TEST(Tcontrol_t         ,out_DECOD_RAS_MISS_PREDICTION      [0]->read(),1);
		    TEST(Tcontext_t         ,out_DECOD_UPT_CONTEXT_ID           [0]->read(),context);
		    TEST(Taddress_t         ,out_DECOD_UPT_BTB_ADDRESS_SRC      [0]->read(),0xdeadbeef+i);
		    TEST(Taddress_t         ,out_DECOD_UPT_BTB_ADDRESS_DEST     [0]->read(),0x11061979+i);
		    TEST(Tbranch_condition_t,out_DECOD_UPT_BTB_CONDITION        [0]->read(),BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK);
		    TEST(Tcontrol_t         ,out_DECOD_UPT_BTB_LAST_TAKE        [0]->read(),1);
		    TEST(Taddress_t         ,out_DECOD_UPT_RAS_ADDRESS          [0]->read(),0xdadedead+i);
		    TEST(Tcontrol_t         ,out_DECOD_UPT_MISS_IFETCH          [0]->read(),1); 
		    TEST(Tcontrol_t         ,out_DECOD_UPT_MISS_DECOD           [0]->read(),0); 
		    TEST(Tprediction_ptr_t  ,out_DECOD_UPT_UPDATE_PREDICTION_ID [0]->read(),i%_param->_size_depth);
		    TEST(Tcontrol_t         ,out_DECOD_UPT_IS_ACCURATE          [0]->read(),0); 

		    find = true;
		  }

		SC_START(1);

	      } while (not find);

	    in_DECOD_VAL    [decod_unit][i]->write(0);
	    in_DECOD_BTB_ACK[0]->write(0);
	    in_DECOD_RAS_ACK[0]->write(0);
	    in_DECOD_UPT_ACK[0]->write(0);
	  }
      }

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL( in_PREDICT_VAL                         ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_ACK                         ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_PREDICT_PC_PREVIOUS                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_PREDICT_PC_CURRENT                  ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_PREDICT_PC_CURRENT_IS_DS_TAKE       ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_PC_NEXT                     ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_PC_NEXT_IS_DS_TAKE          ,_param->_nb_context);
  DELETE2_SC_SIGNAL(out_PREDICT_INSTRUCTION_ENABLE          ,_param->_nb_context,_param->_nb_instruction[it1]);
  DELETE1_SC_SIGNAL(out_PREDICT_INST_IFETCH_PTR             ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_STATE                ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_BTB_VAL                     ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_BTB_ACK                     ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_BTB_CONTEXT_ID              ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_BTB_ADDRESS                 ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_BTB_HIT                     ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_BTB_ADDRESS_SRC             ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_BTB_ADDRESS_DEST            ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_BTB_CONDITION               ,_param->_nb_inst_branch_predict);
//DELETE1_SC_SIGNAL( in_PREDICT_BTB_LAST_TAKE               ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_BTB_IS_ACCURATE             ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_DIR_VAL                     ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_DIR_ACK                     ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_DIR_ADDRESS_SRC             ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_DIR_STATIC                  ,_param->_nb_inst_branch_predict);
//DELETE1_SC_SIGNAL(out_PREDICT_DIR_LAST_TAKE               ,_param->_nb_inst_branch_predict);
//DELETE1_SC_SIGNAL( in_PREDICT_DIR_HISTORY                 ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_DIR_DIRECTION               ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_RAS_VAL                     ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_RAS_ACK                     ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_RAS_CONTEXT_ID              ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_RAS_HIT                     ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_RAS_PUSH                    ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_RAS_ADDRESS_PUSH            ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_RAS_ADDRESS_POP             ,_param->_nb_inst_branch_predict);
//DELETE1_SC_SIGNAL( in_PREDICT_RAS_INDEX                   ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_UPT_VAL                     ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_UPT_ACK                     ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL( in_PREDICT_UPT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_UPT_CONTEXT_ID              ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_UPT_BTB_ADDRESS_SRC         ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_UPT_BTB_ADDRESS_DEST        ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_UPT_BTB_CONDITION           ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_UPT_BTB_LAST_TAKE           ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_UPT_BTB_IS_ACCURATE         ,_param->_nb_inst_branch_predict);
//DELETE1_SC_SIGNAL(out_PREDICT_UPT_DIR_HISTORY             ,_param->_nb_inst_branch_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_UPT_RAS_ADDRESS             ,_param->_nb_inst_branch_predict);
//DELETE1_SC_SIGNAL(out_PREDICT_UPT_RAS_INDEX               ,_param->_nb_inst_branch_predict);
//   DELETE1_SC_SIGNAL( in_DEPTH_UPT_NB_BRANCH                 ,_param->_nb_context);
//   DELETE1_SC_SIGNAL( in_DEPTH_UPT_TAIL                      ,_param->_nb_context);
//   DELETE1_SC_SIGNAL(out_DEPTH_NB_BRANCH                     ,_param->_nb_context);
//   DELETE1_SC_SIGNAL(out_DEPTH_TAIL                          ,_param->_nb_context);

  DELETE2_SC_SIGNAL( in_DECOD_VAL                        ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL(out_DECOD_ACK                        ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_DECOD_CONTEXT_ID                 ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_DECOD_MATCH_INST_IFETCH_PTR      ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_DECOD_BRANCH_STATE               ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_DECOD_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_DECOD_BRANCH_CONDITION           ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_DECOD_BRANCH_DIRECTION           ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_DECOD_ADDRESS_SRC                ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_DECOD_ADDRESS_DEST               ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
  DELETE1_SC_SIGNAL(out_DECOD_BTB_VAL                    ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL( in_DECOD_BTB_ACK                    ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_BTB_CONTEXT_ID             ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_BTB_ADDRESS_SRC            ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_BTB_ADDRESS_DEST           ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_BTB_CONDITION              ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_BTB_LAST_TAKE              ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_BTB_MISS_PREDICTION        ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_BTB_IS_ACCURATE            ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_RAS_VAL                    ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL( in_DECOD_RAS_ACK                    ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_RAS_CONTEXT_ID             ,_param->_nb_inst_branch_decod); 
  DELETE1_SC_SIGNAL( in_DECOD_RAS_HIT                    ,_param->_nb_inst_branch_decod); 
  DELETE1_SC_SIGNAL(out_DECOD_RAS_PUSH                   ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_RAS_ADDRESS_PUSH           ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL( in_DECOD_RAS_ADDRESS_POP            ,_param->_nb_inst_branch_decod);
//DELETE1_SC_SIGNAL( in_DECOD_RAS_INDEX                  ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_RAS_MISS_PREDICTION        ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_UPT_VAL                    ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL( in_DECOD_UPT_ACK                    ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_UPT_CONTEXT_ID             ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_UPT_BTB_ADDRESS_SRC        ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_UPT_BTB_ADDRESS_DEST       ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_UPT_BTB_CONDITION          ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_UPT_BTB_LAST_TAKE          ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_UPT_RAS_ADDRESS            ,_param->_nb_inst_branch_decod);
//DELETE1_SC_SIGNAL(out_DECOD_UPT_RAS_INDEX              ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_UPT_MISS_IFETCH            ,_param->_nb_inst_branch_decod); 
  DELETE1_SC_SIGNAL(out_DECOD_UPT_MISS_DECOD             ,_param->_nb_inst_branch_decod); 
  DELETE1_SC_SIGNAL(out_DECOD_UPT_UPDATE_PREDICTION_ID   ,_param->_nb_inst_branch_decod);
  DELETE1_SC_SIGNAL(out_DECOD_UPT_IS_ACCURATE            ,_param->_nb_inst_branch_decod); 

  DELETE1_SC_SIGNAL(out_UPDATE_BTB_VAL                  ,_param->_nb_inst_branch_update);
  DELETE1_SC_SIGNAL( in_UPDATE_BTB_ACK                  ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_BTB_CONTEXT_ID           ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_BTB_ADDRESS_SRC          ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_BTB_ADDRESS_DEST         ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_BTB_CONDITION            ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_BTB_LAST_TAKE            ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_BTB_MISS_PREDICTION      ,_param->_nb_inst_branch_update);
  DELETE1_SC_SIGNAL(out_UPDATE_DIR_VAL                  ,_param->_nb_inst_branch_update);
  DELETE1_SC_SIGNAL( in_UPDATE_DIR_ACK                  ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_DIR_ADDRESS              ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_DIR_HISTORY              ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_DIR_DIRECTION            ,_param->_nb_inst_branch_update);
  DELETE1_SC_SIGNAL(out_UPDATE_RAS_VAL                  ,_param->_nb_inst_branch_update);
  DELETE1_SC_SIGNAL( in_UPDATE_RAS_ACK                  ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_RAS_CONTEXT_ID           ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_RAS_PUSH                 ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_RAS_ADDRESS              ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_RAS_INDEX                ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_RAS_MISS_PREDICTION      ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL(out_UPDATE_RAS_PREDICTION_IFETCH    ,_param->_nb_inst_branch_update);
  DELETE1_SC_SIGNAL( in_UPDATE_UPT_VAL                  ,_param->_nb_inst_branch_update);
  DELETE1_SC_SIGNAL(out_UPDATE_UPT_ACK                  ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL( in_UPDATE_UPT_CONTEXT_ID           ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL( in_UPDATE_UPT_MISS_PREDICTION      ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL( in_UPDATE_UPT_DIRECTION_GOOD       ,_param->_nb_inst_branch_update);
  DELETE1_SC_SIGNAL( in_UPDATE_UPT_BTB_VAL              ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL( in_UPDATE_UPT_BTB_ADDRESS_SRC      ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL( in_UPDATE_UPT_BTB_ADDRESS_DEST     ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL( in_UPDATE_UPT_BTB_CONDITION        ,_param->_nb_inst_branch_update);
  DELETE1_SC_SIGNAL( in_UPDATE_UPT_DIR_VAL              ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL( in_UPDATE_UPT_DIR_HISTORY          ,_param->_nb_inst_branch_update);
  DELETE1_SC_SIGNAL( in_UPDATE_UPT_RAS_VAL              ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL( in_UPDATE_UPT_RAS_PUSH             ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL( in_UPDATE_UPT_RAS_ADDRESS          ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL( in_UPDATE_UPT_RAS_INDEX            ,_param->_nb_inst_branch_update);
//DELETE1_SC_SIGNAL( in_UPDATE_UPT_RAS_PREDICTION_IFETCH,_param->_nb_inst_branch_update);

    }
#endif

  delete _Prediction_unit_Glue;

#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
