/*
 * $Id: Queue_deallocation.cpp 100 2009-01-08 13:06:27Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Queue/include/Queue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace queue {


#undef  FUNCTION
#define FUNCTION "Queue::deallocation"
  void Queue::deallocation (void)
  {
    log_printf(FUNC,Queue,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      { 
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE0_SIGNAL( in_INSERT_VAL                        ,1);
        DELETE0_SIGNAL(out_INSERT_ACK                        ,1);
        DELETE0_SIGNAL( in_INSERT_DATA                       ,_param->_size_data);

        DELETE0_SIGNAL(out_RETIRE_VAL                        ,1);
        DELETE0_SIGNAL( in_RETIRE_ACK                        ,1);
        DELETE0_SIGNAL(out_RETIRE_DATA                       ,_param->_size_data);

        DELETE1_SIGNAL(out_SLOT_VAL    ,_param->_nb_port_slot,1);
        DELETE1_SIGNAL(out_SLOT_DATA   ,_param->_nb_port_slot,_param->_size_data);
	
        // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
        delete _queue_control;
        delete _queue_data;
      }

    delete _component;

    log_printf(FUNC,Queue,FUNCTION,"End");
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
