#!/bin/bash

#-----------------------------------------------------------
# $Id: xilinx_extract_info.sh 100 2009-01-08 13:06:27Z rosiere $
#-----------------------------------------------------------

##-----[ usage ]---------------------------------------------
#function usage ()
#{
#    echo "Usage     : ${0} [files]";
#    echo "Arguments : ";
#    echo ' * files : lists of files. If empty, take *.fpga.log';
##   echo "Notes     :";
##   echo " * Morpheo's environnement must be positionned.";
#
#    exit;
#}

#-----[ info ]----------------------------------------------
function info ()
{
    echo "===== ${1}";
    grep "Number of Slice Registers" ${1};
    grep "Number of Slice LUTs"      ${1};
    grep "Number used as Logic"      ${1};
    grep "Number used as Memory"     ${1};
    grep "Number used as RAM"        ${1};
    grep "Maximum Frequency"         ${1};
}

#-----[ main ]----------------------------------------------
function main ()
{
    if test $# -eq 0; then
        files="*.fpga.log";
    else
        files="$*";
    fi;

    for i in $files; do
        info $i;
    done
}

#-----[ Corps ]---------------------------------------------
main ${*}

