/*
 * Test_021
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.j
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        l.and r1, r0, r0 /* counter 1 */
        l.ori r2, r0, 10 /* limit */
        

_go0    :
        l.j     _go1
        l.nop
        l.j     _end_ko
        l.nop

_go2    :        
        l.j     _go3
        l.nop
        l.j     _end_ko
        l.nop

_go1    :
        l.j     _go2
        l.nop
        l.j     _end_ko
        l.nop

_go3    :
        l.j     _go4
        l.nop
        l.j     _end_ko
        l.nop
        
_go4    :
        l.addi  r1, r1, 1
        l.sfeq  r1, r2
        l.bf    _end_ok
        l.nop
        l.j     _go0
        l.nop
        l.j     _end_ko
        l.nop
