/*
 * Test_009
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.add
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /*
             A (r1)     B (r2)     - D (r3 wait)CY OV (SR = r6, mask SR = r5)
                                       (r4)                (r7)
          1) 0x00000000 0x00000000 - 0x00000000 0  0
          2) 0x14011959 0x25071959 - 0x390832b2 0  0
          3) 0xebfee6a7 0xdaf8e6a7 - 0xc6f7cd4e 1  0
          4) 0xebfee6a7 0x25071959 - 0x11060000 1  0
          5) 0x14011959 0xdaf8e6a7 - 0xeefa0000 0  0
          6) 0x87654321 0xabcdef01 - 0x33333222 1  1
          7) 0x789abcde 0x08765432 - 0x81111110 0  1
          */

        /* Mask to read OV (SR[11]), CY (SR[10]) and not F (SR[9]) */
	l.movhi r5,     hi(0x00000c00)
	l.ori   r5, r5, lo(0x00000c00)
        
        /**********/
        /* Test 1 */
        /**********/
	l.movhi r1,     hi(0x00000000) /* RA */
	l.ori   r1, r1, lo(0x00000000)
	l.movhi r2,     hi(0x00000000) /* RB */
	l.ori   r2, r2, lo(0x00000000)
	l.movhi r3,     hi(0x00000000) /* RD wait */
	l.ori   r3, r3, lo(0x00000000)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.add   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 2 */
        /**********/
	l.movhi r1,     hi(0x14011959) /* RA */
	l.ori   r1, r1, lo(0x14011959)
	l.movhi r2,     hi(0x25071959) /* RB */
	l.ori   r2, r2, lo(0x25071959)
	l.movhi r3,     hi(0x390832b2) /* RD wait */
	l.ori   r3, r3, lo(0x390832b2)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.add   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 3 */
        /**********/
	l.movhi r1,     hi(0xebfee6a7) /* RA */
	l.ori   r1, r1, lo(0xebfee6a7)
	l.movhi r2,     hi(0xdaf8e6a7) /* RB */
	l.ori   r2, r2, lo(0xdaf8e6a7)
	l.movhi r3,     hi(0xc6f7cd4e) /* RD wait */
	l.ori   r3, r3, lo(0xc6f7cd4e)
	l.movhi r6,     hi(0x00000400) /* SR wait */
	l.ori   r6, r6, lo(0x00000400)
        
        l.add   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 4 */
        /**********/
	l.movhi r1,     hi(0xebfee6a7) /* RA */
	l.ori   r1, r1, lo(0xebfee6a7)
	l.movhi r2,     hi(0x25071959) /* RB */
	l.ori   r2, r2, lo(0x25071959)
	l.movhi r3,     hi(0x11060000) /* RD wait */
	l.ori   r3, r3, lo(0x11060000)
	l.movhi r6,     hi(0x00000400) /* SR wait */
	l.ori   r6, r6, lo(0x00000400)
        
        l.add   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 5 */
        /**********/
	l.movhi r1,     hi(0x14011959) /* RA */
	l.ori   r1, r1, lo(0x14011959)
	l.movhi r2,     hi(0xdaf8e6a7) /* RB */
	l.ori   r2, r2, lo(0xdaf8e6a7)
	l.movhi r3,     hi(0xeefa0000) /* RD wait */
	l.ori   r3, r3, lo(0xeefa0000)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.add   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 6 */
        /**********/
	l.movhi r1,     hi(0x87654321) /* RA */
	l.ori   r1, r1, lo(0x87654321)
	l.movhi r2,     hi(0xabcdef01) /* RB */
	l.ori   r2, r2, lo(0xabcdef01)
	l.movhi r3,     hi(0x33333222) /* RD wait */
	l.ori   r3, r3, lo(0x33333222)
	l.movhi r6,     hi(0x00000c00) /* SR wait */
	l.ori   r6, r6, lo(0x00000c00)
        
        l.add   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 7 */
        /**********/
	l.movhi r1,     hi(0x789abcde) /* RA */
	l.ori   r1, r1, lo(0x789abcde)
	l.movhi r2,     hi(0x08765432) /* RB */
	l.ori   r2, r2, lo(0x08765432)
	l.movhi r3,     hi(0x81111110) /* RD wait */
	l.ori   r3, r3, lo(0x81111110)
	l.movhi r6,     hi(0x00000800) /* SR wait */
	l.ori   r6, r6, lo(0x00000800)
        
        l.add   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* End */
        /**********/

        l.j     _end_ok
        l.nop
