/*
 * $Id: Queue_allocation.cpp 100 2009-01-08 13:06:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Queue/include/Queue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace queue {



#undef  FUNCTION
#define FUNCTION "Queue::allocation"
  void Queue::allocation (void)
  {
    log_printf(FUNC,Queue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Queue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE("insert", IN, WEST, _("Interface of data write."));
      
      ALLOC0_VALACK_IN ( in_INSERT_VAL  ,VAL);
      ALLOC0_VALACK_OUT(out_INSERT_ACK  ,ACK);
      ALLOC0_SIGNAL_IN ( in_INSERT_DATA ,"data",Tdata_t,_param->_size_data);
    }

    // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE("retire", OUT, EAST, _("Interface of data read."));
      
      ALLOC0_VALACK_OUT(out_RETIRE_VAL  ,VAL);
      ALLOC0_VALACK_IN ( in_RETIRE_ACK  ,ACK);
      ALLOC0_SIGNAL_OUT(out_RETIRE_DATA ,"data",Tdata_t,_param->_size_data);
    }

    // ~~~~~[ Interface "slot" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("slot", OUT, EAST, _("Internal slot."),_param->_nb_port_slot);
      
      ALLOC1_VALACK_OUT(out_SLOT_VAL  ,VAL);
      ALLOC1_SIGNAL_OUT(out_SLOT_DATA ,"data",Tdata_t,_param->_size_data);
    }
     
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    _queue_control = new morpheo::behavioural::generic::queue_control::Queue_Control::Queue_Control(_param->_size_queue);
    _queue_data    = new Tdata_t [_param->_size_queue];
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Queue,FUNCTION,"End");
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
