#ifdef VHDL
/*
 * $Id: Execute_queue_vhdl.cpp 100 2009-01-08 13:06:27Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"
#include "Behavioural/include/Vhdl.h"
#include "Behavioural/Generic/Queue/include/Queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {


#undef  FUNCTION
#define FUNCTION "Execute_queue::vhdl"
  void Execute_queue::vhdl (void)
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");

    //----- Queue -----
   
    morpheo::behavioural::generic::queue::Parameters * param_queue;
    morpheo::behavioural::generic::queue::Queue      * queue;
    
    param_queue = new morpheo::behavioural::generic::queue::Parameters
      (_param->_size_queue,
       _param->_size_internal_queue,
       0
       );
    
    std::string queue_name = _name + "_queue";
    queue = new morpheo::behavioural::generic::queue::Queue
      (queue_name.c_str()
#ifdef STATISTICS
       ,NULL
#endif
       ,param_queue
       ,USE_VHDL);
    
    _component->set_component(queue->_component
#ifdef POSITION
                              , 0, 0, 0, 0
#endif
                              , INSTANCE_LIBRARY
                              );

    Vhdl * vhdl = new Vhdl (_name);

    _interfaces->set_port(vhdl);
    _component->vhdl_instance(vhdl);

    vhdl_declaration (vhdl);
    vhdl_body        (vhdl);

    vhdl->generate_file();

    delete vhdl;

    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
