/*
 * Test_018
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.extbs, l.extbz, l.exths, l.exthz
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:

        /**********/
        /* Test 1 */
        /**********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r2,     hi(0x00000078) /* RD wait */
	l.ori   r2, r2, lo(0x00000078)

        l.extbs r3, r1

        /* Test result */
        l.sfeq  r3, r2
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 2 */
        /**********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0xffffffef) /* RD wait */
	l.ori   r2, r2, lo(0xffffffef)

        l.extbs r3, r1

        /* Test result */
        l.sfeq  r3, r2
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 3 */
        /**********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r2,     hi(0x00000078) /* RD wait */
	l.ori   r2, r2, lo(0x00000078)

        l.extbz r3, r1

        /* Test result */
        l.sfeq  r3, r2
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 4 */
        /**********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x000000ef) /* RD wait */
	l.ori   r2, r2, lo(0x000000ef)

        l.extbz r3, r1

        /* Test result */
        l.sfeq  r3, r2
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 5 */
        /**********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r2,     hi(0x00005678) /* RD wait */
	l.ori   r2, r2, lo(0x00005678)

        l.exths r3, r1

        /* Test result */
        l.sfeq  r3, r2
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 6 */
        /**********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0xffffbeef) /* RD wait */
	l.ori   r2, r2, lo(0xffffbeef)

        l.exths r3, r1

        /* Test result */
        l.sfeq  r3, r2
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 7 */
        /**********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r2,     hi(0x00005678) /* RD wait */
	l.ori   r2, r2, lo(0x00005678)

        l.exthz r3, r1

        /* Test result */
        l.sfeq  r3, r2
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 8 */
        /**********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000beef) /* RD wait */
	l.ori   r2, r2, lo(0x0000beef)

        l.exthz r3, r1

        /* Test result */
        l.sfeq  r3, r2
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* End */
        /**********/

        l.j     _end_ok
        l.nop
