/*
 * Test_019
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.ff1
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:

        /**********/
        /* Test 1 */
        /**********/
	l.movhi r1,     hi(0xffffffff) /* RA */
	l.ori   r1, r1, lo(0xffffffff)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 1
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 2 */
        /**********/
	l.movhi r1,     hi(0xfffffffe) /* RA */
	l.ori   r1, r1, lo(0xfffffffe)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 2
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 3 */
        /**********/
	l.movhi r1,     hi(0xfffffffc) /* RA */
	l.ori   r1, r1, lo(0xfffffffc)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 3
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 4 */
        /**********/
	l.movhi r1,     hi(0xfffffff8) /* RA */
	l.ori   r1, r1, lo(0xfffffff8)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 4
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 5 */
        /**********/
	l.movhi r1,     hi(0xfffffff0) /* RA */
	l.ori   r1, r1, lo(0xfffffff0)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 5
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 6 */
        /**********/
	l.movhi r1,     hi(0xffffffe0) /* RA */
	l.ori   r1, r1, lo(0xffffffe0)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 6
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 7 */
        /**********/
	l.movhi r1,     hi(0xffffffc0) /* RA */
	l.ori   r1, r1, lo(0xffffffc0)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 7
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 8 */
        /**********/
	l.movhi r1,     hi(0xffffff80) /* RA */
	l.ori   r1, r1, lo(0xffffff80)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 8
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 9 */
        /**********/
	l.movhi r1,     hi(0xffffff00) /* RA */
	l.ori   r1, r1, lo(0xffffff00)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 9
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 10*/
        /**********/
	l.movhi r1,     hi(0xfffffe00) /* RA */
	l.ori   r1, r1, lo(0xfffffe00)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 10
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 11*/
        /**********/
	l.movhi r1,     hi(0xfffffc00) /* RA */
	l.ori   r1, r1, lo(0xfffffc00)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 11
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 12*/
        /**********/
	l.movhi r1,     hi(0xfffff800) /* RA */
	l.ori   r1, r1, lo(0xfffff800)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 12
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 13*/
        /**********/
	l.movhi r1,     hi(0xfffff000) /* RA */
	l.ori   r1, r1, lo(0xfffff000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 13
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 14*/
        /**********/
	l.movhi r1,     hi(0xffffe000) /* RA */
	l.ori   r1, r1, lo(0xffffe000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 14
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 15*/
        /**********/
	l.movhi r1,     hi(0xffffc000) /* RA */
	l.ori   r1, r1, lo(0xffffc000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 15
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 16*/
        /**********/
	l.movhi r1,     hi(0xffff8000) /* RA */
	l.ori   r1, r1, lo(0xffff8000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 16
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 17*/
        /**********/
	l.movhi r1,     hi(0xffff0000) /* RA */
	l.ori   r1, r1, lo(0xffff0000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 17
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 18*/
        /**********/
	l.movhi r1,     hi(0xfffe0000) /* RA */
	l.ori   r1, r1, lo(0xfffe0000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 18
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 19*/
        /**********/
	l.movhi r1,     hi(0xfffc0000) /* RA */
	l.ori   r1, r1, lo(0xfffc0000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 19
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 20*/
        /**********/
	l.movhi r1,     hi(0xfff80000) /* RA */
	l.ori   r1, r1, lo(0xfff80000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 20
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 21*/
        /**********/
	l.movhi r1,     hi(0xfff00000) /* RA */
	l.ori   r1, r1, lo(0xfff00000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 21
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 22*/
        /**********/
	l.movhi r1,     hi(0xffe00000) /* RA */
	l.ori   r1, r1, lo(0xffe00000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 22
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 23*/
        /**********/
	l.movhi r1,     hi(0xffc00000) /* RA */
	l.ori   r1, r1, lo(0xffc00000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 23
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 24*/
        /**********/
	l.movhi r1,     hi(0xff800000) /* RA */
	l.ori   r1, r1, lo(0xff800000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 24
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 25*/
        /**********/
	l.movhi r1,     hi(0xff000000) /* RA */
	l.ori   r1, r1, lo(0xff000000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 25
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 26*/
        /**********/
	l.movhi r1,     hi(0xfe000000) /* RA */
	l.ori   r1, r1, lo(0xfe000000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 26
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 27*/
        /**********/
	l.movhi r1,     hi(0xfc000000) /* RA */
	l.ori   r1, r1, lo(0xfc000000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 27
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 28*/
        /**********/
	l.movhi r1,     hi(0xf8000000) /* RA */
	l.ori   r1, r1, lo(0xf8000000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 28
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 29*/
        /**********/
	l.movhi r1,     hi(0xf0000000) /* RA */
	l.ori   r1, r1, lo(0xf0000000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 29
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 30*/
        /**********/
	l.movhi r1,     hi(0xe0000000) /* RA */
	l.ori   r1, r1, lo(0xe0000000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 30
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 31*/
        /**********/
	l.movhi r1,     hi(0xc0000000) /* RA */
	l.ori   r1, r1, lo(0xc0000000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 31
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 32*/
        /**********/
	l.movhi r1,     hi(0x80000000) /* RA */
	l.ori   r1, r1, lo(0x80000000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 32
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 33*/
        /**********/
	l.movhi r1,     hi(0x00000000) /* RA */
	l.ori   r1, r1, lo(0x00000000)
        
        l.ff1   r2, r1

        /* Test result */
        l.sfeqi r2, 0
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* End */
        /**********/

        l.j     _end_ok
        l.nop
