/*
 * $Id: test.cpp 101 2009-01-15 17:19:08Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::context_state::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Context_State * _Context_State = new Context_State 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_BRANCH_EVENT_VAL               ," in_BRANCH_EVENT_VAL               ",Tcontrol_t   ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_BRANCH_EVENT_ACK               ,"out_BRANCH_EVENT_ACK               ",Tcontrol_t   ,_param->_nb_context);
//ALLOC1_SC_SIGNAL( in_BRANCH_EVENT_CONTEXT_ID        ," in_BRANCH_EVENT_CONTEXT_ID        ",Tcontext_t   ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_BRANCH_EVENT_DEPTH             ," in_BRANCH_EVENT_DEPTH             ",Tdepth_t     ,_param->_nb_context);
//ALLOC1_SC_SIGNAL( in_BRANCH_EVENT_MISS_PREDICTION   ," in_BRANCH_EVENT_MISS_PREDICTION   ",Tcontrol_t   ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_BRANCH_EVENT_ADDRESS_SRC       ," in_BRANCH_EVENT_ADDRESS_SRC       ",Taddress_t   ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_BRANCH_EVENT_ADDRESS_DEST_VAL  ," in_BRANCH_EVENT_ADDRESS_DEST_VAL  ",Tcontrol_t   ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_BRANCH_EVENT_ADDRESS_DEST      ," in_BRANCH_EVENT_ADDRESS_DEST      ",Taddress_t   ,_param->_nb_context);

  ALLOC1_SC_SIGNAL( in_DECOD_EVENT_VAL                ," in_DECOD_EVENT_VAL                ",Tcontrol_t   ,_param->_nb_decod_unit);
  ALLOC1_SC_SIGNAL(out_DECOD_EVENT_ACK                ,"out_DECOD_EVENT_ACK                ",Tcontrol_t   ,_param->_nb_decod_unit);
  ALLOC1_SC_SIGNAL( in_DECOD_EVENT_CONTEXT_ID         ," in_DECOD_EVENT_CONTEXT_ID         ",Tcontext_t   ,_param->_nb_decod_unit);
  ALLOC1_SC_SIGNAL( in_DECOD_EVENT_DEPTH              ," in_DECOD_EVENT_DEPTH              ",Tdepth_t     ,_param->_nb_decod_unit);
  ALLOC1_SC_SIGNAL( in_DECOD_EVENT_TYPE               ," in_DECOD_EVENT_TYPE               ",Tevent_type_t,_param->_nb_decod_unit);
  ALLOC1_SC_SIGNAL( in_DECOD_EVENT_IS_DELAY_SLOT      ," in_DECOD_EVENT_IS_DELAY_SLOT      ",Tcontrol_t   ,_param->_nb_decod_unit);
  ALLOC1_SC_SIGNAL( in_DECOD_EVENT_ADDRESS            ," in_DECOD_EVENT_ADDRESS            ",Taddress_t   ,_param->_nb_decod_unit);
  ALLOC1_SC_SIGNAL( in_DECOD_EVENT_ADDRESS_EPCR       ," in_DECOD_EVENT_ADDRESS_EPCR       ",Taddress_t   ,_param->_nb_decod_unit);
						      				           
  ALLOC_SC_SIGNAL ( in_COMMIT_EVENT_VAL               ," in_COMMIT_EVENT_VAL               ",Tcontrol_t   );
  ALLOC_SC_SIGNAL (out_COMMIT_EVENT_ACK               ,"out_COMMIT_EVENT_ACK               ",Tcontrol_t   );
  ALLOC_SC_SIGNAL ( in_COMMIT_EVENT_CONTEXT_ID        ," in_COMMIT_EVENT_CONTEXT_ID        ",Tcontext_t   );
  ALLOC_SC_SIGNAL ( in_COMMIT_EVENT_DEPTH             ," in_COMMIT_EVENT_DEPTH             ",Tdepth_t     );
  ALLOC_SC_SIGNAL ( in_COMMIT_EVENT_TYPE              ," in_COMMIT_EVENT_TYPE              ",Tevent_type_t);
  ALLOC_SC_SIGNAL ( in_COMMIT_EVENT_IS_DELAY_SLOT     ," in_COMMIT_EVENT_IS_DELAY_SLOT     ",Tcontrol_t   );
  ALLOC_SC_SIGNAL ( in_COMMIT_EVENT_ADDRESS           ," in_COMMIT_EVENT_ADDRESS           ",Taddress_t   );
  ALLOC_SC_SIGNAL ( in_COMMIT_EVENT_ADDRESS_EPCR      ," in_COMMIT_EVENT_ADDRESS_EPCR      ",Taddress_t   );
  ALLOC_SC_SIGNAL ( in_COMMIT_EVENT_ADDRESS_EEAR_VAL  ," in_COMMIT_EVENT_ADDRESS_EEAR_VAL  ",Tcontrol_t   );
  ALLOC_SC_SIGNAL ( in_COMMIT_EVENT_ADDRESS_EEAR      ," in_COMMIT_EVENT_ADDRESS_EEAR      ",Tgeneral_data_t);

  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_VAL            ," in_BRANCH_COMPLETE_VAL            ",Tcontrol_t   ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ACK            ,"out_BRANCH_COMPLETE_ACK            ",Tcontrol_t   ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID     ," in_BRANCH_COMPLETE_CONTEXT_ID     ",Tcontext_t   ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_DEPTH          ," in_BRANCH_COMPLETE_DEPTH          ",Tdepth_t     ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_MISS_PREDICTION," in_BRANCH_COMPLETE_MISS_PREDICTION",Tcontrol_t   ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_TAKE           ," in_BRANCH_COMPLETE_TAKE           ",Tcontrol_t   ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_ADDRESS_SRC    ," in_BRANCH_COMPLETE_ADDRESS_SRC    ",Taddress_t   ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_ADDRESS_DEST   ," in_BRANCH_COMPLETE_ADDRESS_DEST   ",Taddress_t   ,_param->_nb_inst_branch_complete);

						      				           
  ALLOC1_SC_SIGNAL( in_NB_INST_DECOD_ALL              ," in_NB_INST_DECOD_ALL              ",Tcounter_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL( in_NB_INST_COMMIT_ALL             ," in_NB_INST_COMMIT_ALL             ",Tcounter_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL( in_NB_INST_COMMIT_MEM             ," in_NB_INST_COMMIT_MEM             ",Tcounter_t   ,_param->_nb_context   );
						      				           
  ALLOC1_SC_SIGNAL(out_EVENT_VAL                      ,"out_EVENT_VAL                      ",Tcontrol_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL( in_EVENT_ACK                      ," in_EVENT_ACK                      ",Tcontrol_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL(out_EVENT_ADDRESS                  ,"out_EVENT_ADDRESS                  ",Taddress_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT             ,"out_EVENT_ADDRESS_NEXT             ",Taddress_t   ,_param->_nb_context   ); 
  ALLOC1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT_VAL         ,"out_EVENT_ADDRESS_NEXT_VAL         ",Tcontrol_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL(out_EVENT_IS_DS_TAKE               ,"out_EVENT_IS_DS_TAKE               ",Tcontrol_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL(out_EVENT_TYPE                     ,"out_EVENT_TYPE                     ",Tevent_type_t,_param->_nb_context   );
  ALLOC1_SC_SIGNAL(out_EVENT_DEPTH                    ,"out_EVENT_DEPTH                    ",Tdepth_t     ,_param->_nb_context   );

  ALLOC1_SC_SIGNAL(out_SPR_EVENT_VAL                  ,"out_SPR_EVENT_VAL                  ",Tcontrol_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL( in_SPR_EVENT_ACK                  ," in_SPR_EVENT_ACK                  ",Tcontrol_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL(out_SPR_EVENT_EPCR                 ,"out_SPR_EVENT_EPCR                 ",Taddress_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL(out_SPR_EVENT_EEAR                 ,"out_SPR_EVENT_EEAR                 ",Taddress_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL(out_SPR_EVENT_EEAR_WEN             ,"out_SPR_EVENT_EEAR_WEN             ",Tcontrol_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL(out_SPR_EVENT_SR_DSX               ,"out_SPR_EVENT_SR_DSX               ",Tcontrol_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL(out_SPR_EVENT_SR_TO_ESR            ,"out_SPR_EVENT_SR_TO_ESR            ",Tcontrol_t   ,_param->_nb_context   );
						      				           
  ALLOC1_SC_SIGNAL(out_CONTEXT_DECOD_ENABLE           ,"out_CONTEXT_DECOD_ENABLE           ",Tcontrol_t   ,_param->_nb_context   );
						      				           
  ALLOC1_SC_SIGNAL( in_DEPTH_MIN                      ," in_DEPTH_MIN                      ",Tdepth_t     ,_param->_nb_context   );
  
  ALLOC1_SC_SIGNAL( in_SPR_SR_IEE                     ," in_SPR_SR_IEE                     ",Tcontrol_t   ,_param->_nb_context   );
  ALLOC1_SC_SIGNAL( in_SPR_SR_EPH                     ," in_SPR_SR_EPH                     ",Tcontrol_t   ,_param->_nb_context   );

  ALLOC1_SC_SIGNAL( in_INTERRUPT_ENABLE               ," in_INTERRUPT_ENABLE               ",Tcontrol_t   ,_param->_nb_context   );

  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Context_State.\n"),name.c_str());

  (*(_Context_State->in_CLOCK))        (*(in_CLOCK));
  (*(_Context_State->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_EVENT_VAL               ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Context_State,out_BRANCH_EVENT_ACK               ,_param->_nb_context);
//INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_EVENT_CONTEXT_ID        ,_param->_nb_context);
  if (_param->_have_port_depth)				        
  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_EVENT_DEPTH             ,_param->_nb_context);
//INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_EVENT_MISS_PREDICTION   ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_EVENT_ADDRESS_SRC       ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_EVENT_ADDRESS_DEST_VAL  ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_EVENT_ADDRESS_DEST      ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Context_State, in_DECOD_EVENT_VAL                ,_param->_nb_decod_unit);
  INSTANCE1_SC_SIGNAL(_Context_State,out_DECOD_EVENT_ACK                ,_param->_nb_decod_unit);
  if (_param->_have_port_context_id)				        
  INSTANCE1_SC_SIGNAL(_Context_State, in_DECOD_EVENT_CONTEXT_ID         ,_param->_nb_decod_unit);
  if (_param->_have_port_depth)				        
  INSTANCE1_SC_SIGNAL(_Context_State, in_DECOD_EVENT_DEPTH              ,_param->_nb_decod_unit);
  INSTANCE1_SC_SIGNAL(_Context_State, in_DECOD_EVENT_TYPE               ,_param->_nb_decod_unit);
  INSTANCE1_SC_SIGNAL(_Context_State, in_DECOD_EVENT_IS_DELAY_SLOT      ,_param->_nb_decod_unit);
  INSTANCE1_SC_SIGNAL(_Context_State, in_DECOD_EVENT_ADDRESS            ,_param->_nb_decod_unit);
  INSTANCE1_SC_SIGNAL(_Context_State, in_DECOD_EVENT_ADDRESS_EPCR       ,_param->_nb_decod_unit);
								        
  INSTANCE_SC_SIGNAL (_Context_State, in_COMMIT_EVENT_VAL               );
  INSTANCE_SC_SIGNAL (_Context_State,out_COMMIT_EVENT_ACK               );
  if (_param->_have_port_context_id)				        
  INSTANCE_SC_SIGNAL (_Context_State, in_COMMIT_EVENT_CONTEXT_ID        );
  if (_param->_have_port_depth)				        
  INSTANCE_SC_SIGNAL (_Context_State, in_COMMIT_EVENT_DEPTH             );
  INSTANCE_SC_SIGNAL (_Context_State, in_COMMIT_EVENT_TYPE              );
  INSTANCE_SC_SIGNAL (_Context_State, in_COMMIT_EVENT_IS_DELAY_SLOT     );
  INSTANCE_SC_SIGNAL (_Context_State, in_COMMIT_EVENT_ADDRESS           );
  INSTANCE_SC_SIGNAL (_Context_State, in_COMMIT_EVENT_ADDRESS_EPCR      );
  INSTANCE_SC_SIGNAL (_Context_State, in_COMMIT_EVENT_ADDRESS_EEAR_VAL  );
  INSTANCE_SC_SIGNAL (_Context_State, in_COMMIT_EVENT_ADDRESS_EEAR      );

  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Context_State,out_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_context_id)				        
  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_depth)				        
  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_COMPLETE_TAKE           ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_COMPLETE_ADDRESS_SRC    ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Context_State, in_BRANCH_COMPLETE_ADDRESS_DEST   ,_param->_nb_inst_branch_complete);

  INSTANCE1_SC_SIGNAL(_Context_State, in_NB_INST_DECOD_ALL              ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State, in_NB_INST_COMMIT_ALL             ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State, in_NB_INST_COMMIT_MEM             ,_param->_nb_context   );
								        
  INSTANCE1_SC_SIGNAL(_Context_State,out_EVENT_VAL                      ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State, in_EVENT_ACK                      ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State,out_EVENT_ADDRESS                  ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State,out_EVENT_ADDRESS_NEXT             ,_param->_nb_context   ); 
  INSTANCE1_SC_SIGNAL(_Context_State,out_EVENT_ADDRESS_NEXT_VAL         ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State,out_EVENT_IS_DS_TAKE               ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State,out_EVENT_TYPE                     ,_param->_nb_context   );
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Context_State,out_EVENT_DEPTH                    ,_param->_nb_context   );
								        
  INSTANCE1_SC_SIGNAL(_Context_State,out_SPR_EVENT_VAL                  ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State, in_SPR_EVENT_ACK                  ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State,out_SPR_EVENT_EPCR                 ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State,out_SPR_EVENT_EEAR                 ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State,out_SPR_EVENT_EEAR_WEN             ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State,out_SPR_EVENT_SR_DSX               ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State,out_SPR_EVENT_SR_TO_ESR            ,_param->_nb_context   );
								        
  INSTANCE1_SC_SIGNAL(_Context_State,out_CONTEXT_DECOD_ENABLE           ,_param->_nb_context   );

  for (uint32_t i=0; i<_param->_nb_context; i++)
    if (_param->_have_port_depth)
      INSTANCE_SC_SIGNAL(_Context_State, in_DEPTH_MIN [i]);

  INSTANCE1_SC_SIGNAL(_Context_State, in_SPR_SR_IEE                     ,_param->_nb_context   );
  INSTANCE1_SC_SIGNAL(_Context_State, in_SPR_SR_EPH                     ,_param->_nb_context   );

  INSTANCE1_SC_SIGNAL(_Context_State, in_INTERRUPT_ENABLE               ,_param->_nb_context   );

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const bool test1  = true;
  const bool test2  = true;
  const bool test3  = true;
  const bool test4  = true;
  const bool test5  = true;
  const bool test6  = true;
  const bool test7  = true;
  const bool test8  = true;
  const bool test9  = true;
  const bool test10 = true;
  const bool test11 = true;
  const bool test12 = true;

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_branch_event    = 75;
  const  int32_t percent_transaction_decod_event     = 75;
  const  int32_t percent_transaction_commit_event    = 75;
//const  int32_t percent_transaction_branch_complete = 75;
  const  int32_t percent_transaction_event           = 75;
  const  int32_t percent_transaction_spr             = 75;

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1); 

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);
      for (uint32_t i=0; i<_param->_nb_decod_unit; i++)
	in_DECOD_EVENT_VAL [i]->write(0);
      in_COMMIT_EVENT_VAL ->write(0);
//       for (uint32_t i=0; i<_param->_nb_inst_branch_complete; i++)
// 	in_BRANCH_COMPLETE_VAL [i]->write(0);
      for (uint32_t i=0; i<_param->_nb_context; i++)
	in_BRANCH_EVENT_VAL [i]->write(0);

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
          in_BRANCH_EVENT_VAL [i]->write(0);
	  in_EVENT_ACK        [i]->write(0);
	  in_SPR_EVENT_ACK    [i]->write(0);
          in_SPR_SR_IEE       [i]->write(0);
          in_SPR_SR_EPH       [i]->write(0);
          in_INTERRUPT_ENABLE [i]->write(0);

	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[i]->read(), 1);
	}

      for (uint32_t i=0; i<_param->_nb_context; i++)
	if (_param->_have_port_depth)
	  in_DEPTH_MIN  [i]->write((_param->_array_size_depth[i]==0)?0:(i%_param->_array_size_depth[i]));
      
      uint32_t context    = rand()%_param->_nb_context;

      if (test1)
	{
	  SC_START(3);
	  
	  LABEL("msync (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
	  uint32_t port = rand()%_param->_nb_decod_unit;
	  
	  in_DECOD_EVENT_CONTEXT_ID    [port]->write(context);
	  in_DECOD_EVENT_IS_DELAY_SLOT [port]->write(0);
	  in_DECOD_EVENT_ADDRESS       [port]->write(0x100);
	  in_DECOD_EVENT_ADDRESS_EPCR  [port]->write(0xdeadbeef);
	  if (_param->_have_port_depth)
	  in_DECOD_EVENT_DEPTH         [port]->write((_param->_array_size_depth[context]==0)?0:((context+1)%_param->_array_size_depth[context]));
	  in_DECOD_EVENT_TYPE          [port]->write(EVENT_TYPE_MSYNC);
	  
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
          in_DECOD_EVENT_VAL           [port]->write(1);

          SC_START(0);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  TEST(Tcontrol_t, out_DECOD_EVENT_ACK     [port]   ->read(), 0);

          SC_START(1);

	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
          
          LABEL("msync (send decod)");
          SC_START(0);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  TEST(Tcontrol_t, out_DECOD_EVENT_ACK     [port]   ->read(), 1);

	  SC_START(1);

          in_DECOD_EVENT_VAL     [port]->write(0);
	  in_NB_INST_COMMIT_ALL  [context]->write(1);
	  
	  LABEL("msync (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);

	  SC_START(1);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	}
      
      if (test2)
	{
	  SC_START(3);
	  
	  LABEL("psync (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
	  uint32_t port = rand()%_param->_nb_decod_unit;
	  
	  in_DECOD_EVENT_CONTEXT_ID    [port]->write(context);
	  in_DECOD_EVENT_IS_DELAY_SLOT [port]->write(0);
	  in_DECOD_EVENT_ADDRESS       [port]->write(0x200);
	  in_DECOD_EVENT_ADDRESS_EPCR  [port]->write(0xdeadbebe);
	  if (_param->_have_port_depth)
	  in_DECOD_EVENT_DEPTH         [port]->write((_param->_array_size_depth[context]==0)?0:((context+1)%_param->_array_size_depth[context]));
	  in_DECOD_EVENT_TYPE          [port]->write(EVENT_TYPE_PSYNC);
	  
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
          in_DECOD_EVENT_VAL           [port]->write(1);

          SC_START(0);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  TEST(Tcontrol_t, out_DECOD_EVENT_ACK     [port]   ->read(), 0);

          SC_START(1);

	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
          
          LABEL("psync (send decod)");
          SC_START(0);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  TEST(Tcontrol_t, out_DECOD_EVENT_ACK     [port]   ->read(), 1);

	  SC_START(1);

          in_DECOD_EVENT_VAL     [port]->write(0);
	  in_NB_INST_COMMIT_ALL  [context]->write(1);
	  
	  LABEL("psync (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);

	  SC_START(1);

	  bool find = false;
	  do
	    {
	      in_EVENT_ACK [context]->write(rand()%percent_transaction_event);
	  
	      SC_START(0);
	  
	      if (out_EVENT_VAL [context]->read() and in_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_EVENT_ADDRESS          [context]->read(),0x201);
		  TEST(Taddress_t,out_EVENT_ADDRESS_NEXT     [context]->read(),0xdeadbebe); 
		  TEST(Tcontrol_t,out_EVENT_ADDRESS_NEXT_VAL [context]->read(),0);
		  TEST(Tcontrol_t,out_EVENT_IS_DS_TAKE       [context]->read(),0);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_EVENT_ACK [context]->write(0);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	}

      if (test3)
	{
	  SC_START(3);
	  
	  LABEL("csync (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
	  uint32_t port = rand()%_param->_nb_decod_unit;
	  
	  in_DECOD_EVENT_CONTEXT_ID    [port]->write(context);
	  in_DECOD_EVENT_IS_DELAY_SLOT [port]->write(0);
	  in_DECOD_EVENT_ADDRESS       [port]->write(0x300);
	  in_DECOD_EVENT_ADDRESS_EPCR  [port]->write(0xdead0300);
	  if (_param->_have_port_depth)
	  in_DECOD_EVENT_DEPTH         [port]->write((_param->_array_size_depth[context]==0)?0:((context+1)%_param->_array_size_depth[context]));
	  in_DECOD_EVENT_TYPE          [port]->write(EVENT_TYPE_CSYNC);
	  
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
          in_DECOD_EVENT_VAL           [port]->write(1);

          SC_START(0);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  TEST(Tcontrol_t, out_DECOD_EVENT_ACK     [port]   ->read(), 0);

          SC_START(1);

	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
          
          LABEL("csync (send decod)");
          SC_START(0);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  TEST(Tcontrol_t, out_DECOD_EVENT_ACK     [port]   ->read(), 1);

	  SC_START(1);

          in_DECOD_EVENT_VAL     [port]->write(0);
	  in_NB_INST_COMMIT_ALL  [context]->write(1);
	  
	  LABEL("csync (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);

	  SC_START(1);

	  bool find = false;
	  do
	    {
	      in_EVENT_ACK [context]->write(rand()%percent_transaction_event);
	  
	      SC_START(0);
	  
	      if (out_EVENT_VAL [context]->read() and in_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_EVENT_ADDRESS          [context]->read(),0x301);
		  TEST(Taddress_t,out_EVENT_ADDRESS_NEXT     [context]->read(),0xdead0300); 
		  TEST(Tcontrol_t,out_EVENT_ADDRESS_NEXT_VAL [context]->read(),0);
		  TEST(Tcontrol_t,out_EVENT_IS_DS_TAKE       [context]->read(),0);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_EVENT_ACK [context]->write(0);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);

	}

      if (test4)
	{
	  SC_START(3);
	  
	  LABEL("spr_access (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
	  uint32_t port = rand()%_param->_nb_decod_unit;
	  
	  in_DECOD_EVENT_CONTEXT_ID    [port]->write(context);
	  in_DECOD_EVENT_IS_DELAY_SLOT [port]->write(0);
	  in_DECOD_EVENT_ADDRESS       [port]->write(0x400);
	  in_DECOD_EVENT_ADDRESS_EPCR  [port]->write(0xdead0400);
	  if (_param->_have_port_depth)
	  in_DECOD_EVENT_DEPTH         [port]->write((_param->_array_size_depth[context]==0)?0:((context+1)%_param->_array_size_depth[context]));
	  in_DECOD_EVENT_TYPE          [port]->write(EVENT_TYPE_SPR_ACCESS);
	  
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
          in_DECOD_EVENT_VAL           [port]->write(1);

          SC_START(0);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  TEST(Tcontrol_t, out_DECOD_EVENT_ACK     [port]   ->read(), 0);

          SC_START(1);

	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
          
          LABEL("spr_access (send decod)");
          SC_START(0);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  TEST(Tcontrol_t, out_DECOD_EVENT_ACK     [port]   ->read(), 1);

	  SC_START(1);

          in_DECOD_EVENT_VAL     [port]->write(0);
	  in_NB_INST_COMMIT_ALL  [context]->write(1);
	  
	  LABEL("spr_access (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);

	  SC_START(1);
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	}

      if (test5)
	{
	  SC_START(3);
	  
	  LABEL("miss (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
// 	  uint32_t port = rand()%_param->_nb_inst_branch_complete;
	  
// 	  in_BRANCH_COMPLETE_CONTEXT_ID       [port]->write(context);
// 	  if (_param->_have_port_depth)
// 	  in_BRANCH_COMPLETE_DEPTH            [port]->write((_param->_array_size_depth[context]==0)?0:((context+1)%_param->_array_size_depth[context]));
// 	  in_BRANCH_COMPLETE_ADDRESS_SRC      [port]->write(0x400);
// 	  in_BRANCH_COMPLETE_ADDRESS_DEST     [port]->write(0x500);
// 	  in_BRANCH_COMPLETE_MISS_PREDICTION  [port]->write(1);
// 	  in_BRANCH_COMPLETE_TAKE             [port]->write(0);

// 	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
// 	  do
// 	    {
// 	      in_BRANCH_COMPLETE_VAL [port]->write(rand()%percent_transaction_branch_complete);
	      
// 	      SC_START(1);
// 	    }
// 	  while (not ( in_BRANCH_COMPLETE_VAL [port]->read() and
// 		       out_BRANCH_COMPLETE_ACK [port]->read()));
// 	  in_BRANCH_COMPLETE_VAL [port]->write(0);

	  uint32_t port = context;
	  
	  if (_param->_have_port_depth)
	  in_BRANCH_EVENT_DEPTH            [port]->write((_param->_array_size_depth[context]==0)?0:((context+1)%_param->_array_size_depth[context]));
	  in_BRANCH_EVENT_ADDRESS_SRC      [port]->write(0x400);
	  in_BRANCH_EVENT_ADDRESS_DEST     [port]->write(0x500);
	  in_BRANCH_EVENT_ADDRESS_DEST_VAL [port]->write(0);

	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
	  do
	    {
	      in_BRANCH_EVENT_VAL [port]->write(rand()%percent_transaction_branch_event);
	      
	      SC_START(1);
	    }
	  while (not ( in_BRANCH_EVENT_VAL [port]->read() and
		       out_BRANCH_EVENT_ACK [port]->read()));
	  in_BRANCH_EVENT_VAL [port]->write(0);
	  
	  LABEL("miss (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
	  
	  SC_START(1);
	  
	  LABEL("miss (wait event)");


	  bool find = false;
	  do
	    {
	      in_EVENT_ACK [context]->write(rand()%percent_transaction_event);
	  
	      SC_START(0);
	  
	      if (out_EVENT_VAL [context]->read() and in_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_EVENT_ADDRESS          [context]->read(),0x401);
		  TEST(Taddress_t,out_EVENT_ADDRESS_NEXT     [context]->read(),0x500);
		  TEST(Tcontrol_t,out_EVENT_ADDRESS_NEXT_VAL [context]->read(),0);
		  TEST(Tcontrol_t,out_EVENT_IS_DS_TAKE       [context]->read(),0);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_EVENT_ACK [context]->write(0);

	}

      if (test6)
	{
	  SC_START(3);
	  
	  LABEL("miss (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
// 	  uint32_t port = rand()%_param->_nb_inst_branch_complete;
	  
// 	  in_BRANCH_COMPLETE_CONTEXT_ID       [port]->write(context);
// 	  if (_param->_have_port_depth)
// 	  in_BRANCH_COMPLETE_DEPTH            [port]->write((_param->_array_size_depth[context]==0)?0:((context+1)%_param->_array_size_depth[context]));
// 	  in_BRANCH_COMPLETE_ADDRESS_SRC      [port]->write(0x600);
// 	  in_BRANCH_COMPLETE_ADDRESS_DEST     [port]->write(0x700);
// 	  in_BRANCH_COMPLETE_MISS_PREDICTION  [port]->write(1);
// 	  in_BRANCH_COMPLETE_TAKE             [port]->write(1);

// 	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
// 	  do
// 	    {
// 	      in_BRANCH_COMPLETE_VAL [port]->write(rand()%percent_transaction_branch_complete);
	      
// 	      SC_START(1);
// 	    }
// 	  while (not ( in_BRANCH_COMPLETE_VAL [port]->read() and
// 		       out_BRANCH_COMPLETE_ACK [port]->read()));
// 	  in_BRANCH_COMPLETE_VAL [port]->write(0);

	  uint32_t port = context;
	  
	  in_BRANCH_EVENT_DEPTH            [port]->write((_param->_array_size_depth[context]==0)?0:((context+1)%_param->_array_size_depth[context]));
	  in_BRANCH_EVENT_ADDRESS_SRC      [port]->write(0x600);
	  in_BRANCH_EVENT_ADDRESS_DEST     [port]->write(0x700);
	  in_BRANCH_EVENT_ADDRESS_DEST_VAL [port]->write(1);

	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
	  do
	    {
	      in_BRANCH_EVENT_VAL [port]->write(rand()%percent_transaction_branch_event);
	      
	      SC_START(1);
	    }
	  while (not ( in_BRANCH_EVENT_VAL [port]->read() and
		       out_BRANCH_EVENT_ACK [port]->read()));
	  in_BRANCH_EVENT_VAL [port]->write(0);
	  
	  LABEL("miss (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
	  
	  SC_START(1);
	  
	  LABEL("miss (wait event)");

	  bool find = false;
	  do
	    {
	      in_EVENT_ACK [context]->write(rand()%percent_transaction_event);
	  
	      SC_START(0);
	  
	      if (out_EVENT_VAL [context]->read() and in_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_EVENT_ADDRESS          [context]->read(),0x601);
		  TEST(Taddress_t,out_EVENT_ADDRESS_NEXT     [context]->read(),0x700);
		  TEST(Tcontrol_t,out_EVENT_ADDRESS_NEXT_VAL [context]->read(),1);
		  TEST(Tcontrol_t,out_EVENT_IS_DS_TAKE       [context]->read(),1);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_EVENT_ACK [context]->write(0);
	}

      if (test7)
	{
	  SC_START(3);
	  
	  LABEL("exception (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
	  uint32_t port = rand()%_param->_nb_decod_unit;
	  
	  in_DECOD_EVENT_CONTEXT_ID       [port]->write(context);
	  if (_param->_have_port_depth)
	  in_DECOD_EVENT_DEPTH            [port]->write((_param->_array_size_depth[context]==0)?0:((context)%_param->_array_size_depth[context]));
	  in_DECOD_EVENT_TYPE             [port]->write(EVENT_TYPE_EXCEPTION);
	  in_DECOD_EVENT_IS_DELAY_SLOT    [port]->write(0);
	  in_DECOD_EVENT_ADDRESS          [port]->write(0x800);
	  in_DECOD_EVENT_ADDRESS_EPCR     [port]->write(0x900);

	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
	  do
	    {
	      in_DECOD_EVENT_VAL [port]->write(rand()%percent_transaction_decod_event);
	      
	      SC_START(1);
	    }
	  while (not ( in_DECOD_EVENT_VAL [port]->read() and
		       out_DECOD_EVENT_ACK [port]->read()));
	  in_DECOD_EVENT_VAL [port]->write(0);
	  
	  LABEL("exception (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
	  
	  SC_START(1);
	  
	  LABEL("exception (wait event)");

	  bool find = false;
	  do
	    {
	      in_EVENT_ACK [context]->write(rand()%percent_transaction_event);
	  
	      SC_START(0);
	  
	      if (out_EVENT_VAL [context]->read() and in_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_EVENT_ADDRESS          [context]->read(),0x800);
		  TEST(Taddress_t,out_EVENT_ADDRESS_NEXT     [context]->read(),0x900);
		  TEST(Tcontrol_t,out_EVENT_ADDRESS_NEXT_VAL [context]->read(),0);
		  TEST(Tcontrol_t,out_EVENT_IS_DS_TAKE       [context]->read(),0);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_EVENT_ACK [context]->write(0);

	  LABEL("exception (wait spr)");

	  find = false;
	  do
	    {
	      in_SPR_EVENT_ACK [context]->write(rand()%percent_transaction_spr);
	  
	      SC_START(0);
	  
	      if (out_SPR_EVENT_VAL [context]->read() and in_SPR_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_SPR_EVENT_EPCR      [context]->read(),0x900);
		//TEST(Taddress_t,out_SPR_EVENT_EEAR      [context]->read(),);
		  TEST(Tcontrol_t,out_SPR_EVENT_EEAR_WEN  [context]->read(),0);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_DSX    [context]->read(),0);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_TO_ESR [context]->read(),1);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_SPR_EVENT_ACK [context]->write(0);
	}

      if (test8)
	{
	  SC_START(3);
	  
	  LABEL("exception (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
	  uint32_t port = rand()%_param->_nb_decod_unit;
	  
	  in_DECOD_EVENT_CONTEXT_ID       [port]->write(context);
	  if (_param->_have_port_depth)
	  in_DECOD_EVENT_DEPTH            [port]->write((_param->_array_size_depth[context]==0)?0:((context)%_param->_array_size_depth[context]));
	  in_DECOD_EVENT_TYPE             [port]->write(EVENT_TYPE_EXCEPTION);
	  in_DECOD_EVENT_IS_DELAY_SLOT    [port]->write(1);
	  in_DECOD_EVENT_ADDRESS          [port]->write(0x800);
	  in_DECOD_EVENT_ADDRESS_EPCR     [port]->write(0x900);

	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
	  do
	    {
	      in_DECOD_EVENT_VAL [port]->write(rand()%percent_transaction_decod_event);
	      
	      SC_START(1);
	    }
	  while (not ( in_DECOD_EVENT_VAL [port]->read() and
		       out_DECOD_EVENT_ACK [port]->read()));
	  in_DECOD_EVENT_VAL [port]->write(0);
	  
	  LABEL("exception (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
	  
	  SC_START(1);
	  
	  LABEL("exception (wait event)");

	  bool find = false;
	  do
	    {
	      in_EVENT_ACK [context]->write(rand()%percent_transaction_event);
	  
	      SC_START(0);
	  
	      if (out_EVENT_VAL [context]->read() and in_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_EVENT_ADDRESS          [context]->read(),0x800);
		  TEST(Taddress_t,out_EVENT_ADDRESS_NEXT     [context]->read(),0x900);
		  TEST(Tcontrol_t,out_EVENT_ADDRESS_NEXT_VAL [context]->read(),0);
		  TEST(Tcontrol_t,out_EVENT_IS_DS_TAKE       [context]->read(),0);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_EVENT_ACK [context]->write(0);

	  LABEL("exception (wait spr)");

	  find = false;
	  do
	    {
	      in_SPR_EVENT_ACK [context]->write(rand()%percent_transaction_spr);
	  
	      SC_START(0);
	  
	      if (out_SPR_EVENT_VAL [context]->read() and in_SPR_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_SPR_EVENT_EPCR      [context]->read(),0x900);
		//TEST(Taddress_t,out_SPR_EVENT_EEAR      [context]->read(),);
		  TEST(Tcontrol_t,out_SPR_EVENT_EEAR_WEN  [context]->read(),0);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_DSX    [context]->read(),1);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_TO_ESR [context]->read(),1);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_SPR_EVENT_ACK [context]->write(0);
	}

      if (test9)
	{
	  SC_START(3);
	  
	  LABEL("exception (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
	  in_COMMIT_EVENT_CONTEXT_ID       ->write(context);
	  if (_param->_have_port_depth)
	  in_COMMIT_EVENT_DEPTH            ->write((_param->_array_size_depth[context]==0)?0:((context)%_param->_array_size_depth[context]));
	  in_COMMIT_EVENT_TYPE             ->write(EVENT_TYPE_EXCEPTION);
	  in_COMMIT_EVENT_IS_DELAY_SLOT    ->write(0);
	  in_COMMIT_EVENT_ADDRESS          ->write(0xa00);
	  in_COMMIT_EVENT_ADDRESS_EPCR     ->write(0xb00);
	  in_COMMIT_EVENT_ADDRESS_EEAR     ->write(0xc00);
	  in_COMMIT_EVENT_ADDRESS_EEAR_VAL ->write(0);

	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
	  do
	    {
	      in_COMMIT_EVENT_VAL ->write(rand()%percent_transaction_commit_event);
	      
	      SC_START(1);
	    }
	  while (not ( in_COMMIT_EVENT_VAL ->read() and
		       out_COMMIT_EVENT_ACK ->read()));
	  in_COMMIT_EVENT_VAL ->write(0);
	  
	  LABEL("exception (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
	  
	  SC_START(1);
	  
	  LABEL("exception (wait event)");

	  bool find = false;
	  do
	    {
	      in_EVENT_ACK [context]->write(rand()%percent_transaction_event);
	  
	      SC_START(0);
	  
	      if (out_EVENT_VAL [context]->read() and in_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_EVENT_ADDRESS          [context]->read(),0xa00);
		  TEST(Taddress_t,out_EVENT_ADDRESS_NEXT     [context]->read(),0xb00);
		  TEST(Tcontrol_t,out_EVENT_ADDRESS_NEXT_VAL [context]->read(),0);
		  TEST(Tcontrol_t,out_EVENT_IS_DS_TAKE       [context]->read(),0);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_EVENT_ACK [context]->write(0);

	  LABEL("exception (wait spr)");

	  find = false;
	  do
	    {
	      in_SPR_EVENT_ACK [context]->write(rand()%percent_transaction_spr);
	  
	      SC_START(0);
	  
	      if (out_SPR_EVENT_VAL [context]->read() and in_SPR_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_SPR_EVENT_EPCR      [context]->read(),0xb00);
		  TEST(Taddress_t,out_SPR_EVENT_EEAR      [context]->read(),0xc00);
		  TEST(Tcontrol_t,out_SPR_EVENT_EEAR_WEN  [context]->read(),0);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_DSX    [context]->read(),0);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_TO_ESR [context]->read(),1);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_SPR_EVENT_ACK [context]->write(0);
	}
      
      if (test10)
	{
	  SC_START(3);
	  
	  LABEL("exception (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
	  in_COMMIT_EVENT_CONTEXT_ID       ->write(context);
	  if (_param->_have_port_depth)
	  in_COMMIT_EVENT_DEPTH            ->write((_param->_array_size_depth[context]==0)?0:((context)%_param->_array_size_depth[context]));
	  in_COMMIT_EVENT_TYPE             ->write(EVENT_TYPE_EXCEPTION);
	  in_COMMIT_EVENT_IS_DELAY_SLOT    ->write(1);
	  in_COMMIT_EVENT_ADDRESS          ->write(0xd00);
	  in_COMMIT_EVENT_ADDRESS_EPCR     ->write(0xe00);
	  in_COMMIT_EVENT_ADDRESS_EEAR     ->write(0xf00);
	  in_COMMIT_EVENT_ADDRESS_EEAR_VAL ->write(0);

	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
	  do
	    {
	      in_COMMIT_EVENT_VAL ->write(rand()%percent_transaction_commit_event);
	      
	      SC_START(1);
	    }
	  while (not ( in_COMMIT_EVENT_VAL ->read() and
		       out_COMMIT_EVENT_ACK ->read()));
	  in_COMMIT_EVENT_VAL ->write(0);
	  
	  LABEL("exception (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
	  
	  SC_START(1);
	  
	  LABEL("exception (wait event)");

	  bool find = false;
	  do
	    {
	      in_EVENT_ACK [context]->write(rand()%percent_transaction_event);
	  
	      SC_START(0);
	  
	      if (out_EVENT_VAL [context]->read() and in_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_EVENT_ADDRESS          [context]->read(),0xd00);
		  TEST(Taddress_t,out_EVENT_ADDRESS_NEXT     [context]->read(),0xe00);
		  TEST(Tcontrol_t,out_EVENT_ADDRESS_NEXT_VAL [context]->read(),0);
		  TEST(Tcontrol_t,out_EVENT_IS_DS_TAKE       [context]->read(),0);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_EVENT_ACK [context]->write(0);

	  LABEL("exception (wait spr)");

	  find = false;
	  do
	    {
	      in_SPR_EVENT_ACK [context]->write(rand()%percent_transaction_spr);
	  
	      SC_START(0);
	  
	      if (out_SPR_EVENT_VAL [context]->read() and in_SPR_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_SPR_EVENT_EPCR      [context]->read(),0xe00);
		  TEST(Taddress_t,out_SPR_EVENT_EEAR      [context]->read(),0xf00);
		  TEST(Tcontrol_t,out_SPR_EVENT_EEAR_WEN  [context]->read(),0);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_DSX    [context]->read(),1);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_TO_ESR [context]->read(),1);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_SPR_EVENT_ACK [context]->write(0);
	}

      if (test11)
	{
	  SC_START(3);
	  
	  LABEL("exception (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
	  in_COMMIT_EVENT_CONTEXT_ID       ->write(context);
	  if (_param->_have_port_depth)
	  in_COMMIT_EVENT_DEPTH            ->write((_param->_array_size_depth[context]==0)?0:((context)%_param->_array_size_depth[context]));
	  in_COMMIT_EVENT_TYPE             ->write(EVENT_TYPE_EXCEPTION);
	  in_COMMIT_EVENT_IS_DELAY_SLOT    ->write(0);
	  in_COMMIT_EVENT_ADDRESS          ->write(0xa00);
	  in_COMMIT_EVENT_ADDRESS_EPCR     ->write(0xb00);
	  in_COMMIT_EVENT_ADDRESS_EEAR     ->write(0xc00);
	  in_COMMIT_EVENT_ADDRESS_EEAR_VAL ->write(1);

	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
	  do
	    {
	      in_COMMIT_EVENT_VAL ->write(rand()%percent_transaction_commit_event);
	      
	      SC_START(1);
	    }
	  while (not ( in_COMMIT_EVENT_VAL ->read() and
		       out_COMMIT_EVENT_ACK ->read()));
	  in_COMMIT_EVENT_VAL ->write(0);
	  
	  LABEL("exception (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
	  
	  SC_START(1);
	  
	  LABEL("exception (wait event)");

	  bool find = false;
	  do
	    {
	      in_EVENT_ACK [context]->write(rand()%percent_transaction_event);
	  
	      SC_START(0);
	  
	      if (out_EVENT_VAL [context]->read() and in_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_EVENT_ADDRESS          [context]->read(),0xa00);
		  TEST(Taddress_t,out_EVENT_ADDRESS_NEXT     [context]->read(),0xb00);
		  TEST(Tcontrol_t,out_EVENT_ADDRESS_NEXT_VAL [context]->read(),0);
		  TEST(Tcontrol_t,out_EVENT_IS_DS_TAKE       [context]->read(),0);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_EVENT_ACK [context]->write(0);

	  LABEL("exception (wait spr)");

	  find = false;
	  do
	    {
	      in_SPR_EVENT_ACK [context]->write(rand()%percent_transaction_spr);
	  
	      SC_START(0);
	  
	      if (out_SPR_EVENT_VAL [context]->read() and in_SPR_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_SPR_EVENT_EPCR      [context]->read(),0xb00);
		  TEST(Taddress_t,out_SPR_EVENT_EEAR      [context]->read(),0xc00);
		  TEST(Tcontrol_t,out_SPR_EVENT_EEAR_WEN  [context]->read(),1);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_DSX    [context]->read(),0);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_TO_ESR [context]->read(),1);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_SPR_EVENT_ACK [context]->write(0);
	}
      
      if (test12)
	{
	  SC_START(3);
	  
	  LABEL("exception (begin)");
	  in_NB_INST_DECOD_ALL  [context]->write(1);
	  in_NB_INST_COMMIT_ALL [context]->write(1);
	  in_NB_INST_COMMIT_MEM [context]->write(1);
	  
	  in_COMMIT_EVENT_CONTEXT_ID       ->write(context);
	  if (_param->_have_port_depth)
	  in_COMMIT_EVENT_DEPTH            ->write((_param->_array_size_depth[context]==0)?0:((context)%_param->_array_size_depth[context]));
	  in_COMMIT_EVENT_TYPE             ->write(EVENT_TYPE_EXCEPTION);
	  in_COMMIT_EVENT_IS_DELAY_SLOT    ->write(1);
	  in_COMMIT_EVENT_ADDRESS          ->write(0xd00);
	  in_COMMIT_EVENT_ADDRESS_EPCR     ->write(0xe00);
	  in_COMMIT_EVENT_ADDRESS_EEAR     ->write(0xf00);
	  in_COMMIT_EVENT_ADDRESS_EEAR_VAL ->write(1);

	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 1);
	  
	  do
	    {
	      in_COMMIT_EVENT_VAL ->write(rand()%percent_transaction_commit_event);
	      
	      SC_START(1);
	    }
	  while (not ( in_COMMIT_EVENT_VAL ->read() and
		       out_COMMIT_EVENT_ACK ->read()));
	  in_COMMIT_EVENT_VAL ->write(0);
	  
	  LABEL("exception (wait end)");
	  TEST(Tcontrol_t, out_CONTEXT_DECOD_ENABLE[context]->read(), 0);
	  
	  SC_START(3);
	  
	  in_NB_INST_DECOD_ALL  [context]->write(0);
	  in_NB_INST_COMMIT_ALL [context]->write(0);
	  in_NB_INST_COMMIT_MEM [context]->write(0);
	  
	  SC_START(1);
	  
	  LABEL("exception (wait event)");

	  bool find = false;
	  do
	    {
	      in_EVENT_ACK [context]->write(rand()%percent_transaction_event);
	  
	      SC_START(0);
	  
	      if (out_EVENT_VAL [context]->read() and in_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_EVENT_ADDRESS          [context]->read(),0xd00);
		  TEST(Taddress_t,out_EVENT_ADDRESS_NEXT     [context]->read(),0xe00);
		  TEST(Tcontrol_t,out_EVENT_ADDRESS_NEXT_VAL [context]->read(),0);
		  TEST(Tcontrol_t,out_EVENT_IS_DS_TAKE       [context]->read(),0);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_EVENT_ACK [context]->write(0);

	  LABEL("exception (wait spr)");

	  find = false;
	  do
	    {
	      in_SPR_EVENT_ACK [context]->write(rand()%percent_transaction_spr);
	  
	      SC_START(0);
	  
	      if (out_SPR_EVENT_VAL [context]->read() and in_SPR_EVENT_ACK [context]->read())
	        {
		  TEST(Taddress_t,out_SPR_EVENT_EPCR      [context]->read(),0xe00);
		  TEST(Taddress_t,out_SPR_EVENT_EEAR      [context]->read(),0xf00);
		  TEST(Tcontrol_t,out_SPR_EVENT_EEAR_WEN  [context]->read(),1);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_DSX    [context]->read(),1);
		  TEST(Tcontrol_t,out_SPR_EVENT_SR_TO_ESR [context]->read(),1);
		  
		  find = true;
	        }
	      
	      SC_START(1);
	    }
	  while (not find);

	  in_SPR_EVENT_ACK [context]->write(0);
	}


      SC_START(1);
    }


  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL( in_BRANCH_EVENT_VAL               ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_BRANCH_EVENT_ACK               ,_param->_nb_context);
//DELETE1_SC_SIGNAL( in_BRANCH_EVENT_CONTEXT_ID        ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_BRANCH_EVENT_DEPTH             ,_param->_nb_context);
//DELETE1_SC_SIGNAL( in_BRANCH_EVENT_MISS_PREDICTION   ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_BRANCH_EVENT_ADDRESS_SRC       ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_BRANCH_EVENT_ADDRESS_DEST_VAL  ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_BRANCH_EVENT_ADDRESS_DEST      ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_DECOD_EVENT_VAL                ,_param->_nb_decod_unit);
  DELETE1_SC_SIGNAL(out_DECOD_EVENT_ACK                ,_param->_nb_decod_unit);
  DELETE1_SC_SIGNAL( in_DECOD_EVENT_CONTEXT_ID         ,_param->_nb_decod_unit);
  DELETE1_SC_SIGNAL( in_DECOD_EVENT_DEPTH              ,_param->_nb_decod_unit);
  DELETE1_SC_SIGNAL( in_DECOD_EVENT_TYPE               ,_param->_nb_decod_unit);
  DELETE1_SC_SIGNAL( in_DECOD_EVENT_IS_DELAY_SLOT      ,_param->_nb_decod_unit);
  DELETE1_SC_SIGNAL( in_DECOD_EVENT_ADDRESS            ,_param->_nb_decod_unit);
  DELETE1_SC_SIGNAL( in_DECOD_EVENT_ADDRESS_EPCR       ,_param->_nb_decod_unit);
  DELETE_SC_SIGNAL ( in_COMMIT_EVENT_VAL               );
  DELETE_SC_SIGNAL (out_COMMIT_EVENT_ACK               );
  DELETE_SC_SIGNAL ( in_COMMIT_EVENT_CONTEXT_ID        );
  DELETE_SC_SIGNAL ( in_COMMIT_EVENT_DEPTH             );
  DELETE_SC_SIGNAL ( in_COMMIT_EVENT_TYPE              );
  DELETE_SC_SIGNAL ( in_COMMIT_EVENT_IS_DELAY_SLOT     );
  DELETE_SC_SIGNAL ( in_COMMIT_EVENT_ADDRESS           );
  DELETE_SC_SIGNAL ( in_COMMIT_EVENT_ADDRESS_EPCR      );
  DELETE_SC_SIGNAL ( in_COMMIT_EVENT_ADDRESS_EEAR_VAL  );
  DELETE_SC_SIGNAL ( in_COMMIT_EVENT_ADDRESS_EEAR      );
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_TAKE           ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_ADDRESS_SRC    ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_ADDRESS_DEST   ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_NB_INST_DECOD_ALL              ,_param->_nb_context   );
  DELETE1_SC_SIGNAL( in_NB_INST_COMMIT_ALL             ,_param->_nb_context   );
  DELETE1_SC_SIGNAL( in_NB_INST_COMMIT_MEM             ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_EVENT_VAL                      ,_param->_nb_context   );
  DELETE1_SC_SIGNAL( in_EVENT_ACK                      ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_EVENT_ADDRESS                  ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT             ,_param->_nb_context   ); 
  DELETE1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT_VAL         ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_EVENT_IS_DS_TAKE               ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_EVENT_TYPE                     ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_EVENT_DEPTH                    ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_SPR_EVENT_VAL                  ,_param->_nb_context   );
  DELETE1_SC_SIGNAL( in_SPR_EVENT_ACK                  ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_SPR_EVENT_EPCR                 ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_SPR_EVENT_EEAR                 ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_SPR_EVENT_EEAR_WEN             ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_SPR_EVENT_SR_DSX               ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_SPR_EVENT_SR_TO_ESR            ,_param->_nb_context   );
  DELETE1_SC_SIGNAL(out_CONTEXT_DECOD_ENABLE           ,_param->_nb_context   );
  DELETE1_SC_SIGNAL( in_DEPTH_MIN                      ,_param->_nb_context   );
  DELETE1_SC_SIGNAL( in_SPR_SR_IEE                     ,_param->_nb_context   );
  DELETE1_SC_SIGNAL( in_SPR_SR_EPH                     ,_param->_nb_context   );

  DELETE1_SC_SIGNAL( in_INTERRUPT_ENABLE               ,_param->_nb_context   );
    }
#endif

  delete _Context_State;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
