/*
 * $Id: main.cpp 101 2009-01-15 17:19:08Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Queue/SelfTest/include/test.h"

#define NB_PARAMS 5

void usage (int argc, char * argv[])
{
  cerr << "<Usage> " << argv[0] << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - size_queue      (uint32_t)" << endl
       << " - size_data       (uint32_t)" << endl
       << " - nb_port_slot    (uint32_t)" << endl
       << " - have_port_write (bool    )" << endl
       << " - have_port_read  (bool    )" << endl
       << "" << endl;

  for (int i=0; i<argc; i++)
    cerr << argv[i] << " ";
  cerr << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t       x = 1;
  
  const string   name            =      argv[x++];
  const uint32_t size_queue      = fromString<uint32_t>(argv[x++]);
  const uint32_t size_data       = fromString<uint32_t>(argv[x++]);
  const uint32_t nb_port_slot    = fromString<uint32_t>(argv[x++]);
  const bool     have_port_write = fromString<bool>(argv[x++]);
  const bool     have_port_read  = fromString<bool>(argv[x++]);
  try 
    {
      morpheo::behavioural::generic::queue::Parameters * param = new morpheo::behavioural::generic::queue::Parameters
	(size_queue,
	 size_data ,
         nb_port_slot,
         have_port_write,
         have_port_read 
        );
      
      cout << param->print(1);
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

