/*
 * $Id: test.cpp 101 2009-01-15 17:19:08Z rosiere $
 *
 * [Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (2048*NB_ITERATION)

#include "Behavioural/Generic/Queue/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Test.h"

void test (string name,
	   morpheo::behavioural::generic::queue::Parameters * _param)
{
  cout << "<" << name << "> : Simulation SystemC" << endl;

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Queue * _Queue = new Queue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC0_SC_SIGNAL( in_INSERT_VAL , "in_INSERT_VAL" ,Tcontrol_t);
  ALLOC0_SC_SIGNAL(out_INSERT_ACK ,"out_INSERT_ACK" ,Tcontrol_t);
  ALLOC0_SC_SIGNAL( in_INSERT_DATA, "in_INSERT_DATA",Tdata_t   );
  ALLOC0_SC_SIGNAL(out_RETIRE_VAL ,"out_RETIRE_VAL" ,Tcontrol_t);
  ALLOC0_SC_SIGNAL( in_RETIRE_ACK , "in_RETIRE_ACK" ,Tcontrol_t);
  ALLOC0_SC_SIGNAL(out_RETIRE_DATA,"out_RETIRE_DATA",Tdata_t   );
  ALLOC1_SC_SIGNAL(out_SLOT_VAL   ,"out_SLOT_VAL"   ,Tcontrol_t,_param->_nb_port_slot);
  ALLOC1_SC_SIGNAL(out_SLOT_DATA  ,"out_SLOT_DATA"  ,Tdata_t   ,_param->_nb_port_slot);
  ALLOC0_SC_SIGNAL(out_PTR_WRITE  ,"out_PTR_WRITE"  ,Tptr_t    );
  ALLOC0_SC_SIGNAL(out_PTR_READ   ,"out_PTR_READ"   ,Tptr_t    );
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of _Queue" << endl;
  
  (*(_Queue->in_CLOCK))        (*(in_CLOCK));
  (*(_Queue->in_NRESET))       (*(in_NRESET));

  INSTANCE0_SC_SIGNAL(_Queue, in_INSERT_VAL );
  INSTANCE0_SC_SIGNAL(_Queue,out_INSERT_ACK );
  INSTANCE0_SC_SIGNAL(_Queue, in_INSERT_DATA);
  INSTANCE0_SC_SIGNAL(_Queue,out_RETIRE_VAL );
  INSTANCE0_SC_SIGNAL(_Queue, in_RETIRE_ACK );
  INSTANCE0_SC_SIGNAL(_Queue,out_RETIRE_DATA);
  INSTANCE1_SC_SIGNAL(_Queue,out_SLOT_VAL   ,_param->_nb_port_slot);
  INSTANCE1_SC_SIGNAL(_Queue,out_SLOT_DATA  ,_param->_nb_port_slot);
  if (_param->_have_port_ptr_write)
  INSTANCE0_SC_SIGNAL(_Queue,out_PTR_WRITE  );
  if (_param->_have_port_ptr_read )
  INSTANCE0_SC_SIGNAL(_Queue,out_PTR_READ   );

  cout << "<" << name << "> Start Simulation ............" << endl;
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation
  const  int32_t percent_insert_transaction = 75;
  const  int32_t percent_retire_transaction = 75;
  const uint32_t nb_request = 3*_param->_size_queue;

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  in_INSERT_VAL -> write(0);
  in_RETIRE_ACK -> write(0);

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  uint32_t data_in  = 0;
  uint32_t data_out = 0;
  uint32_t nb_elt   = 0;

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      while (data_out <= nb_request)
	{
	  in_INSERT_VAL  -> write((rand()%100)<percent_insert_transaction);
	  in_INSERT_DATA -> write(data_in);
	  in_RETIRE_ACK  -> write((rand()%100)<percent_retire_transaction);

	  SC_START(0); // genMoore

          for (uint32_t i=0; i<_param->_nb_port_slot; ++i)
            {
              TEST(Tcontrol_t, out_SLOT_VAL [i]->read(), (i<nb_elt));
              if (i<nb_elt)
              TEST(Tdata_t   , out_SLOT_DATA[i]->read(), data_out+i);
                
            }

	  if ( in_INSERT_VAL->read() and out_INSERT_ACK->read())
	    {
	      LABEL ("Transaction with interface : INSERT");
	      data_in ++;
              nb_elt ++;
	    }
	  if (out_RETIRE_VAL->read() and  in_RETIRE_ACK->read())
	    {
	      LABEL ("Transaction with interface : RETIRE");
	      TEST(Tdata_t, out_RETIRE_DATA->read(), data_out);
	      data_out++;
              nb_elt --;
	    }

	  SC_START(1);
	}
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;
  cout << "<" << name << "> ............ Stop Simulation" << endl;

  delete in_CLOCK;
  delete in_NRESET;

  DELETE0_SC_SIGNAL( in_INSERT_VAL );
  DELETE0_SC_SIGNAL(out_INSERT_ACK );
  DELETE0_SC_SIGNAL( in_INSERT_DATA);
  DELETE0_SC_SIGNAL(out_RETIRE_VAL );
  DELETE0_SC_SIGNAL( in_RETIRE_ACK );
  DELETE0_SC_SIGNAL(out_RETIRE_DATA);
  DELETE1_SC_SIGNAL(out_SLOT_VAL   ,_param->_nb_port_slot);
  DELETE1_SC_SIGNAL(out_SLOT_DATA  ,_param->_nb_port_slot);
  DELETE0_SC_SIGNAL(out_PTR_WRITE  );
  DELETE0_SC_SIGNAL(out_PTR_READ   );
#endif

  delete _Queue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
