#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_special_register_unit_SPR_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_special_register_unit_SPR_h

/*
 * $Id: SPR.h 101 2009-01-15 17:19:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Special_Register_unit/include/Parameters.h"
#include "Behavioural/include/SPR.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace special_register_unit {

  //----------------------------------------------------------
  // [x][x] GENERIC
  //----------------------------------------------------------
  class GENERIC : public morpheo::behavioural::SPR
  {
  public : Tspr_t x : 32;
    
  public :        GENERIC(uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) {};

  public : void   reset (void  ) 
    {
      x = 0;
    };
  public : Tspr_t read  (void  )
    {
      return x;
    };
  public : void   write (Tspr_t x) 
    {
      this->x = x;
    };
  };

  //----------------------------------------------------------
  // [0][0] VR
  //----------------------------------------------------------
  class VR : public morpheo::behavioural::SPR
  {
  public : const Tspr_t   ver : 8;
  public : const Tspr_t  _res :10;
  public : const Tspr_t   cfg : 8;
  public : const Tspr_t   rev : 8;

  public :        VR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL):
    // SPR (),
    ver (0),
   _res (0),
    cfg (0),
    rev (0){};

  public : void   reset (void  ) {};
  public : Tspr_t read  (void  )
    {
      return ((ver << 24) |
	      (cfg << 16) |
	      (rev <<  0));
    }
  public : void   write (Tspr_t x) {}; // All bit field is Read Only
  };

  //----------------------------------------------------------
  // [0][1] UPR
  //----------------------------------------------------------
  class UPR : public morpheo::behavioural::SPR
  {
  public : const Tspr_t   cup  : 8;
  public : const Tspr_t  _res  : 8;
  public : const Tspr_t   ttp  : 1;
  public : const Tspr_t   pmp  : 1;
  public : const Tspr_t   picp : 1;
  public : const Tspr_t   pcup : 1;
  public : const Tspr_t   dup  : 1;
  public : const Tspr_t   mp   : 1;
  public : const Tspr_t   imp  : 1;
  public : const Tspr_t   dmp  : 1;
  public : const Tspr_t   icp  : 1;
  public : const Tspr_t   dcp  : 1;
  public : const Tspr_t   up   : 1;

  public :        UPR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL):
    SPR (),
    cup  (0),
   _res  (0),
    ttp  (0),
    pmp  (0),
    picp (0),
    pcup (0),
    dup  (0),
    mp   (0),
    imp  (0),
    dmp  (0),
    icp  (0),
    dcp  (0),
    up   (0)
    {};

  public : void   reset (void  ) {};
  public : Tspr_t read  (void  )
    {
      return ((cup  << 24) |
	      (ttp  << 10) |
	      (pmp  <<  9) |
	      (picp <<  8) |
	      (pcup <<  7) |
	      (dup  <<  6) |
	      (mp   <<  5) |
	      (imp  <<  4) |
	      (dmp  <<  3) |
	      (icp  <<  2) |
	      (dcp  <<  1) |
	      (up   <<  0));
    }
  public : void   write (Tspr_t x) {}; // All bit field is Read Only
  };

  //----------------------------------------------------------
  // [0][2] CPUCFGR
  //----------------------------------------------------------
  class CPUCFGR : public morpheo::behavioural::SPR
  {
  public : const Tspr_t  _res   : 22;
  public : const Tspr_t   ov64s :  1; 
  public : const Tspr_t   of64s :  1;
  public : const Tspr_t   of32s :  1;
  public : const Tspr_t   ob64s :  1;
  public : const Tspr_t   ob32s :  1;
  public : const Tspr_t   cgf   :  1;
  public : const Tspr_t   nsdf  :  1;

  public :        CPUCFGR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL):
   _res   (0), 
    ov64s (0), 
    of64s (0),
    of32s (0),
    ob64s (0),
    ob32s (0),
    cgf   (0),
    nsdf  (0)
    {};

  public : void   reset (void  ) {};
  public : Tspr_t read  (void  )
    {
      return ((ov64s << 9) | 
	      (of64s << 8) |
	      (of32s << 7) |
	      (ob64s << 6) |
	      (ob32s << 5) |
	      (cgf   << 4) |
	      (nsdf  << 0) );
    }
  public : void   write (Tspr_t x) {}; // All bit field is Read Only
  };

  //----------------------------------------------------------
  // [0][3] DMMUCFGR
  //----------------------------------------------------------
  class DMMUCFGR : public morpheo::behavioural::SPR
  {
  public : const Tspr_t  _res   : 20;
  public : const Tspr_t   htr   :  1;
  public : const Tspr_t   teiri :  1;
  public : const Tspr_t   pri   :  1;
  public : const Tspr_t   cri   :  1;
  public : const Tspr_t   nae   :  3;
  public : const Tspr_t   nts   :  3;
  public : const Tspr_t   ntw   :  2;

  public :        DMMUCFGR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL): 
   _res   (0),
    htr   (0),
    teiri (0),
    pri   (0),
    cri   (0),
    nae   (0),
    nts   (0),
    ntw   (0)
    {};
  public : void   reset (void  ) {};
  public : Tspr_t read  (void  )
    {
      return ((htr   << 11) |
	      (teiri << 10) |
	      (pri   <<  9) |
	      (cri   <<  8) |
	      (nae   <<  5) |
	      (nts   <<  2) |
	      (ntw   <<  0) );
    };
  public : void   write (Tspr_t x) {}; // All bit field is Read Only
  };

  //----------------------------------------------------------
  // [0][4] IMMUCFGR
  //----------------------------------------------------------
  class IMMUCFGR : public morpheo::behavioural::SPR
  {
  public : const Tspr_t  _res   : 20;
  public : const Tspr_t   htr   :  1;
  public : const Tspr_t   teiri :  1;
  public : const Tspr_t   pri   :  1;
  public : const Tspr_t   cri   :  1;
  public : const Tspr_t   nae   :  3;
  public : const Tspr_t   nts   :  3;
  public : const Tspr_t   ntw   :  2;

  public :        IMMUCFGR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL): 
   _res   (0),
    htr   (0),
    teiri (0),
    pri   (0),
    cri   (0),
    nae   (0),
    nts   (0),
    ntw   (0)
    {};
  public : void   reset (void  ) {};
  public : Tspr_t read  (void  )
    {
      return ((htr   << 11) |
	      (teiri << 10) |
	      (pri   <<  9) |
	      (cri   <<  8) |
	      (nae   <<  5) |
	      (nts   <<  2) |
	      (ntw   <<  0) );
    };
  public : void   write (Tspr_t x) {}; // All bit field is Read Only
  };

  //----------------------------------------------------------
  // [0][5] DCCFGR
  //----------------------------------------------------------
  class DCCFGR : public morpheo::behavioural::SPR
  {
  public : const Tspr_t  _res    : 17;
  public : const Tspr_t   cbwbri :  1;
  public : const Tspr_t   cbfri  :  1;
  public : const Tspr_t   cblri  :  1;
  public : const Tspr_t   cbpri  :  1;
  public : const Tspr_t   cbiri  :  1;
  public : const Tspr_t   ccri   :  1;
  public : const Tspr_t   cws    :  1;
  public : const Tspr_t   cbs    :  1;
  public : const Tspr_t   ncs    :  4;
  public : const Tspr_t   ncw    :  3;

  public :        DCCFGR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL):
   _res    (0),
    cbwbri (0),
    cbfri  (0),
    cblri  (0),
    cbpri  (0),
    cbiri  (0),
    ccri   (0),
    cws    (0),
    cbs    (0),
    ncs    (0),
    ncw    (0)
    {};
  public : void   reset (void  ) {};
  public : Tspr_t read  (void  )
    {
      return ((cbwbri << 14) |
	      (cbfri  << 13) |
	      (cblri  << 12) |
	      (cbpri  << 11) |
	      (cbiri  << 10) |
	      (ccri   <<  9) |
	      (cws    <<  8) |
	      (cbs    <<  7) |
	      (ncs    <<  3) |
	      (ncw    <<  0) );
    };
  public : void   write (Tspr_t x) {}; // All bit field is Read Only
  };

  //----------------------------------------------------------
  // [0][6] ICCFGR
  //----------------------------------------------------------
  class ICCFGR : public morpheo::behavioural::SPR
  {
  public : const Tspr_t  _res1   : 19;
  public : const Tspr_t   cblri  :  1;
  public : const Tspr_t   cbpri  :  1;
  public : const Tspr_t   cbiri  :  1;
  public : const Tspr_t   ccri   :  1;
  public : const Tspr_t  _res2   :  1;
  public : const Tspr_t   cbs    :  1;
  public : const Tspr_t   ncs    :  4;
  public : const Tspr_t   ncw    :  3;

  public :        ICCFGR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL):
   _res1   (0),
    cblri  (0),
    cbpri  (0),
    cbiri  (0),
    ccri   (0),
   _res2   (0),
    cbs    (0),
    ncs    (0),
    ncw    (0)
    {};
  public : void   reset (void  ) {};
  public : Tspr_t read  (void  )
    {
      return ((cblri  << 12) |
	      (cbpri  << 11) |
	      (cbiri  << 10) |
	      (ccri   <<  9) |
	      (cbs    <<  7) |
	      (ncs    <<  3) |
	      (ncw    <<  0) );
    };
  public : void   write (Tspr_t x) {}; // All bit field is Read Only
  };

  //----------------------------------------------------------
  // [0][7] DCFGR
  //----------------------------------------------------------
  class DCFGR : public morpheo::behavioural::SPR
  {
  public : const Tspr_t  _res  : 28;
  public : const Tspr_t   wpci :  1;
  public : const Tspr_t   ndp  :  3;

  public :        DCFGR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL): 
   _res  (0),
    wpci (0),
    ndp  (0)
    {};
  public : void   reset (void  ) {};
  public : Tspr_t read  (void  )
    {
      return ((wpci << 3) |
	      (ndp  << 0) );
    };
  public : void   write (Tspr_t x) {}; // All bit field is Read Only
  };

  //----------------------------------------------------------
  // [0][8] PCCFGR
  //----------------------------------------------------------
  class PCCFGR : public morpheo::behavioural::SPR
  {
  public : const Tspr_t  _res : 29;
  public : const Tspr_t   npc :  3;

  public :        PCCFGR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL): 
   _res (0),
    npc (0)
    {};
  public : void   reset (void  ) {};
  public : Tspr_t read  (void  )
    {
      return ((npc << 0));
    };
  public : void   write (Tspr_t x) {}; // All bit field is Read Only
  };

  //----------------------------------------------------------
  // [0][16] NPC
  //----------------------------------------------------------
  class NPC : public GENERIC 
  {
  public : NPC (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [0][17] SR
  //----------------------------------------------------------
  class SR : public morpheo::behavioural::SPR
  {
  public :       Tspr_t   cid   :  4;
  public : const Tspr_t  _res   : 11;
  public :       Tspr_t   sumra :  1;
  public : const Tspr_t   fo    :  1;
  public :       Tspr_t   eph   :  1;
  public :       Tspr_t   dsx   :  1;
  public :       Tspr_t   ove   :  1;
  public :       Tspr_t   ov    :  1;
  public :       Tspr_t   cy    :  1;
  public :       Tspr_t   f     :  1;
  public :       Tspr_t   ce    :  1;
  public :       Tspr_t   lee   :  1;
  public :       Tspr_t   ime   :  1;
  public :       Tspr_t   dme   :  1;
  public :       Tspr_t   ice   :  1;
  public :       Tspr_t   dce   :  1;
  public :       Tspr_t   iee   :  1;
  public :       Tspr_t   tee   :  1;
  public :       Tspr_t   sm    :  1;

  public :        SR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL): 
   _res   (0),
    fo    (1)
    {};
  public : void   reset (void  ) 
    {
      cid   = 0;
      sumra = 0;
      eph   = 0;
      dsx   = 0;
      ove   = 0;
      ov    = 0;
      cy    = 0;
      f     = 0;
      ce    = 0;
      lee   = 0;
      ime   = 0;
      dme   = 0;
      ice   = 0;
      dce   = 0;
      iee   = 0;
      tee   = 0;
      sm    = 1;
    };
  public : Tspr_t read  (void  )
    {
      return ((cid   << 28) |
	      (sumra << 16) |
	      (fo    << 15) |
	      (eph   << 14) |
	      (dsx   << 13) |
	      (ove   << 12) |
	      (ov    << 11) |
	      (cy    << 10) |
	      (f     <<  9) |
	      (ce    <<  8) |
	      (lee   <<  7) |
	      (ime   <<  6) |
	      (dme   <<  5) |
	      (ice   <<  4) |
	      (dce   <<  3) |
	      (iee   <<  2) |
	      (tee   <<  1) |
	      (sm    <<  0) );
    };
  public : void   write (Tspr_t x) 
    {
      cid   = x >> 28;
      sumra = x >> 16;
      eph   = x >> 14;
      dsx   = x >> 13;
      ove   = x >> 12;
      ov    = x >> 11;
      cy    = x >> 10;
      f     = x >>  9;
      ce    = x >>  8;
      lee   = x >>  7;
      ime   = x >>  6;
      dme   = x >>  5;
      ice   = x >>  4;
      dce   = x >>  3;
      iee   = x >>  2;
      tee   = x >>  1;
      sm    = x >>  0;
    };
  };

  //----------------------------------------------------------
  // [0][18] PPC
  //----------------------------------------------------------
  class PPC : public GENERIC 
  {
  public : PPC (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [0][20] FPCSR
  //----------------------------------------------------------
  class FPCSR : public morpheo::behavioural::SPR
  {
  public : const Tspr_t  _res  : 20;
  public :       Tspr_t   dzf  :  1;
  public :       Tspr_t   inf  :  1;
  public :       Tspr_t   ivf  :  1;
  public :       Tspr_t   ixf  :  1;
  public :       Tspr_t   zf   :  1;
  public :       Tspr_t   qnf  :  1;
  public :       Tspr_t   snf  :  1;
  public :       Tspr_t   unf  :  1;
  public :       Tspr_t   ovf  :  1;
  public :       Tspr_t   rm   :  2;
  public :       Tspr_t   fpee :  1;

  public :        FPCSR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL): 
    _res (0)
    {};
  public : void   reset (void  ) 
    {
      dzf  = 0;
      inf  = 0;
      ivf  = 0;
      ixf  = 0;
      zf   = 0;
      qnf  = 0;
      snf  = 0;
      unf  = 0;
      ovf  = 0;
      rm   = 0;
      fpee = 0;
    };
  public : Tspr_t read  (void  )
    {
      return ((dzf  << 11) |
	      (inf  << 10) |
	      (ivf  <<  9) |
	      (ixf  <<  8) |
	      (zf   <<  7) |
	      (qnf  <<  6) |
	      (snf  <<  5) |
	      (unf  <<  4) |
	      (ovf  <<  3) |
	      (rm   <<  1) |
	      (fpee <<  0) );
    };
  public : void   write (Tspr_t x) 
    {
      dzf  = x >> 11;
      inf  = x >> 10;
      ivf  = x >>  9;
      ixf  = x >>  8;
      zf   = x >>  7;
      qnf  = x >>  6;
      snf  = x >>  5;
      unf  = x >>  4;
      ovf  = x >>  3;
      rm   = x >>  1;
      fpee = x >>  0;
    };
  };

  //----------------------------------------------------------
  // [0][21] CID
  //----------------------------------------------------------
  class CID : public GENERIC 
  {
  public : CID (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [0][22] TID
  //----------------------------------------------------------
  class TID : public GENERIC 
  {
  public : TID (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [0][23] TSR
  //----------------------------------------------------------
  class TSR : public GENERIC 
  {
  public : TSR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [0][32] EPCR
  //----------------------------------------------------------
  class EPCR : public GENERIC 
  {
  public : EPCR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [0][48] EEAR
  //----------------------------------------------------------
  class EEAR : public GENERIC 
  {
  public : EEAR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [0][64] ESR
  //----------------------------------------------------------
  class ESR : public GENERIC 
  {
  public : ESR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [0][1024] GPR
  //----------------------------------------------------------
  class GPR : public GENERIC 
  {
  public : GPR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [3][0] DCCR
  //----------------------------------------------------------
  class DCCR : public morpheo::behavioural::SPR
  {
  public : const Tspr_t  _res : 24;
  public :       Tspr_t   ew  :  8;

  public :        DCCR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL): 
   _res (0),
    ew  (0)
    {};
  public : void   reset (void  ) {};
  public : Tspr_t read  (void  )
    {
      return ((ew << 0));
    };
  public : void   write (Tspr_t x) 
    {
      ew = (x >> 0);
    };
  };

  //----------------------------------------------------------
  // [3][1] DCBPR
  //----------------------------------------------------------
  class DCBPR : public GENERIC 
  {
  public : DCBPR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [3][2] DCBFR
  //----------------------------------------------------------
  class DCBFR : public GENERIC 
  {
  public : DCBFR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [3][3] DCBIR
  //----------------------------------------------------------
  class DCBIR : public GENERIC 
  {
  public : DCBIR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [3][4] DCBWR
  //----------------------------------------------------------
  class DCBWR : public GENERIC 
  {
  public : DCBWR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

  //----------------------------------------------------------
  // [3][5] DCBLR
  //----------------------------------------------------------
  class DCBLR : public GENERIC 
  {
  public : DCBLR (uint32_t num_front_end=0, uint32_t num_context=0,const Parameters * param=NULL) : GENERIC (num_front_end,num_context,param) {};
  };

//   //----------------------------------------------------------
//   // [0][1] UPR
//   //----------------------------------------------------------
//   class UPR : public morpheo::behavioural::SPR
//   {
//   public :        UPR (void): {};
//   public : void   reset (void  ) {};
//   public : Tspr_t read  (void  )
//     {
//       return ();
//     };
//   public : void   write (Tspr_t x) {};
//   };


}; // end namespace special_register_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
