/*
 * $Id: Front_end_Glue_deallocation.cpp 101 2009-01-15 17:19:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/include/Front_end_Glue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace front_end_glue {


#undef  FUNCTION
#define FUNCTION "Front_end_Glue::deallocation"
  void Front_end_Glue::deallocation (void)
  {
    log_begin(Front_end_Glue,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE2_SIGNAL(out_IFETCH_DECOD_UNIT_CONTEXT_ID                     ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1],_param->_size_context_id);
        
        DELETE2_SIGNAL(out_DECOD_CONTEXT_ID                                 ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],_param->_size_context_id);
        DELETE2_SIGNAL( in_DECOD_DECOD_UNIT_CONTEXT_ID                      ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],_param->_size_context_id);
        
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_VAL                              ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_ACK                              ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION                  ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_PREDICTION_UNIT_VAL              ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_PREDICTION_UNIT_ACK              ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_PREDICTION_UNIT_MISS_PREDICTION  ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_STATE_VAL                ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_STATE_ACK                ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_STATE_MISS_PREDICTION    ,_param->_nb_inst_branch_complete,1);
        
        DELETE1_SIGNAL(out_EVENT_VAL                                        ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_EVENT_ACK                                        ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_EVENT_ADDRESS                                    ,_param->_nb_context,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_EVENT_ADDRESS_NEXT                               ,_param->_nb_context,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_EVENT_ADDRESS_NEXT_VAL                           ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_EVENT_IS_DS_TAKE                                 ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_EVENT_IFETCH_UNIT_VAL                            ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_EVENT_IFETCH_UNIT_ACK                            ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_EVENT_IFETCH_UNIT_ADDRESS                        ,_param->_nb_context,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_EVENT_IFETCH_UNIT_ADDRESS_NEXT                   ,_param->_nb_context,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_EVENT_IFETCH_UNIT_ADDRESS_NEXT_VAL               ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_EVENT_IFETCH_UNIT_IS_DS_TAKE                     ,_param->_nb_context,1);

        DELETE1_SIGNAL(out_EVENT_PREDICTION_UNIT_VAL                        ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_EVENT_PREDICTION_UNIT_ACK                        ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_EVENT_PREDICTION_UNIT_TYPE                       ,_param->_nb_context,_param->_size_event_type);
        DELETE1_SIGNAL(out_EVENT_PREDICTION_UNIT_DEPTH                      ,_param->_nb_context,_param->_size_depth);

        DELETE1_SIGNAL( in_EVENT_CONTEXT_STATE_VAL                          ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_EVENT_CONTEXT_STATE_ACK                          ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_EVENT_CONTEXT_STATE_ADDRESS                      ,_param->_nb_context,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_EVENT_CONTEXT_STATE_ADDRESS_NEXT                 ,_param->_nb_context,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_EVENT_CONTEXT_STATE_ADDRESS_NEXT_VAL             ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_EVENT_CONTEXT_STATE_IS_DS_TAKE                   ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_EVENT_CONTEXT_STATE_TYPE                         ,_param->_nb_context,_param->_size_event_type);
        DELETE1_SIGNAL( in_EVENT_CONTEXT_STATE_DEPTH                        ,_param->_nb_context,_param->_size_depth);
        
        DELETE1_SIGNAL(out_DEPTH_MIN                                        ,_param->_nb_context,_param->_size_depth);
        DELETE1_SIGNAL(out_DEPTH_MAX                                        ,_param->_nb_context,_param->_size_depth);
        DELETE1_SIGNAL(out_DEPTH_FULL                                       ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_DEPTH_PREDICTION_UNIT_VAL                        ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_DEPTH_PREDICTION_UNIT_CURRENT                    ,_param->_nb_context,_param->_size_depth);
        DELETE1_SIGNAL( in_DEPTH_PREDICTION_UNIT_MIN                        ,_param->_nb_context,_param->_size_depth);
        DELETE1_SIGNAL( in_DEPTH_PREDICTION_UNIT_MAX                        ,_param->_nb_context,_param->_size_depth);
        DELETE1_SIGNAL( in_DEPTH_PREDICTION_UNIT_FULL                       ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_DEPTH_CONTEXT_STATE_MIN                          ,_param->_nb_context,_param->_size_depth);
        
//      DELETE2_SIGNAL(out_DEPTH_DECOD_UNIT_CURRENT                         ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1],_param->_size_depth);
        DELETE2_SIGNAL(out_DEPTH_DECOD_UNIT_MIN                             ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1],_param->_size_depth);
        DELETE2_SIGNAL(out_DEPTH_DECOD_UNIT_MAX                             ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1],_param->_size_depth);
        DELETE2_SIGNAL(out_DEPTH_DECOD_UNIT_FULL                            ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1],1);
        
        DELETE2_SIGNAL(out_CONTEXT_DECOD_UNIT_DEPTH_VAL                     ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1],1);
        DELETE2_SIGNAL(out_CONTEXT_DECOD_UNIT_DEPTH                         ,_param->_nb_decod_unit,_param->_decod_unit_nb_context [it1],_param->_size_depth);
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_end(Front_end_Glue,FUNCTION);
  };

}; // end namespace front_end_glue
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
