/*
 * Test_025
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.jr (return procedure)
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        l.and   r1, r0, r0 /* counter 1 */
        l.ori   r2, r0, 10 /* limit */

        l.and   r11, r0, r0
_loop_inc :        
        l.or    r3, r11, r11
        l.jal   _func_inc
        l.nop
        l.sfeq  r11, r2
        l.bnf   _loop_inc
        l.nop

	l.movhi r4,     hi(_func_dec)
	l.ori   r4, r4, lo(_func_dec)
_loop_dec :        
        l.or    r3, r11, r11
        l.jalr  r4
        l.nop
        l.sfeq  r11, r0
        l.bnf   _loop_dec
        l.nop
        
        l.j     _end_ok
        l.nop
        
        .org 0x200
_func_inc :
        l.jr    r9
        l.addi  r11, r3, 1
        l.j     _end_ko
        l.nop

        .org 0x240
_func_dec :
        l.jr    r9
        l.addi  r11, r3, -1
        l.j     _end_ko
        l.nop
       