#include "func_factoriel.h"
#include "func_math.h"
#include "func_io.h"

//-----[ Factoriel ]-------------------------------------------------------

unsigned int factoriel_recursif (unsigned int x)
{
  if ( x <= 1)
    return 1;
  
  return (mul_soft (x , factoriel_recursif (x-1) ) );
}

unsigned int factoriel_iteratif (unsigned int x)
{
  unsigned int res= 1;
  
  while (x > 1)
    {
      res = mul_soft(res,x);
      x --;
    }
  return res;
}

//-------------------------------------------------------------------------
//-----[ Test ]------------------------------------------------------------
//-------------------------------------------------------------------------

void test_factoriel_iteratif (int x)
{
  int x_max = 12;
  int wait [x_max+1];

  wait[0]  = 1;         // 1
  wait[1]  = 1;         // 1
  wait[2]  = 2;         // 2
  wait[3]  = 6;         // 6
  wait[4]  = 24;        // 18
  wait[5]  = 120;       // 78
  wait[6]  = 720;       // 2d0
  wait[7]  = 5040;      // 13b0
  wait[8]  = 40320;     // 9d80
  wait[9]  = 362880;    // 58980
  wait[10] = 3628800;   // 375f00
  wait[11] = 39916800;  // 2611500
  wait[12] = 479001600; // 1c8cfc00
  
  for (int i = 0; i <= ((x<x_max)?x:x_max); i ++)
    if (factoriel_iteratif (i) != wait[i]) quit(i+1);
}

void test_factoriel_recursif (int x)
{
  int x_max = 12;
  int wait [x_max+1];

  wait[0]  = 1;         // 1
  wait[1]  = 1;         // 1
  wait[2]  = 2;         // 2
  wait[3]  = 6;         // 6
  wait[4]  = 24;        // 18
  wait[5]  = 120;       // 78
  wait[6]  = 720;       // 2d0
  wait[7]  = 5040;      // 13b0
  wait[8]  = 40320;     // 9d80
  wait[9]  = 362880;    // 58980
  wait[10] = 3628800;   // 375f00
  wait[11] = 39916800;  // 2611500
  wait[12] = 479001600; // 1c8cfc00
  
  for (int i = 0; i <= ((x<x_max)?x:x_max); i ++)
    if (factoriel_recursif (i) != wait[i]) quit(i+1);
}
