/*
 * Test_039
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.sll
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /*
             A (r1)     B (r2)     - D (r3 wait)
                                           (r4)     
          1) 0xdeadbeef 0x00000000 - 0xdeadbeef
          2) 0xdeadbeef 0x00000008 - 0xadbeef00
          3) 0xdeadbeef 0x00000010 - 0xbeef0000
          4) 0xdeadbeef 0x00000018 - 0xef000000
          5) 0xdeadbeef 0x0000001f - 0x80000000
          6) 0xdeadbeef 0x00000024 - 0xeadbeef0
         */

        /***********/
        /* Test 1  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000000) /* RB */
	l.ori   r2, r2, lo(0x00000000)
	l.movhi r3,     hi(0xdeadbeef) /* RD wait */
	l.ori   r3, r3, lo(0xdeadbeef)
        
        l.sll   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 2  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000008) /* RB */
	l.ori   r2, r2, lo(0x00000008)
	l.movhi r3,     hi(0xadbeef00) /* RD wait */
	l.ori   r3, r3, lo(0xadbeef00)
        
        l.sll   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 3  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000010) /* RB */
	l.ori   r2, r2, lo(0x00000010)
	l.movhi r3,     hi(0xbeef0000) /* RD wait */
	l.ori   r3, r3, lo(0xbeef0000)
        
        l.sll   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 4  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000018) /* RB */
	l.ori   r2, r2, lo(0x00000018)
	l.movhi r3,     hi(0xef000000) /* RD wait */
	l.ori   r3, r3, lo(0xef000000)
        
        l.sll   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 5  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000001f) /* RB */
	l.ori   r2, r2, lo(0x0000001f)
	l.movhi r3,     hi(0x80000000) /* RD wait */
	l.ori   r3, r3, lo(0x80000000)
        
        l.sll   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 6  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000024) /* RB */
	l.ori   r2, r2, lo(0x00000024)
	l.movhi r3,     hi(0xeadbeef0) /* RD wait */
	l.ori   r3, r3, lo(0xeadbeef0)
        
        l.sll   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* End */
        /**********/

        l.j     _end_ok
        l.nop
