/*
 * Test_047
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.sh / l.lhs (l.lhz)
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
	l.movhi r1,     hi(_stack) /* address */
	l.ori   r1, r1, lo(_stack)

 	l.movhi r2,     hi(0x00000010) /* iteration */
	l.ori   r2, r2, lo(0x00000010)

	l.movhi r3,     hi(0xdeadbeef) /* data */
	l.ori   r3, r3, lo(0xdeadbeef)
        
        l.and   r21, r1, r1
        l.j     _loop1_store_test
        l.and   r22, r0, r0
_loop1_store_body :
        l.sh    0(r21), r3
        l.addi  r21, r21, -2
        l.addi  r3, r3,  1
_loop1_store_test :        
        l.sfeq  r22, r2
        l.bnf   _loop1_store_body
        l.addi  r22, r22, 1

        
        /* load Zero */
	l.movhi r3,     hi(0x0000beef) /* data */
	l.ori   r3, r3, lo(0x0000beef)

        l.and   r21, r1, r1
        l.j     _loop1_loadz_test
        l.and   r22, r0, r0
_loop1_loadz_body :
        l.lhz   r4, 0(r21)
        l.addi  r21, r21, -2
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, 1
_loop1_loadz_test :        
        l.sfeq  r22, r2
        l.bnf   _loop1_loadz_body
        l.addi  r22, r22, 1

        /* load Signed */
	l.movhi r3,     hi(0xffffbeef) /* data */
	l.ori   r3, r3, lo(0xffffbeef)

        l.and   r21, r1, r1
        l.j     _loop1_loads_test
        l.and   r22, r0, r0
_loop1_loads_body :
        l.lhs   r4, 0(r21)
        l.addi  r21, r21, -2
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, 1
_loop1_loads_test :        
        l.sfeq  r22, r2
        l.bnf   _loop1_loads_body
        l.addi  r22, r22, 1

	l.movhi r3,     hi(0x12345678) /* data */
	l.ori   r3, r3, lo(0x12345678)
        
        l.and   r21, r1, r1
        l.j     _loop2_store_test
        l.and   r22, r0, r0
_loop2_store_body :
        l.sh    0(r21), r3
        l.addi  r21, r21, -2
        l.addi  r3, r3,  1
_loop2_store_test :        
        l.sfeq  r22, r2
        l.bnf   _loop2_store_body
        l.addi  r22, r22, 1

        /* load Zero */
	l.movhi r3,     hi(0x00005678) /* data */
	l.ori   r3, r3, lo(0x00005678)

        l.and   r21, r1, r1
        l.j     _loop2_loadz_test
        l.and   r22, r0, r0
_loop2_loadz_body :
        l.lhz   r4, 0(r21)
        l.addi  r21, r21, -2
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, 1
_loop2_loadz_test :        
        l.sfeq  r22, r2
        l.bnf   _loop2_loadz_body
        l.addi  r22, r22, 1

        /* load Signed */
	l.movhi r3,     hi(0x00005678) /* data */
	l.ori   r3, r3, lo(0x00005678)

        l.and   r21, r1, r1
        l.j     _loop2_loads_test
        l.and   r22, r0, r0
_loop2_loads_body :
        l.lhs   r4, 0(r21)
        l.addi  r21, r21, -2
        l.sfeq  r4, r3
        l.bnf   _end_ko
        l.addi  r3, r3, 1
_loop2_loads_test :        
        l.sfeq  r22, r2
        l.bnf   _loop2_loads_body
        l.addi  r22, r22, 1
        
        /* end test */
        l.j     _end_ok
        l.nop
