#include "func_math.h"
#include "func_premier.h"
#include "func_io.h"

//-----[ Premier ]---------------------------------------------------------

unsigned int premier(unsigned int x)
{
  unsigned int it;

  if (x <= 0)
    return 0;
  
  if (x <= 2)
    return 1;

  for(it=2; it <= (x/2); it++)
    if (modulo(x,it) == 0)
      return 0;
  
  return 1;
}

unsigned int n_premier(unsigned int nieme_premier)
{
  unsigned int nb_find  = 0;
  unsigned int res      = 1;
  while (nb_find < nieme_premier)
    {
      res ++;
      if (premier(res) == 1)
        nb_find ++;
    }
  return res;
}

//-------------------------------------------------------------------------
//-----[ Test ]------------------------------------------------------------
//-------------------------------------------------------------------------

void test_n_premier (int x)
{
  int x_max = 30;
  int wait [x_max+1];

  wait [ 0] =   1; // 1
  wait [ 1] =   2; // 2
  wait [ 2] =   3; // 3
  wait [ 3] =   5; // 5
  wait [ 4] =   7; // 7
  wait [ 5] =  11; // b
  wait [ 6] =  13; // d
  wait [ 7] =  17; // 11
  wait [ 8] =  19; // 13
  wait [ 9] =  23; // 17
  wait [10] =  29; // 1d
  wait [11] =  31; // 1f
  wait [12] =  37; // 25
  wait [13] =  41; // 29
  wait [14] =  43; // 2b
  wait [15] =  47; // 2f
  wait [16] =  53; // 35
  wait [17] =  59; // 3b
  wait [18] =  61; // 3d
  wait [19] =  67; // 43
  wait [20] =  71; // 47
  wait [21] =  73; // 49
  wait [22] =  79; // 4f
  wait [23] =  83; // 53
  wait [24] =  89; // 59
  wait [25] =  97; // 61
  wait [26] = 101; // 65
  wait [27] = 103; // 67
  wait [28] = 107; // 6b
  wait [29] = 109; // 6d
  wait [30] = 113; // 71
  
  for (int i = 0; i <= ((x<x_max)?x:x_max); i ++)
    if (n_premier (i) != wait[i]) quit(i+1);
}
