/*
 * Test_031
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.mulu
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /*
             A (r1)     B (r2)     - D (r3 wait) OV CY (SR = r6, mask SR = r5)
                                       (r4)                 (r7)
          1) 0x00000000 0x00000000 - 0x00000000  0  0  
          2) 0x12345678 0x00000001 - 0x12345678  0  0  
          3) 0x00000025 0x000064ab - 0x000e8cb7  0  0
          4) 0x0000083b 0x000007bd - 0x003fb08f  ?  ? (0x00000000003fb08f)
          5) 0x0000083b 0xfffff843 - 0xffc04f71  ?  ? (0x0000083affc04f71)
          6) 0xfffff7c5 0x000007bd - 0xffc04f71  ?  ? (0x000007bcffc04f71)
          7) 0xfffff7c5 0xfffff843 - 0x003fb08f  ?  ? (0xfffff008003fb08f)
          8) 0x017e9157 0x00d5ce37 - 0x18883bb1  ?  ? (0x00013f8318883bb1)
          9) 0x017e9157 0xff2a31c9 - 0xe777c44f  ?  ? (0x017d51d3e777c44f)
         10) 0xfe816ea9 0x00d5ce37 - 0xe777c44f  ?  ? (0x00d48eb3e777c44f)
         11) 0xfe816ea9 0xff2a31c9 - 0x18883bb1  ?  ? (0xfdacdff518883bb1)
        */
        
        /* Mask to read OV (SR[11]), CY (SR[10]) and not F (SR[9]) */
	l.movhi r5,     hi(0x00000c00)
	l.ori   r5, r5, lo(0x00000c00)

        /**********/
        /* Test 1 */
        /**********/
	l.movhi r1,     hi(0x00000000) /* RA */
	l.ori   r1, r1, lo(0x00000000)
	l.movhi r2,     hi(0x00000000) /* RB */
	l.ori   r2, r2, lo(0x00000000)
	l.movhi r3,     hi(0x00000000) /* RD wait */
	l.ori   r3, r3, lo(0x00000000)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.mulu  r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 2 */
        /**********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r2,     hi(0x00000001) /* RB */
	l.ori   r2, r2, lo(0x00000001)
	l.movhi r3,     hi(0x12345678) /* RD wait */
	l.ori   r3, r3, lo(0x12345678)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.mulu  r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 3 */
        /**********/
	l.movhi r1,     hi(0x00000025) /* RA */
	l.ori   r1, r1, lo(0x00000025)
	l.movhi r2,     hi(0x000064ab) /* RB */
	l.ori   r2, r2, lo(0x000064ab)
	l.movhi r3,     hi(0x000e8cb7) /* RD wait */
	l.ori   r3, r3, lo(0x000e8cb7)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.mulu  r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 4 */
        /**********/
	l.movhi r1,     hi(0x0000083b) /* RA */
	l.ori   r1, r1, lo(0x0000083b)
	l.movhi r2,     hi(0x000007bd) /* RB */
	l.ori   r2, r2, lo(0x000007bd)
	l.movhi r3,     hi(0x003fb08f) /* RD wait */
	l.ori   r3, r3, lo(0x003fb08f)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.mulu  r4, r1, r2

        /* Test flag */
        /*
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop
        */
        
        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 5 */
        /**********/
	l.movhi r1,     hi(0x0000083b) /* RA */
	l.ori   r1, r1, lo(0x0000083b)
	l.movhi r2,     hi(0xfffff843) /* RB */
	l.ori   r2, r2, lo(0xfffff843)
	l.movhi r3,     hi(0xffc04f71) /* RD wait */
	l.ori   r3, r3, lo(0xffc04f71)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.mulu  r4, r1, r2

        /* Test flag */
        /*
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop
        */
        
        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 6 */
        /**********/
	l.movhi r1,     hi(0xfffff7c5) /* RA */
	l.ori   r1, r1, lo(0xfffff7c5)
	l.movhi r2,     hi(0x000007bd) /* RB */
	l.ori   r2, r2, lo(0x000007bd)
	l.movhi r3,     hi(0xffc04f71) /* RD wait */
	l.ori   r3, r3, lo(0xffc04f71)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.mulu  r4, r1, r2

        /* Test flag */
        /*
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop
        */
        
        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* Test 7 */
        /**********/
	l.movhi r1,     hi(0xfffff7c5) /* RA */
	l.ori   r1, r1, lo(0xfffff7c5)
	l.movhi r2,     hi(0xfffff843) /* RB */
	l.ori   r2, r2, lo(0xfffff843)
	l.movhi r3,     hi(0x003fb08f) /* RD wait */
	l.ori   r3, r3, lo(0x003fb08f)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.mulu  r4, r1, r2

        /* Test flag */
        /*
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop
        */
        
        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 8 */
        /**********/
	l.movhi r1,     hi(0x017e9157) /* RA */
	l.ori   r1, r1, lo(0x017e9157)
	l.movhi r2,     hi(0x00d5ce37) /* RB */
	l.ori   r2, r2, lo(0x00d5ce37)
	l.movhi r3,     hi(0x18883bb1) /* RD wait */
	l.ori   r3, r3, lo(0x18883bb1)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.mulu  r4, r1, r2

        /* Test flag */
        /*
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop
        */
        
        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 9 */
        /**********/
	l.movhi r1,     hi(0x017e9157) /* RA */
	l.ori   r1, r1, lo(0x017e9157)
	l.movhi r2,     hi(0xff2a31c9) /* RB */
	l.ori   r2, r2, lo(0xff2a31c9)
	l.movhi r3,     hi(0xe777c44f) /* RD wait */
	l.ori   r3, r3, lo(0xe777c44f)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.mulu  r4, r1, r2

        /* Test flag */
        /*
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop
        */
        
        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 10*/
        /**********/
	l.movhi r1,     hi(0xfe816ea9) /* RA */
	l.ori   r1, r1, lo(0xfe816ea9)
	l.movhi r2,     hi(0x00d5ce37) /* RB */
	l.ori   r2, r2, lo(0x00d5ce37)
	l.movhi r3,     hi(0xe777c44f) /* RD wait */
	l.ori   r3, r3, lo(0xe777c44f)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.mulu  r4, r1, r2

        /* Test flag */
        /*
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop
        */
        
        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 11*/
        /**********/
	l.movhi r1,     hi(0xfe816ea9) /* RA */
	l.ori   r1, r1, lo(0xfe816ea9)
	l.movhi r2,     hi(0xff2a31c9) /* RB */
	l.ori   r2, r2, lo(0xff2a31c9)
	l.movhi r3,     hi(0x18883bb1) /* RD wait */
	l.ori   r3, r3, lo(0x18883bb1)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.mulu  r4, r1, r2

        /* Test flag */
        /*
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop
        */
        
        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
         
        /* end test */
        l.j     _end_ok
        l.nop
