#ifdef VHDL
/*
 * $Id: Write_queue_vhdl.cpp 103 2009-01-16 16:55:32Z moulu $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/include/Write_queue.h"
#include "Behavioural/include/Vhdl.h"
#include "Behavioural/Generic/Queue/include/Queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace write_queue {


#undef  FUNCTION
#define FUNCTION "Write_queue::vhdl"
  void Write_queue::vhdl (void)
  {
    log_printf(FUNC,Write_queue,FUNCTION,"Begin");

    morpheo::behavioural::generic::queue::Parameters * param_queue;
    morpheo::behavioural::generic::queue::Queue      * queue;
    
    param_queue = new morpheo::behavioural::generic::queue::Parameters
      (_param->_size_queue,
       _param->_size_internal_queue,
       _param->_nb_bypass_write
       );

    std::cout << "size internal queue :" << _param->_size_internal_queue << "." << std::endl;

    std::string queue_name = _name + "_queue";
    queue = new morpheo::behavioural::generic::queue::Queue
      (queue_name.c_str()
#ifdef STATISTICS
       ,NULL
#endif
       ,param_queue
       ,USE_VHDL);
    
    _component->set_component(queue->_component
#ifdef POSITION
                              , 50, 50, 50, 50
#endif
                              , INSTANCE_LIBRARY
                              );



    Vhdl * vhdl = new Vhdl (_name);

    _interfaces->set_port(vhdl);
    _component->vhdl_instance(vhdl);

    vhdl_declaration (vhdl);
    vhdl_body        (vhdl);

    vhdl->generate_file();

    delete vhdl;

    log_printf(FUNC,Write_queue,FUNCTION,"End");
  };

}; // end namespace write_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
