#ifdef SYSTEMC
/*
 * $Id: Decod_queue_genMoore.cpp 105 2009-02-05 11:18:31Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Decod_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::genMoore"
  void Decod_queue::genMoore (void)
  {
    log_begin(Decod_queue,FUNCTION);
    log_function(Decod_queue,FUNCTION,_name.c_str());

    //--------------------------------------------------------------------
    //-----[ DECOD_IN ]---------------------------------------------------
    //--------------------------------------------------------------------
    {
      Tcontrol_t ack = reg_QUEUE->size() < _param->_size_bank;

      for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	{
	  internal_DECOD_IN_ACK [i] = ack;
	  PORT_WRITE(out_DECOD_IN_ACK [i],ack);
	}
    }

    //--------------------------------------------------------------------
    //-----[ DECOD_OUT ]--------------------------------------------------
    //--------------------------------------------------------------------
    if (not reg_QUEUE->empty())
      for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	{
	  if (_param->_have_port_context_id)
	  PORT_WRITE(out_DECOD_OUT_CONTEXT_ID    [i],reg_QUEUE->front()->_context_id    [i]);
	  if (_param->_have_port_depth)
	  PORT_WRITE(out_DECOD_OUT_DEPTH         [i],reg_QUEUE->front()->_depth         [i]);
	  PORT_WRITE(out_DECOD_OUT_TYPE          [i],reg_QUEUE->front()->_type          [i]);
	  PORT_WRITE(out_DECOD_OUT_OPERATION     [i],reg_QUEUE->front()->_operation     [i]);
	  PORT_WRITE(out_DECOD_OUT_NO_EXECUTE    [i],reg_QUEUE->front()->_no_execute    [i]);
	  PORT_WRITE(out_DECOD_OUT_IS_DELAY_SLOT [i],reg_QUEUE->front()->_is_delay_slot [i]);
	  PORT_WRITE(out_DECOD_OUT_ADDRESS_NEXT  [i],reg_QUEUE->front()->_address_next  [i]);
	  PORT_WRITE(out_DECOD_OUT_HAS_IMMEDIAT  [i],reg_QUEUE->front()->_has_immediat  [i]);
	  PORT_WRITE(out_DECOD_OUT_IMMEDIAT      [i],reg_QUEUE->front()->_immediat      [i]);
	  PORT_WRITE(out_DECOD_OUT_READ_RA       [i],reg_QUEUE->front()->_read_ra       [i]);
	  PORT_WRITE(out_DECOD_OUT_NUM_REG_RA    [i],reg_QUEUE->front()->_num_reg_ra    [i]);
	  PORT_WRITE(out_DECOD_OUT_READ_RB       [i],reg_QUEUE->front()->_read_rb       [i]);
	  PORT_WRITE(out_DECOD_OUT_NUM_REG_RB    [i],reg_QUEUE->front()->_num_reg_rb    [i]);
	  PORT_WRITE(out_DECOD_OUT_READ_RC       [i],reg_QUEUE->front()->_read_rc       [i]);
	  PORT_WRITE(out_DECOD_OUT_NUM_REG_RC    [i],reg_QUEUE->front()->_num_reg_rc    [i]);
	  PORT_WRITE(out_DECOD_OUT_WRITE_RD      [i],reg_QUEUE->front()->_write_rd      [i]);
	  PORT_WRITE(out_DECOD_OUT_NUM_REG_RD    [i],reg_QUEUE->front()->_num_reg_rd    [i]);
	  PORT_WRITE(out_DECOD_OUT_WRITE_RE      [i],reg_QUEUE->front()->_write_re      [i]);
	  PORT_WRITE(out_DECOD_OUT_NUM_REG_RE    [i],reg_QUEUE->front()->_num_reg_re    [i]);
	  PORT_WRITE(out_DECOD_OUT_EXCEPTION_USE [i],reg_QUEUE->front()->_exception_use [i]);
	  PORT_WRITE(out_DECOD_OUT_EXCEPTION     [i],reg_QUEUE->front()->_exception     [i]);
	}

    //--------------------------------------------------------------------
    //-----[ NB_INST ]----------------------------------------------------
    //--------------------------------------------------------------------
    for (uint32_t i=0; i<_param->_nb_context; i++)
      PORT_WRITE(out_NB_INST_ALL [i], reg_NB_INST [i]);

    log_end(Decod_queue,FUNCTION);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
