#ifdef SYSTEMC
/*
 * $Id: Two_Level_Branch_Predictor_Glue_deallocation.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Two_Level_Branch_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {


  void Two_Level_Branch_Predictor_Glue::deallocation (void)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"deallocation","Begin");

    delete     in_CLOCK;
    delete     in_NRESET;

    if (_param._have_bht)
      {
    delete []  in_PREDICT_BHT_ACK    ;
    delete [] out_PREDICT_BHT_ADDRESS;
      }
    if (_param._have_pht)
      {
    delete []  in_PREDICT_PHT_ACK    ;
    delete [] out_PREDICT_PHT_ADDRESS;
      }
    if (_param._have_bht and _param._have_pht)
    delete []  in_PREDICT_BHT_HISTORY;
    
    delete [] out_PREDICT_ACK        ;
    delete []  in_PREDICT_ADDRESS    ;

    if (_param._have_bht)
      {
    delete []  in_BRANCH_COMPLETE_BHT_ACK    ;
    delete [] out_BRANCH_COMPLETE_BHT_ADDRESS;
      }
    if (_param._have_pht)
      {
    delete []  in_BRANCH_COMPLETE_PHT_ACK    ;
    delete [] out_BRANCH_COMPLETE_PHT_ADDRESS;
      }
    if (_param._have_bht and _param._have_pht)
    delete []  in_BRANCH_COMPLETE_BHT_HISTORY;
    delete [] out_BRANCH_COMPLETE_ACK        ;
    delete []  in_BRANCH_COMPLETE_ADDRESS    ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete _component;

    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"deallocation","End");
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction


}; // end namespace behavioural
}; // end namespace morpheo              
#endif
