#ifdef VHDL_TESTBENCH
/*
 * $Id: Meta_Predictor_Glue_vhdl_testbench_port.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace meta_predictor_glue {


  void Meta_Predictor_Glue::vhdl_testbench_port ()
  {
    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_testbench_port","Begin");

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_meta_predictor)
	  {
	_vhdl_testbench->set_port (" in_PREDICT_PREDICTOR_0_ACK_"+toString(i)+"                ", IN, 1);
	_vhdl_testbench->set_port (" in_PREDICT_PREDICTOR_1_ACK_"+toString(i)+"                ", IN, 1);
	  }
	_vhdl_testbench->set_port (" in_PREDICT_PREDICTOR_2_ACK_"+toString(i)+"                ", IN, 1);
	_vhdl_testbench->set_port ("out_PREDICT_ACK_"+toString(i)+"                            ",OUT, 1);

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_0_have_bht)
	_vhdl_testbench->set_port (" in_PREDICT_PREDICTOR_0_BHT_HISTORY_"+toString(i)+"        ", IN,_param._predictor_0_bht_size_shifter);
	if (_param._predictor_0_have_pht)
	_vhdl_testbench->set_port (" in_PREDICT_PREDICTOR_0_PHT_HISTORY_"+toString(i)+"        ", IN,_param._predictor_0_pht_size_counter);
	if (_param._predictor_1_have_bht)
	_vhdl_testbench->set_port (" in_PREDICT_PREDICTOR_1_BHT_HISTORY_"+toString(i)+"        ", IN,_param._predictor_1_bht_size_shifter);
	if (_param._predictor_1_have_pht)
	_vhdl_testbench->set_port (" in_PREDICT_PREDICTOR_1_PHT_HISTORY_"+toString(i)+"        ", IN,_param._predictor_1_pht_size_counter);
	  }
	if (_param._predictor_2_have_bht)
	_vhdl_testbench->set_port (" in_PREDICT_PREDICTOR_2_BHT_HISTORY_"+toString(i)+"        ", IN,_param._predictor_2_bht_size_shifter);
	if (_param._predictor_2_have_pht)
	_vhdl_testbench->set_port (" in_PREDICT_PREDICTOR_2_PHT_HISTORY_"+toString(i)+"        ", IN,_param._predictor_2_pht_size_counter);

	_vhdl_testbench->set_port ("out_PREDICT_HISTORY_"+toString(i)+"                        ",OUT,_param._size_history);
	_vhdl_testbench->set_port ("out_PREDICT_DIRECTION_"+toString(i)+"                      ",OUT,1);
      }

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_meta_predictor)
	  {
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_VAL_"+toString(i)+"                    ", IN, 1);
	_vhdl_testbench->set_port ("out_BRANCH_COMPLETE_PREDICTOR_2_VAL_"+toString(i)+"        ",OUT, 1);

	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_PREDICTOR_0_ACK_"+toString(i)+"        ", IN, 1);
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_PREDICTOR_1_ACK_"+toString(i)+"        ", IN, 1);
	  }
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_PREDICTOR_2_ACK_"+toString(i)+"        ", IN, 1);
	_vhdl_testbench->set_port ("out_BRANCH_COMPLETE_ACK_"+toString(i)+"                    ",OUT, 1);

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_0_have_bht)
	_vhdl_testbench->set_port ("out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY_"+toString(i)+"",OUT,_param._predictor_0_bht_size_shifter);
	if (_param._predictor_0_have_pht)
	_vhdl_testbench->set_port ("out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY_"+toString(i)+"",OUT,_param._predictor_0_pht_size_counter);
	if (_param._predictor_1_have_bht)
	_vhdl_testbench->set_port ("out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY_"+toString(i)+"",OUT,_param._predictor_1_bht_size_shifter);
	if (_param._predictor_1_have_pht)
	_vhdl_testbench->set_port ("out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY_"+toString(i)+"",OUT,_param._predictor_1_pht_size_counter);
	  }
	if (_param._predictor_2_have_bht)
	_vhdl_testbench->set_port ("out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY_"+toString(i)+"",OUT,_param._predictor_2_bht_size_shifter);
	if (_param._predictor_2_have_pht)
	_vhdl_testbench->set_port ("out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY_"+toString(i)+"",OUT,_param._predictor_2_pht_size_counter);

	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_HISTORY_"+toString(i)+"                ", IN,_param._size_history);
	if (_param._have_meta_predictor)
	  {
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_DIRECTION_"+toString(i)+"              ", IN,1);
	_vhdl_testbench->set_port ("out_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION_"+toString(i)+"  ",OUT,1);
	  }
      }

    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_testbench_port","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
