/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/SelfTest/include/test.h"

#define NB_PARAMS 10

void usage (string exec)
{
  cerr << "<Usage> " << exec << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - have_bht               (boolean     )" << endl
       << " - bht_size_shifter       (unsigned int)" << endl
       << " - bht_nb_shifter         (unsigned int)" << endl
       << " - have_pht               (boolean     )" << endl
       << " - pht_size_counter       (unsigned int)" << endl
       << " - pht_nb_counter         (unsigned int)" << endl
       << " - pht_size_address_share (unsigned int)" << endl
       << " - size_address           (unsigned int)" << endl
       << " - nb_prediction          (unsigned int)" << endl
       << " - nb_branch_complete     (unsigned int)" << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  cout << "<test0> : Classic usage" << endl;

  if (argc != 2+NB_PARAMS)
    usage (argv[0]);
  
  const string   name                     = argv[1];
  const bool     have_bht                 = atoi(argv[ 2]);
  const uint32_t bht_size_shifter         = atoi(argv[ 3]);
  const uint32_t bht_nb_shifter           = atoi(argv[ 4]);
  const bool     have_pht                 = atoi(argv[ 5]);
  const uint32_t pht_size_counter         = atoi(argv[ 6]);
  const uint32_t pht_nb_counter           = atoi(argv[ 7]);
  const uint32_t pht_size_address_share   = atoi(argv[ 8]);
  const uint32_t size_address             = atoi(argv[ 9]);
  const uint32_t nb_prediction            = atoi(argv[10]);
  const uint32_t nb_branch_complete       = atoi(argv[11]);

  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor::Parameters param (have_bht               ,
														     bht_size_shifter       ,
														     bht_nb_shifter         ,
														     have_pht               ,
														     pht_size_counter       ,
														     pht_nb_counter         ,
														     pht_size_address_share ,
														     size_address           ,
														     nb_prediction          ,
														     nb_branch_complete     );
      
      cout << param.print(1);
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

