#ifdef SYSTEMC
/*
 * $Id: Two_Level_Branch_Predictor_Glue_genMealy_predict_pht_address.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Two_Level_Branch_Predictor_Glue.h"
#include "Common/include/BitManipulation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {

  void Two_Level_Branch_Predictor_Glue::genMealy_predict_pht_address (void)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"genMealy_predict_address","Begin");

    if (_param._have_pht)
      for (uint32_t i=0; i<_param._nb_prediction; i++)
	{
	  // Address
	  Taddress_t address = PORT_READ(in_PREDICT_ADDRESS [i]);
	  Tbht_history_t history = 0;
	  
	  if (_param._have_bht)
	    {
	      history = PORT_READ (in_PREDICT_BHT_HISTORY [i]);
	      address = address << _param._pht_size_address_shift;
	    }
	  
	  PORT_WRITE (out_PREDICT_PHT_ADDRESS [i], (history xor address) & gen_mask<Taddress_t>(_param._pht_size_address));
	}
    
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"genMealy_predict_address","End");
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
