#ifdef SYSTEMC
/*
 * $Id: RegisterFile_Monolithic_transition.cpp 106 2009-02-09 22:55:26Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

#undef  FUNCTION
#define FUNCTION "RegisterFile_Monolithic::transition"
  void RegisterFile_Monolithic::transition (void)
  {
    log_begin(RegisterFile_Monolithic,FUNCTION);
    log_function(RegisterFile_Monolithic,FUNCTION,_name.c_str());

    if (_param->_have_init_value and (PORT_READ(in_NRESET) == 0))
      {
        for (uint32_t i=0; i<_param->_nb_word; ++i)
          reg_DATA[i] = fromString<Tdata_t>(_param->_init_value);
      }
    else
      {
        for (uint32_t i=0; i<_param->_nb_port_write; i++)
          {
            // Have a write?
            if ( PORT_READ(in_WRITE_VAL[i]) == true)
              {
#ifdef STATISTICS
                if (usage_is_set(_usage,USE_STATISTICS))
                  (*_stat_nb_write) ++;
#endif    
                
                Taddress_t address = (_param->_have_port_address)?PORT_READ(in_WRITE_ADDRESS[i]):0;
                Tdata_t    data    = PORT_READ(in_WRITE_DATA   [i]);
                
                log_printf(TRACE,RegisterFile,FUNCTION,"  * [%d] <- %.8x",static_cast<uint32_t>(address),static_cast<uint32_t>(data));
                
                // Write in registerFile
                reg_DATA[address] = data;
              }
          }
        for (uint32_t i=0; i<_param->_nb_port_read_write; i++)
          {
            // Have a read_write?
            if (PORT_READ(in_READ_WRITE_VAL[i]) == true)
              {
                if (PORT_READ(in_READ_WRITE_RW [i]) == RW_WRITE)
                  {
#ifdef STATISTICS
                    if (usage_is_set(_usage,USE_STATISTICS))
                      (*_stat_nb_write) ++;
#endif    
                    
                    Taddress_t address = (_param->_have_port_address)?PORT_READ(in_READ_WRITE_ADDRESS[i]):0;
                    Tdata_t    data    = PORT_READ(in_READ_WRITE_WDATA  [i]);
                    
                    log_printf(TRACE,RegisterFile,FUNCTION,"  * [%d] <- %.8x",static_cast<uint32_t>(address),static_cast<uint32_t>(data));
                    
                    // Write in registerFile
                    reg_DATA[address] = data;
                  }
#ifdef STATISTICS
                else
                  {
                    if (usage_is_set(_usage,USE_STATISTICS))
                      (*_stat_nb_read) ++;
                  }
#endif    
              }
          }
      }

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      for (uint32_t i=0; i<_param->_nb_port_read; i++)
        if ( PORT_READ(in_READ_VAL [i]) == 1)
          (*_stat_nb_read) ++;
#endif    

#if defined(DEBUG_RegisterFile_Monolithic) and DEBUG_RegisterFile_Monolithic and (DEBUG >= DEBUG_TRACE)
    {
      log_printf(TRACE,RegisterFile,FUNCTION,"  * Dump RegisterFile");

      uint32_t limit = 4;
      
      for (uint32_t i=0; i<_param->_nb_word; i+=limit)
        {
          std::string str = "";
          
          for (uint32_t j=0; j<limit; j++)
            {
              uint32_t index = i+j;
              if (index >= _param->_nb_word)
                break;
              else
                str+=toString("[%.4d] %.8x ",index,reg_DATA[index]);
            }

          log_printf(TRACE,RegisterFile,FUNCTION,"  %s",str.c_str());
        }
    }
#endif

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle();
#endif

    log_end(RegisterFile_Monolithic,FUNCTION);
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
