#ifdef SYSTEMC
/*
 * $Id: RegisterFile_Monolithic_genMealy_read.cpp 106 2009-02-09 22:55:26Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

#undef  FUNCTION
#define FUNCTION "RegisterFile_Monolithic::genMealy_read"
  void RegisterFile_Monolithic::genMealy_read (void)
  {
    log_begin(RegisterFile_Monolithic,FUNCTION);
    log_function(RegisterFile_Monolithic,FUNCTION,_name.c_str());

    for (uint32_t i=0; i<_param->_nb_port_read; i++)
      {
	// Have a write?
 	if ( PORT_READ(in_READ_VAL [i]) == 1)
 	  {
	    Taddress_t address;
	    if (_param->_have_port_address)
	      address = PORT_READ(in_READ_ADDRESS[i]);
	    else
	      address = 0;
	    Tdata_t    data    = reg_DATA[address];

	    log_printf(TRACE,RegisterFile,FUNCTION,"  * [%d] -> %.8x",static_cast<uint32_t>(address),static_cast<uint32_t>(data));

	    // Write in registerFile
	    PORT_WRITE(out_READ_DATA[i],data);
 	  }
	else
	  {
	    //log_printf(TRACE,RegisterFile,FUNCTION,"Read [%d] : No   transaction",i);
	    PORT_WRITE(out_READ_DATA[i],0);
	  }
      }

    for (uint32_t i=0; i<_param->_nb_port_read_write; i++)
      {
	Tdata_t data;

	// Have a write?
 	if ( (PORT_READ(in_READ_WRITE_VAL [i]) == 1) and
	     (PORT_READ(in_READ_WRITE_RW  [i]) == RW_READ)
	     )
 	  {
	    Taddress_t address;
	    if (_param->_have_port_address)
	      address = PORT_READ(in_READ_WRITE_ADDRESS[i]);
	    else
	      address = 0;
	    
	    data = reg_DATA[address];

	    log_printf(TRACE,RegisterFile,FUNCTION,"  * [%d] -> %.8x",static_cast<uint32_t>(address),static_cast<uint32_t>(data));
 	  }
	else
	  {
	    //log_printf(TRACE,RegisterFile,FUNCTION,"Read [%d] : No   transaction",i);
	    data = 0;
	  }

	PORT_WRITE(out_READ_WRITE_RDATA[i],data);
      }

    log_end(RegisterFile_Monolithic,FUNCTION);
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
