#ifdef SYSTEMC
/*
 * $Id: Direction_Glue_genMealy_predict.cpp 107 2009-02-10 23:03:25Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/include/Direction_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace direction_glue {


#undef  FUNCTION
#define FUNCTION "Direction_Glue::genMealy_predict"
  void Direction_Glue::genMealy_predict (void)
  {
    log_begin(Direction_Glue,FUNCTION);
    log_function(Direction_Glue,FUNCTION,_name.c_str());

    // constant direction : never / always 
    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
      {
        log_printf(TRACE,Direction_Glue,FUNCTION,"  * PREDICT [%d]",i);

        Tcontrol_t direction;

        switch (_param->_predictor_scheme)
          {
            // defined as constant in Direction_Glue.cpp
//           case PREDICTOR_NEVER_TAKE  :
//             {
//               direction = 0;
//               break;
//             }
//           case PREDICTOR_ALWAYS_TAKE :
//             {
//               direction = 1;
//               break;
//             }
          case PREDICTOR_STATIC    :
            {
              direction = PORT_READ(in_PREDICT_STATIC [i]);
              break;
            }
          case PREDICTOR_LAST_TAKE :
            {
              direction = PORT_READ(in_PREDICT_LAST_TAKE [i]);
              break;
            }
          case PREDICTOR_COUNTER   :
          case PREDICTOR_LOCAL     :
          case PREDICTOR_GLOBAL    :
          case PREDICTOR_META      :
          case PREDICTOR_CUSTOM    :
            {
              // not use :
              // in_PREDICT_LAST_TAKE       
              // in_PREDICT_STATIC
              
              direction = PORT_READ(in_PREDICT_PREDICTOR_DIRECTION [i]);

	      PORT_WRITE(out_PREDICT_PREDICTOR_VAL         [i], PORT_READ(in_PREDICT_VAL                 [i]));
	      PORT_WRITE(out_PREDICT_ACK                   [i], PORT_READ(in_PREDICT_PREDICTOR_ACK       [i]));
	      PORT_WRITE(out_PREDICT_PREDICTOR_ADDRESS_SRC [i], PORT_READ(in_PREDICT_ADDRESS_SRC         [i]));
	      PORT_WRITE(out_PREDICT_HISTORY               [i], PORT_READ(in_PREDICT_PREDICTOR_HISTORY   [i]));
              
              break;
            }
          default :
            {
              ERRORMORPHEO(FUNCTION,"No valid predictor scheme");
              break;
            }
          }
      
        log_printf(TRACE,Direction_Glue,FUNCTION,"    * direction     : %d",direction);

        PORT_WRITE(out_PREDICT_DIRECTION   [i], direction);
      }

    log_end(Direction_Glue,FUNCTION);
  };

}; // end namespace direction_glue
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
