/*
 * $Id: main.cpp 108 2009-02-12 11:55:06Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/SelfTest/include/test.h"

#define NB_PARAMS 5

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_context                                 (uint32_t)\n"));
  err (_(" * nb_decod_unit                              (uint32_t)\n"));
  err (_(" * nb_inst_decod              [nb_decod_unit] (uint32_t)\n"));
  err (_(" * nb_inst_branch_complete                    (uint32_t)\n"));
  err (_(" * link_context_to_decod_unit [nb_context]    (uint32_t)\n"));
  err (_(" * size_address                               (uint32_t)\n"));
  err (_(" * size_depth                 [nb_context]    (uint32_t)\n"));
  err (_(" * nb_branch_speculated       [nb_context]    (uint32_t)\n"));
  err (_(" * size_nb_inst_decod                         (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  for (int32_t i=0; i<argc; ++i)
    msg("%s ",argv[i]);
  msg("\n");

  if (argc <= static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t   _nb_context                 = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_decod_unit              = fromString<uint32_t>(argv[x++]);
  
  if (argc != static_cast<int>(2+NB_PARAMS+3*_nb_context+1*_nb_decod_unit))
    usage (argc, argv);

  uint32_t * _nb_inst_decod              = new uint32_t [_nb_decod_unit];
  for (uint32_t i=0; i<_nb_decod_unit; ++i)
    _nb_inst_decod [i] = fromString<uint32_t>(argv[x++]);

  uint32_t   _nb_inst_branch_complete    = fromString<uint32_t>(argv[x++]);

  uint32_t * _link_context_to_decod_unit = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; ++i)
    _link_context_to_decod_unit [i] = fromString<uint32_t>(argv[x++]);

  uint32_t   _size_address               = fromString<uint32_t>(argv[x++]);

  uint32_t * _size_depth                 = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; ++i)
    _size_depth [i] = fromString<uint32_t>(argv[x++]);

  uint32_t * _nb_branch_speculated       = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; ++i)
    _nb_branch_speculated [i] = fromString<uint32_t>(argv[x++]);

  uint32_t   _size_nb_inst_decod         = fromString<uint32_t>(argv[x++]);

  std::vector<uint32_t> * _translate_context_id_from_decod_unit = new std::vector<uint32_t> [_nb_decod_unit];

  for (uint32_t i=0; i<_nb_context; ++i)
    _translate_context_id_from_decod_unit [_link_context_to_decod_unit[i]].push_back(i);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::front_end_glue::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::front_end_glue::Parameters
	(_nb_context                           ,
         _nb_decod_unit                        ,
         _nb_inst_decod                        ,
         _nb_inst_branch_complete              ,
         _link_context_to_decod_unit           ,
         _translate_context_id_from_decod_unit ,
         _size_address                         ,
         _size_depth                           ,
         _nb_branch_speculated                 ,
         _size_nb_inst_decod                   ,
         true // is_toplevel
        );
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("%s"),error.what ());
      _return = EXIT_FAILURE;
    }
  
  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Front_end_Glue : no error");
      else
	TEST_KO("Front_end_Glue : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  delete [] _translate_context_id_from_decod_unit;
  delete [] _nb_branch_speculated       ;
  delete [] _size_depth                 ;
  delete [] _link_context_to_decod_unit ;
  delete [] _nb_inst_decod              ;

  return (_return);
}
