/*
 * $Id: Parameters.cpp 108 2009-02-12 11:55:06Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Parameters.h"
#include "Common/include/BitManipulation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {


#undef  FUNCTION
#define FUNCTION "Free_List_unit::Parameters"
  Parameters::Parameters (uint32_t    nb_thread          ,
			  uint32_t    nb_general_register,
			  uint32_t    nb_special_register,
			  uint32_t    nb_bank            ,
			  uint32_t    nb_pop             ,
			  uint32_t    nb_push            ,
			  Tpriority_t priority           ,
                          bool        is_toplevel        )
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

    _nb_thread             = nb_thread          ;
    _nb_general_register   = nb_general_register;
    _nb_special_register   = nb_special_register;
    _nb_bank               = nb_bank            ;
    _nb_pop                = nb_pop             ;
    _nb_push               = nb_push            ;
    _priority              = priority           ;

    test();

    uint32_t size_general_register = log2(nb_general_register);
    uint32_t size_special_register = log2(nb_special_register);

    _nb_bank_by_pop        = _nb_bank / _nb_pop;

    uint32_t gpr_nb_slot   = nb_general_register - nb_thread*_nb_general_register_logic;

    _bank_gpr_nb_slot      = gpr_nb_slot/nb_bank;
    _bank_gpr_size_slot    = size_general_register-log2(nb_bank);

    _mask_gpr              = gen_mask<Tgeneral_address_t> (log2(nb_bank));

    uint32_t spr_nb_slot   = nb_special_register - nb_thread*_nb_special_register_logic;

    _bank_spr_nb_slot      = spr_nb_slot/nb_bank;
    _bank_spr_size_slot    = size_special_register-log2(nb_bank);

    _mask_spr              = gen_mask<Tspecial_address_t> (log2(nb_bank));

    if (is_toplevel)
      {
        _size_general_register = size_general_register;
        _size_special_register = size_special_register;

        copy();
      }

    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Free_List_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Free_List_unit,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Free_List_unit::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");
    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Free_List_unit::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");
    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
