/*
 * $Id: Front_end_deallocation.cpp 108 2009-02-12 11:55:06Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/include/Front_end.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {


#undef  FUNCTION
#define FUNCTION "Front_end::deallocation"
  void Front_end::deallocation (void)
  {
    log_begin(Front_end,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL(out_ICACHE_REQ_VAL                   ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_ICACHE_REQ_ACK                   ,_param->_nb_context,1);
//      DELETE1_SIGNAL(out_ICACHE_REQ_THREAD_ID             ,_param->_nb_context,_param->_size_context_id           );
        DELETE1_SIGNAL(out_ICACHE_REQ_PACKET_ID             ,_param->_nb_context,_param->_size_ifetch_queue_ptr     );
        DELETE1_SIGNAL(out_ICACHE_REQ_ADDRESS               ,_param->_nb_context,_param->_size_instruction_address  );
        DELETE1_SIGNAL(out_ICACHE_REQ_TYPE                  ,_param->_nb_context,_param->_size_icache_type          );

        DELETE1_SIGNAL( in_ICACHE_RSP_VAL                   ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_ICACHE_RSP_ACK                   ,_param->_nb_context,1);
//      DELETE1_SIGNAL( in_ICACHE_RSP_THREAD_ID             ,_param->_nb_context,_param->_size_context_id           );
        DELETE1_SIGNAL( in_ICACHE_RSP_PACKET_ID             ,_param->_nb_context,_param->_size_ifetch_queue_ptr     );
        DELETE1_SIGNAL( in_ICACHE_RSP_ERROR                 ,_param->_nb_context,_param->_size_icache_error         );
        DELETE2_SIGNAL( in_ICACHE_RSP_INSTRUCTION           ,_param->_nb_context,_param->_nb_inst_fetch[it1],_param->_size_instruction );

        DELETE1_SIGNAL(out_DECOD_VAL                        ,_param->_sum_inst_decod, 1);
        DELETE1_SIGNAL( in_DECOD_ACK                        ,_param->_sum_inst_decod, 1);
        DELETE1_SIGNAL(out_DECOD_CONTEXT_ID                 ,_param->_sum_inst_decod,_param->_size_context_id            );
        DELETE1_SIGNAL(out_DECOD_DEPTH                      ,_param->_sum_inst_decod,_param->_size_depth                 );
        DELETE1_SIGNAL(out_DECOD_TYPE                       ,_param->_sum_inst_decod,_param->_size_type                  );
        DELETE1_SIGNAL(out_DECOD_OPERATION                  ,_param->_sum_inst_decod,_param->_size_operation             );
        DELETE1_SIGNAL(out_DECOD_NO_EXECUTE                 ,_param->_sum_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_IS_DELAY_SLOT              ,_param->_sum_inst_decod,1                                   );
#ifdef DEBUG
        DELETE1_SIGNAL(out_DECOD_ADDRESS                    ,_param->_sum_inst_decod,_param->_size_instruction_address   );
#endif
        DELETE1_SIGNAL(out_DECOD_ADDRESS_NEXT               ,_param->_sum_inst_decod,_param->_size_instruction_address   );
        DELETE1_SIGNAL(out_DECOD_HAS_IMMEDIAT               ,_param->_sum_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_IMMEDIAT                   ,_param->_sum_inst_decod,_param->_size_general_data          );
        DELETE1_SIGNAL(out_DECOD_READ_RA                    ,_param->_sum_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RA                 ,_param->_sum_inst_decod,_param->_size_general_register_logic);
        DELETE1_SIGNAL(out_DECOD_READ_RB                    ,_param->_sum_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RB                 ,_param->_sum_inst_decod,_param->_size_general_register_logic);
        DELETE1_SIGNAL(out_DECOD_READ_RC                    ,_param->_sum_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RC                 ,_param->_sum_inst_decod,_param->_size_special_register_logic);
        DELETE1_SIGNAL(out_DECOD_WRITE_RD                   ,_param->_sum_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RD                 ,_param->_sum_inst_decod,_param->_size_general_register_logic);
        DELETE1_SIGNAL(out_DECOD_WRITE_RE                   ,_param->_sum_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RE                 ,_param->_sum_inst_decod,_param->_size_special_register_logic);
        DELETE1_SIGNAL(out_DECOD_EXCEPTION_USE              ,_param->_sum_inst_decod,_param->_size_exception_use         );
        DELETE1_SIGNAL(out_DECOD_EXCEPTION                  ,_param->_sum_inst_decod,_param->_size_exception             );

        DELETE1_SIGNAL( in_BRANCH_COMPLETE_VAL              ,_param->_nb_inst_branch_complete, 1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_ACK              ,_param->_nb_inst_branch_complete, 1);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID       ,_param->_nb_inst_branch_complete,_param->_size_context_id);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_DEPTH            ,_param->_nb_inst_branch_complete,_param->_size_depth     );
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_ADDRESS          ,_param->_nb_inst_branch_complete,_param->_size_instruction_address   );
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_NO_SEQUENCE      ,_param->_nb_inst_branch_complete,1                       );
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION  ,_param->_nb_inst_branch_complete,1                       );

        DELETE_SIGNAL ( in_COMMIT_EVENT_VAL                 , 1);
        DELETE_SIGNAL (out_COMMIT_EVENT_ACK                 , 1);
        DELETE_SIGNAL ( in_COMMIT_EVENT_CONTEXT_ID          ,_param->_size_context_id);
        DELETE_SIGNAL ( in_COMMIT_EVENT_DEPTH               ,_param->_size_depth     );
        DELETE_SIGNAL ( in_COMMIT_EVENT_TYPE                ,_param->_size_event_type);
        DELETE_SIGNAL ( in_COMMIT_EVENT_IS_DELAY_SLOT       ,1                       );
        DELETE_SIGNAL ( in_COMMIT_EVENT_ADDRESS             ,_param->_size_instruction_address   );
        DELETE_SIGNAL ( in_COMMIT_EVENT_ADDRESS_EPCR_VAL    ,1                       );
        DELETE_SIGNAL ( in_COMMIT_EVENT_ADDRESS_EPCR        ,_param->_size_instruction_address   );
        DELETE_SIGNAL ( in_COMMIT_EVENT_ADDRESS_EEAR_VAL    ,1                       );
        DELETE_SIGNAL ( in_COMMIT_EVENT_ADDRESS_EEAR        ,_param->_size_instruction_address   );

        DELETE1_SIGNAL(out_EVENT_VAL                        ,_param->_nb_context, 1);
        DELETE1_SIGNAL( in_EVENT_ACK                        ,_param->_nb_context, 1);
        DELETE1_SIGNAL(out_EVENT_ADDRESS                    ,_param->_nb_context,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_EVENT_ADDRESS_NEXT               ,_param->_nb_context,_param->_size_instruction_address); 
        DELETE1_SIGNAL(out_EVENT_ADDRESS_NEXT_VAL           ,_param->_nb_context,1                    );
        DELETE1_SIGNAL(out_EVENT_IS_DS_TAKE                 ,_param->_nb_context,1                    );

        DELETE1_SIGNAL(out_SPR_EVENT_VAL                    ,_param->_nb_context, 1);
        DELETE1_SIGNAL( in_SPR_EVENT_ACK                    ,_param->_nb_context, 1);
        DELETE1_SIGNAL(out_SPR_EVENT_EPCR                   ,_param->_nb_context,_param->_size_spr);
        DELETE1_SIGNAL(out_SPR_EVENT_EEAR_WEN               ,_param->_nb_context,1                );
        DELETE1_SIGNAL(out_SPR_EVENT_EEAR                   ,_param->_nb_context,_param->_size_spr);
        DELETE1_SIGNAL(out_SPR_EVENT_SR_DSX                 ,_param->_nb_context,1                );
        DELETE1_SIGNAL(out_SPR_EVENT_SR_TO_ESR              ,_param->_nb_context,1                );

        DELETE1_SIGNAL( in_NB_INST_COMMIT_ALL               ,_param->_nb_context,_param->_size_nb_inst_commit);
        DELETE1_SIGNAL( in_NB_INST_COMMIT_MEM               ,_param->_nb_context,_param->_size_nb_inst_commit);
        DELETE1_SIGNAL(out_NB_INST_DECOD_ALL                ,_param->_nb_context,_param->_size_nb_inst_decod);

        DELETE1_SIGNAL(out_DEPTH_MIN                        ,_param->_nb_context,_param->_size_depth  );
        DELETE1_SIGNAL(out_DEPTH_MAX                        ,_param->_nb_context,_param->_size_depth+1);
        DELETE1_SIGNAL(out_DEPTH_FULL                       ,_param->_nb_context,_param->_size_depth+1);

        DELETE1_SIGNAL( in_SPR_SR_IEE                       ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_SPR_SR_EPH                       ,_param->_nb_context,1);

        DELETE1_SIGNAL( in_INTERRUPT_ENABLE                 ,_param->_nb_context,1);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete    _component_glue           ;
    delete    _component_context_state  ;
    delete [] _component_decod_unit     ;
    delete    _component_prediction_unit;
    delete [] _component_ifetch_unit    ;

    delete _component;

    log_end(Front_end,FUNCTION);
  };

}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
