/*
 * $Id: test.cpp 108 2009-02-12 11:55:06Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */
#define NB_ITERATION  256
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_select/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Common/include/BitManipulation.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_select::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Rename_select * _Rename_select = new Rename_select
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC2_SC_SIGNAL( in_RENAME_IN_VAL           ," in_RENAME_IN_VAL           ",Tcontrol_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL(out_RENAME_IN_ACK           ,"out_RENAME_IN_ACK           ",Tcontrol_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_FRONT_END_ID  ," in_RENAME_IN_FRONT_END_ID  ",Tcontext_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_CONTEXT_ID    ," in_RENAME_IN_CONTEXT_ID    ",Tcontext_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_DEPTH         ," in_RENAME_IN_DEPTH         ",Tdepth_t          ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_TYPE          ," in_RENAME_IN_TYPE          ",Ttype_t           ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_OPERATION     ," in_RENAME_IN_OPERATION     ",Toperation_t      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NO_EXECUTE    ," in_RENAME_IN_NO_EXECUTE    ",Tcontrol_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_IS_DELAY_SLOT ," in_RENAME_IN_IS_DELAY_SLOT ",Tcontrol_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
#ifdef DEBUG
  ALLOC2_SC_SIGNAL( in_RENAME_IN_ADDRESS       ," in_RENAME_IN_ADDRESS       ",Taddress_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
#endif
  ALLOC2_SC_SIGNAL( in_RENAME_IN_ADDRESS_NEXT  ," in_RENAME_IN_ADDRESS_NEXT  ",Taddress_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_HAS_IMMEDIAT  ," in_RENAME_IN_HAS_IMMEDIAT  ",Tcontrol_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_IMMEDIAT      ," in_RENAME_IN_IMMEDIAT      ",Tgeneral_data_t   ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_READ_RA       ," in_RENAME_IN_READ_RA       ",Tcontrol_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RA    ," in_RENAME_IN_NUM_REG_RA    ",Tgeneral_address_t,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_READ_RB       ," in_RENAME_IN_READ_RB       ",Tcontrol_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RB    ," in_RENAME_IN_NUM_REG_RB    ",Tgeneral_address_t,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_READ_RC       ," in_RENAME_IN_READ_RC       ",Tcontrol_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RC    ," in_RENAME_IN_NUM_REG_RC    ",Tspecial_address_t,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_WRITE_RD      ," in_RENAME_IN_WRITE_RD      ",Tcontrol_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RD    ," in_RENAME_IN_NUM_REG_RD    ",Tgeneral_address_t,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_WRITE_RE      ," in_RENAME_IN_WRITE_RE      ",Tcontrol_t        ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_NUM_REG_RE    ," in_RENAME_IN_NUM_REG_RE    ",Tspecial_address_t,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_EXCEPTION_USE ," in_RENAME_IN_EXCEPTION_USE ",Texception_t      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IN_EXCEPTION     ," in_RENAME_IN_EXCEPTION     ",Texception_t      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);

  ALLOC1_SC_SIGNAL(out_RENAME_OUT_VAL          ,"out_RENAME_OUT_VAL          ",Tcontrol_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL( in_RENAME_OUT_ACK          ," in_RENAME_OUT_ACK          ",Tcontrol_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_FRONT_END_ID ,"out_RENAME_OUT_FRONT_END_ID ",Tcontext_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_CONTEXT_ID   ,"out_RENAME_OUT_CONTEXT_ID   ",Tcontext_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_DEPTH        ,"out_RENAME_OUT_DEPTH        ",Tdepth_t          ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_TYPE         ,"out_RENAME_OUT_TYPE         ",Ttype_t           ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_OPERATION    ,"out_RENAME_OUT_OPERATION    ",Toperation_t      ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_NO_EXECUTE   ,"out_RENAME_OUT_NO_EXECUTE   ",Tcontrol_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_IS_DELAY_SLOT,"out_RENAME_OUT_IS_DELAY_SLOT",Tcontrol_t        ,_param->_nb_inst_rename);
#ifdef DEBUG
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_ADDRESS      ,"out_RENAME_OUT_ADDRESS      ",Taddress_t        ,_param->_nb_inst_rename);
#endif
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_ADDRESS_NEXT ,"out_RENAME_OUT_ADDRESS_NEXT ",Taddress_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_HAS_IMMEDIAT ,"out_RENAME_OUT_HAS_IMMEDIAT ",Tcontrol_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_IMMEDIAT     ,"out_RENAME_OUT_IMMEDIAT     ",Tgeneral_data_t   ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_READ_RA      ,"out_RENAME_OUT_READ_RA      ",Tcontrol_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_NUM_REG_RA   ,"out_RENAME_OUT_NUM_REG_RA   ",Tgeneral_address_t,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_READ_RB      ,"out_RENAME_OUT_READ_RB      ",Tcontrol_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_NUM_REG_RB   ,"out_RENAME_OUT_NUM_REG_RB   ",Tgeneral_address_t,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_READ_RC      ,"out_RENAME_OUT_READ_RC      ",Tcontrol_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_NUM_REG_RC   ,"out_RENAME_OUT_NUM_REG_RC   ",Tspecial_address_t,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_WRITE_RD     ,"out_RENAME_OUT_WRITE_RD     ",Tcontrol_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_NUM_REG_RD   ,"out_RENAME_OUT_NUM_REG_RD   ",Tgeneral_address_t,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_WRITE_RE     ,"out_RENAME_OUT_WRITE_RE     ",Tcontrol_t        ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_NUM_REG_RE   ,"out_RENAME_OUT_NUM_REG_RE   ",Tspecial_address_t,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_EXCEPTION_USE,"out_RENAME_OUT_EXCEPTION_USE",Texception_t      ,_param->_nb_inst_rename);
  ALLOC1_SC_SIGNAL(out_RENAME_OUT_EXCEPTION    ,"out_RENAME_OUT_EXCEPTION    ",Texception_t      ,_param->_nb_inst_rename);

  ALLOC2_SC_SIGNAL( in_RETIRE_EVENT_STATE      ," in_RETIRE_EVENT_STATE      ",Tevent_state_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Rename_select.\n"),name.c_str());

  (*(_Rename_select->in_CLOCK))        (*(in_CLOCK));
  (*(_Rename_select->in_NRESET))       (*(in_NRESET));

  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_VAL           ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select,out_RENAME_IN_ACK           ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_FRONT_END_ID  ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_CONTEXT_ID    ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  if (_param->_have_port_depth)
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_DEPTH         ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_TYPE          ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_OPERATION     ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_NO_EXECUTE    ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_IS_DELAY_SLOT ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
#ifdef DEBUG
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_ADDRESS       ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
#endif
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_ADDRESS_NEXT  ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_HAS_IMMEDIAT  ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_IMMEDIAT      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_READ_RA       ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_NUM_REG_RA    ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_READ_RB       ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_NUM_REG_RB    ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_READ_RC       ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_NUM_REG_RC    ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_WRITE_RD      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_NUM_REG_RD    ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_WRITE_RE      ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_NUM_REG_RE    ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_EXCEPTION_USE ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_Rename_select, in_RENAME_IN_EXCEPTION     ,_param->_nb_front_end, _param->_nb_inst_decod[it1]);

  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_VAL          ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select, in_RENAME_OUT_ACK          ,_param->_nb_inst_rename);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_FRONT_END_ID ,_param->_nb_inst_rename);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_CONTEXT_ID   ,_param->_nb_inst_rename);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_DEPTH        ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_TYPE         ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_OPERATION    ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_NO_EXECUTE   ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_IS_DELAY_SLOT,_param->_nb_inst_rename);
#ifdef DEBUG
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_ADDRESS      ,_param->_nb_inst_rename);
#endif
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_ADDRESS_NEXT ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_HAS_IMMEDIAT ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_IMMEDIAT     ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_READ_RA      ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_NUM_REG_RA   ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_READ_RB      ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_NUM_REG_RB   ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_READ_RC      ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_NUM_REG_RC   ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_WRITE_RD     ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_NUM_REG_RD   ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_WRITE_RE     ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_NUM_REG_RE   ,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_EXCEPTION_USE,_param->_nb_inst_rename);
  INSTANCE1_SC_SIGNAL(_Rename_select,out_RENAME_OUT_EXCEPTION    ,_param->_nb_inst_rename);

  INSTANCE2_SC_SIGNAL(_Rename_select, in_RETIRE_EVENT_STATE      ,_param->_nb_front_end, _param->_nb_context[it1]);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_rename_in  = 75;
  const  int32_t percent_transaction_rename_out = 75;

  uint32_t nb_rename_in = 0;
  for (uint32_t i=0; i<_param->_nb_front_end; i++)
    nb_rename_in += _param->_nb_inst_decod[i];

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  
  
  for (uint32_t i=0; i<_param->_nb_front_end; i++)
    for (uint32_t j=0; j<_param->_nb_context[i]; j++)
      in_RETIRE_EVENT_STATE [i][j]->write(EVENT_STATE_NO_EVENT);

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      uint32_t address=0;
      for (uint32_t i=0; i<_param->_nb_front_end; i++)
	for (uint32_t j=0; j<_param->_nb_inst_decod[i]; j++)
	  {
	    in_RENAME_IN_VAL          [i][j]->write((rand()%100)<percent_transaction_rename_in);
	    in_RENAME_IN_FRONT_END_ID [i][j]->write(range<Tcontext_t        >(rand(),_param->_size_front_end_id          ));
	    in_RENAME_IN_CONTEXT_ID   [i][j]->write(range<Tcontext_t        >(rand(),log2(_param->_nb_context[i])        ));
	    in_RENAME_IN_DEPTH        [i][j]->write(range<Tdepth_t          >(rand(),_param->_size_depth                 ));
	    in_RENAME_IN_TYPE         [i][j]->write(range<Ttype_t           >(rand(),_param->_size_type                  ));
	    in_RENAME_IN_OPERATION    [i][j]->write(range<Toperation_t      >(rand(),_param->_size_operation             ));
	    in_RENAME_IN_NO_EXECUTE   [i][j]->write(rand()%2);
	    in_RENAME_IN_IS_DELAY_SLOT[i][j]->write(rand()%2);
	    in_RENAME_IN_ADDRESS_NEXT [i][j]->write(address++                                                             );
	    in_RENAME_IN_HAS_IMMEDIAT [i][j]->write(range<Tcontrol_t        >(rand(),1                                   ));
	    in_RENAME_IN_IMMEDIAT     [i][j]->write(range<Tgeneral_data_t   >(rand(),_param->_size_general_data          ));
	    in_RENAME_IN_READ_RA      [i][j]->write(range<Tcontrol_t        >(rand(),1                                   ));
	    in_RENAME_IN_NUM_REG_RA   [i][j]->write(range<Tgeneral_address_t>(rand(),_param->_size_general_register_logic));
	    in_RENAME_IN_READ_RB      [i][j]->write(range<Tcontrol_t        >(rand(),1                                   ));
	    in_RENAME_IN_NUM_REG_RB   [i][j]->write(range<Tgeneral_address_t>(rand(),_param->_size_general_register_logic));
	    in_RENAME_IN_READ_RC      [i][j]->write(range<Tcontrol_t        >(rand(),1                                   ));
	    in_RENAME_IN_NUM_REG_RC   [i][j]->write(range<Tspecial_address_t>(rand(),_param->_size_special_register_logic));
	    in_RENAME_IN_WRITE_RD     [i][j]->write(range<Tcontrol_t        >(rand(),1                                   ));
	    in_RENAME_IN_NUM_REG_RD   [i][j]->write(range<Tgeneral_address_t>(rand(),_param->_size_general_register_logic));
	    in_RENAME_IN_WRITE_RE     [i][j]->write(range<Tcontrol_t        >(rand(),1                                   ));
	    in_RENAME_IN_NUM_REG_RE   [i][j]->write(range<Tspecial_address_t>(rand(),_param->_size_special_register_logic));
	    in_RENAME_IN_EXCEPTION_USE[i][j]->write(range<Texception_t      >(rand(),_param->_size_exception             ));
	    in_RENAME_IN_EXCEPTION    [i][j]->write(range<Texception_t      >(rand(),_param->_size_exception             ));
	  }

      for (uint32_t i=0; i<_param->_nb_inst_rename; i++)
	in_RENAME_OUT_ACK [i]->write((rand()%100)<percent_transaction_rename_out);

      SC_START(0);

      uint32_t nb_transaction_rename_in  = 0;
      uint32_t nb_transaction_rename_out = 0;

      bool rename_in_use [nb_rename_in];
      address = 0;

      for (uint32_t i=0; i<_param->_nb_front_end; i++)
	for (uint32_t j=0; j<_param->_nb_inst_decod[i]; j++)
	  {
	    rename_in_use[address++] = false;

	    if (in_RENAME_IN_VAL [i][j]->read() and out_RENAME_IN_ACK [i][j]->read())
	      {
		nb_transaction_rename_in ++;
	      }
	  }
      
      for (uint32_t i=0; i<_param->_nb_inst_rename; i++)
	{
	  if (out_RENAME_OUT_VAL [i]->read() and in_RENAME_OUT_ACK [i]->read())
	    {
	      nb_transaction_rename_out ++;

	      // Test
	      address = out_RENAME_OUT_ADDRESS_NEXT [i]->read();

	      TEST(bool, address<nb_rename_in, true);
	      TEST(bool, rename_in_use[address], false);
	      rename_in_use[address] = true;

	      bool find = false;

	      for (uint32_t x=0; x<_param->_nb_front_end; x++)
		for (uint32_t y=0; y<_param->_nb_inst_decod[x]; y++)
		  if (in_RENAME_IN_ADDRESS_NEXT [x][y]->read() == address)
		    {
		      find = true;
		      
		      if (_param->_have_port_front_end_id)
		      TEST(Tcontext_t        ,out_RENAME_OUT_FRONT_END_ID [i]->read(),in_RENAME_IN_FRONT_END_ID [x][y]->read());
		      if (_param->_have_port_context_id)
		      TEST(Tcontext_t        ,out_RENAME_OUT_CONTEXT_ID   [i]->read(),in_RENAME_IN_CONTEXT_ID   [x][y]->read());
		      if (_param->_have_port_depth)
		      TEST(Tdepth_t          ,out_RENAME_OUT_DEPTH        [i]->read(),in_RENAME_IN_DEPTH        [x][y]->read());
		      TEST(Ttype_t           ,out_RENAME_OUT_TYPE         [i]->read(),in_RENAME_IN_TYPE         [x][y]->read());
		      TEST(Toperation_t      ,out_RENAME_OUT_OPERATION    [i]->read(),in_RENAME_IN_OPERATION    [x][y]->read());
		      TEST(Tcontrol_t        ,out_RENAME_OUT_NO_EXECUTE   [i]->read(),in_RENAME_IN_NO_EXECUTE   [x][y]->read());
		      TEST(Tcontrol_t        ,out_RENAME_OUT_IS_DELAY_SLOT[i]->read(),in_RENAME_IN_IS_DELAY_SLOT[x][y]->read());
		      TEST(Tcontrol_t        ,out_RENAME_OUT_HAS_IMMEDIAT [i]->read(),in_RENAME_IN_HAS_IMMEDIAT [x][y]->read());
		      TEST(Tgeneral_data_t   ,out_RENAME_OUT_IMMEDIAT     [i]->read(),in_RENAME_IN_IMMEDIAT     [x][y]->read());
		      TEST(Tcontrol_t        ,out_RENAME_OUT_READ_RA      [i]->read(),in_RENAME_IN_READ_RA      [x][y]->read());
		      TEST(Tgeneral_address_t,out_RENAME_OUT_NUM_REG_RA   [i]->read(),in_RENAME_IN_NUM_REG_RA   [x][y]->read());
		      TEST(Tcontrol_t        ,out_RENAME_OUT_READ_RB      [i]->read(),in_RENAME_IN_READ_RB      [x][y]->read());
		      TEST(Tgeneral_address_t,out_RENAME_OUT_NUM_REG_RB   [i]->read(),in_RENAME_IN_NUM_REG_RB   [x][y]->read());
		      TEST(Tcontrol_t        ,out_RENAME_OUT_READ_RC      [i]->read(),in_RENAME_IN_READ_RC      [x][y]->read());
		      TEST(Tspecial_address_t,out_RENAME_OUT_NUM_REG_RC   [i]->read(),in_RENAME_IN_NUM_REG_RC   [x][y]->read());
		      TEST(Tcontrol_t        ,out_RENAME_OUT_WRITE_RD     [i]->read(),in_RENAME_IN_WRITE_RD     [x][y]->read());
		      TEST(Tgeneral_address_t,out_RENAME_OUT_NUM_REG_RD   [i]->read(),in_RENAME_IN_NUM_REG_RD   [x][y]->read());
		      TEST(Tcontrol_t        ,out_RENAME_OUT_WRITE_RE     [i]->read(),in_RENAME_IN_WRITE_RE     [x][y]->read());
		      TEST(Tspecial_address_t,out_RENAME_OUT_NUM_REG_RE   [i]->read(),in_RENAME_IN_NUM_REG_RE   [x][y]->read());
		      TEST(Texception_t      ,out_RENAME_OUT_EXCEPTION_USE[i]->read(),in_RENAME_IN_EXCEPTION_USE[x][y]->read());
		      TEST(Texception_t      ,out_RENAME_OUT_EXCEPTION    [i]->read(),in_RENAME_IN_EXCEPTION    [x][y]->read());
		  }

	      TEST(bool, find, true);
	    }
	}

      TEST(uint32_t, nb_transaction_rename_in, nb_transaction_rename_out);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_RENAME_IN_VAL           ;
  delete [] out_RENAME_IN_ACK           ;
  delete []  in_RENAME_IN_FRONT_END_ID  ;
  delete []  in_RENAME_IN_CONTEXT_ID    ;
  delete []  in_RENAME_IN_DEPTH         ;
  delete []  in_RENAME_IN_TYPE          ;
  delete []  in_RENAME_IN_OPERATION     ;
  delete []  in_RENAME_IN_NO_EXECUTE    ;
  delete []  in_RENAME_IN_IS_DELAY_SLOT ;
#ifdef DEBUG
  delete []  in_RENAME_IN_ADDRESS       ;
#endif
  delete []  in_RENAME_IN_ADDRESS_NEXT  ;
  delete []  in_RENAME_IN_HAS_IMMEDIAT  ;
  delete []  in_RENAME_IN_IMMEDIAT      ;
  delete []  in_RENAME_IN_READ_RA       ;
  delete []  in_RENAME_IN_NUM_REG_RA    ;
  delete []  in_RENAME_IN_READ_RB       ;
  delete []  in_RENAME_IN_NUM_REG_RB    ;
  delete []  in_RENAME_IN_READ_RC       ;
  delete []  in_RENAME_IN_NUM_REG_RC    ;
  delete []  in_RENAME_IN_WRITE_RD      ;
  delete []  in_RENAME_IN_NUM_REG_RD    ;
  delete []  in_RENAME_IN_WRITE_RE      ;
  delete []  in_RENAME_IN_NUM_REG_RE    ;
  delete []  in_RENAME_IN_EXCEPTION_USE ;
  delete []  in_RENAME_IN_EXCEPTION     ;
  
  delete [] out_RENAME_OUT_VAL          ;
  delete []  in_RENAME_OUT_ACK          ;
  delete [] out_RENAME_OUT_FRONT_END_ID ;
  delete [] out_RENAME_OUT_CONTEXT_ID   ;
  delete [] out_RENAME_OUT_DEPTH        ;
  delete [] out_RENAME_OUT_TYPE         ;
  delete [] out_RENAME_OUT_OPERATION    ;
  delete [] out_RENAME_OUT_NO_EXECUTE   ;
  delete [] out_RENAME_OUT_IS_DELAY_SLOT;
#ifdef DEBUG
  delete [] out_RENAME_OUT_ADDRESS      ;
#endif
  delete [] out_RENAME_OUT_ADDRESS_NEXT ;
  delete [] out_RENAME_OUT_HAS_IMMEDIAT ;
  delete [] out_RENAME_OUT_IMMEDIAT     ;
  delete [] out_RENAME_OUT_READ_RA      ;
  delete [] out_RENAME_OUT_NUM_REG_RA   ;
  delete [] out_RENAME_OUT_READ_RB      ;
  delete [] out_RENAME_OUT_NUM_REG_RB   ;
  delete [] out_RENAME_OUT_READ_RC      ;
  delete [] out_RENAME_OUT_NUM_REG_RC   ;
  delete [] out_RENAME_OUT_WRITE_RD     ;
  delete [] out_RENAME_OUT_NUM_REG_RD   ;
  delete [] out_RENAME_OUT_WRITE_RE     ;
  delete [] out_RENAME_OUT_NUM_REG_RE   ;
  delete [] out_RENAME_OUT_EXCEPTION_USE;
  delete [] out_RENAME_OUT_EXCEPTION    ;

  DELETE2_SC_SIGNAL( in_RETIRE_EVENT_STATE          ,_param->_nb_front_end, _param->_nb_context[it1]);
#endif

  delete _Rename_select;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
