#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_OOO_Engine_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_OOO_Engine_h

/*
 * $Id: OOO_Engine.h 108 2009-02-12 11:55:06Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/include/Parameters.h"
#include "Behavioural/include/Types.h"

#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/include/Rename_unit.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Commit_unit.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Issue_queue.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Reexecute_unit.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Special_Register_unit/include/Special_Register_unit.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/OOO_Engine_Glue/include/OOO_Engine_Glue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {

  class OOO_Engine 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET;

    // ~~~~~[ Interface : "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_VAL                       ;//[nb_front_end][nb_inst_decod]
  public    : SC_OUT(Tcontrol_t        )  *** out_RENAME_ACK                       ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontext_t        )  ***  in_RENAME_FRONT_END_ID              ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontext_t        )  ***  in_RENAME_CONTEXT_ID                ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tdepth_t          )  ***  in_RENAME_DEPTH                     ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Ttype_t           )  ***  in_RENAME_TYPE                      ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Toperation_t      )  ***  in_RENAME_OPERATION                 ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_NO_EXECUTE                ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_IS_DELAY_SLOT             ;//[nb_front_end][nb_inst_decod]
#ifdef DEBUG
  public    : SC_IN (Taddress_t        )  ***  in_RENAME_ADDRESS                   ;//[nb_front_end][nb_inst_decod]
#endif
  public    : SC_IN (Taddress_t        )  ***  in_RENAME_ADDRESS_NEXT              ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_HAS_IMMEDIAT              ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tgeneral_data_t   )  ***  in_RENAME_IMMEDIAT                  ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_READ_RA                   ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tgeneral_address_t)  ***  in_RENAME_NUM_REG_RA                ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_READ_RB                   ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tgeneral_address_t)  ***  in_RENAME_NUM_REG_RB                ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_READ_RC                   ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tspecial_address_t)  ***  in_RENAME_NUM_REG_RC                ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_WRITE_RD                  ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tgeneral_address_t)  ***  in_RENAME_NUM_REG_RD                ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_WRITE_RE                  ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tspecial_address_t)  ***  in_RENAME_NUM_REG_RE                ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Texception_t      )  ***  in_RENAME_EXCEPTION_USE             ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Texception_t      )  ***  in_RENAME_EXCEPTION                 ;//[nb_front_end][nb_inst_decod]

    // ~~~~~[ Interface : "issue" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_ISSUE_VAL                        ;//[nb_inst_issue]
  public    : SC_IN (Tcontrol_t        )   **  in_ISSUE_ACK                        ;//[nb_inst_issue]
  public    : SC_OUT(Tcontext_t        )   ** out_ISSUE_FRONT_END_ID               ;//[nb_inst_issue]
  public    : SC_OUT(Tcontext_t        )   ** out_ISSUE_CONTEXT_ID                 ;//[nb_inst_issue]
  public    : SC_OUT(Tpacket_t         )   ** out_ISSUE_PACKET_ID                  ;//[nb_inst_issue]
  public    : SC_OUT(Ttype_t           )   ** out_ISSUE_TYPE                       ;//[nb_inst_issue]
  public    : SC_OUT(Toperation_t      )   ** out_ISSUE_OPERATION                  ;//[nb_inst_issue]
  public    : SC_OUT(Tlsq_ptr_t        )   ** out_ISSUE_STORE_QUEUE_PTR_WRITE      ;//[nb_inst_issue]
  public    : SC_OUT(Tlsq_ptr_t        )   ** out_ISSUE_LOAD_QUEUE_PTR_WRITE       ;//[nb_inst_issue]
  public    : SC_OUT(Tcontrol_t        )   ** out_ISSUE_HAS_IMMEDIAT               ;//[nb_inst_issue]
  public    : SC_OUT(Tgeneral_data_t   )   ** out_ISSUE_IMMEDIAT                   ;//[nb_inst_issue]
  public    : SC_OUT(Tcontrol_t        )   ** out_ISSUE_READ_RA                    ;//[nb_inst_issue]
  public    : SC_OUT(Tgeneral_address_t)   ** out_ISSUE_NUM_REG_RA                 ;//[nb_inst_issue]
  public    : SC_OUT(Tcontrol_t        )   ** out_ISSUE_READ_RB                    ;//[nb_inst_issue]
  public    : SC_OUT(Tgeneral_address_t)   ** out_ISSUE_NUM_REG_RB                 ;//[nb_inst_issue]
  public    : SC_OUT(Tcontrol_t        )   ** out_ISSUE_READ_RC                    ;//[nb_inst_issue]
  public    : SC_OUT(Tspecial_address_t)   ** out_ISSUE_NUM_REG_RC                 ;//[nb_inst_issue]
  public    : SC_OUT(Tcontrol_t        )   ** out_ISSUE_WRITE_RD                   ;//[nb_inst_issue]
  public    : SC_OUT(Tgeneral_address_t)   ** out_ISSUE_NUM_REG_RD                 ;//[nb_inst_issue]
  public    : SC_OUT(Tcontrol_t        )   ** out_ISSUE_WRITE_RE                   ;//[nb_inst_issue]
  public    : SC_OUT(Tspecial_address_t)   ** out_ISSUE_NUM_REG_RE                 ;//[nb_inst_issue]

    // ~~~~~[ Interface "execute_loop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_EXECUTE_LOOP_VAL                 ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_OUT(Tcontrol_t        )  *** out_EXECUTE_LOOP_ACK                 ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tcontext_t        )  ***  in_EXECUTE_LOOP_FRONT_END_ID        ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tcontext_t        )  ***  in_EXECUTE_LOOP_CONTEXT_ID          ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tpacket_t         )  ***  in_EXECUTE_LOOP_PACKET_ID           ;//[nb_execute_loop][nb_inst_execute]
//public    : SC_IN (Ttype_t           )  ***  in_EXECUTE_LOOP_TYPE                ;//[nb_execute_loop][nb_inst_execute]
//public    : SC_IN (Toperation_t      )  ***  in_EXECUTE_LOOP_OPERATION           ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tspecial_data_t   )  ***  in_EXECUTE_LOOP_FLAGS               ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Texception_t      )  ***  in_EXECUTE_LOOP_EXCEPTION           ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tcontrol_t        )  ***  in_EXECUTE_LOOP_NO_SEQUENCE         ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Taddress_t        )  ***  in_EXECUTE_LOOP_ADDRESS             ;//[nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tgeneral_data_t   )  ***  in_EXECUTE_LOOP_DATA                ;//[nb_execute_loop][nb_inst_execute]

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_VAL                       ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_ACK                       ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_RD_USE                    ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_INSERT_RD_NUM_REG                ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_RE_USE                    ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_INSERT_RE_NUM_REG                ;//[nb_inst_insert]

//     // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//   public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_VAL                       ;//[nb_inst_retire]
//   public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_ACK                       ;//[nb_inst_retire]
//   public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_RD_OLD_USE                ;//[nb_inst_retire] 
//   public    : SC_OUT(Tgeneral_address_t)   ** out_RETIRE_RD_OLD_NUM_REG            ;//[nb_inst_retire]
//   public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_RD_NEW_USE                ;//[nb_inst_retire]
//   public    : SC_OUT(Tgeneral_address_t)   ** out_RETIRE_RD_NEW_NUM_REG            ;//[nb_inst_retire]
//   public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_RE_OLD_USE                ;//[nb_inst_retire] 
//   public    : SC_OUT(Tspecial_address_t)   ** out_RETIRE_RE_OLD_NUM_REG            ;//[nb_inst_retire]
//   public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_RE_NEW_USE                ;//[nb_inst_retire]
//   public    : SC_OUT(Tspecial_address_t)   ** out_RETIRE_RE_NEW_NUM_REG            ;//[nb_inst_retire]

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
  public    : SC_OUT(Tcontrol_t        )   ** out_BRANCH_COMPLETE_VAL              ;//[nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t        )   **  in_BRANCH_COMPLETE_ACK              ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontext_t        )   ** out_BRANCH_COMPLETE_FRONT_END_ID     ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontext_t        )   ** out_BRANCH_COMPLETE_CONTEXT_ID       ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tdepth_t          )   ** out_BRANCH_COMPLETE_DEPTH            ;//[nb_inst_branch_complete]
  public    : SC_OUT(Taddress_t        )   ** out_BRANCH_COMPLETE_ADDRESS          ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t        )   ** out_BRANCH_COMPLETE_NO_SEQUENCE      ;//[nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t        )   **  in_BRANCH_COMPLETE_MISS_PREDICTION  ;//[nb_inst_branch_complete]
                                                                                   
    // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )    * out_COMMIT_EVENT_VAL                 ;
  public    : SC_IN (Tcontrol_t        )    *  in_COMMIT_EVENT_ACK                 ;
  public    : SC_OUT(Tcontext_t        )    * out_COMMIT_EVENT_FRONT_END_ID        ;
  public    : SC_OUT(Tcontext_t        )    * out_COMMIT_EVENT_CONTEXT_ID          ;
  public    : SC_OUT(Tdepth_t          )    * out_COMMIT_EVENT_DEPTH               ;
  public    : SC_OUT(Tevent_type_t     )    * out_COMMIT_EVENT_TYPE                ;
  public    : SC_OUT(Tcontrol_t        )    * out_COMMIT_EVENT_IS_DELAY_SLOT       ;
  public    : SC_OUT(Taddress_t        )    * out_COMMIT_EVENT_ADDRESS             ;
  public    : SC_OUT(Tcontrol_t        )    * out_COMMIT_EVENT_ADDRESS_EPCR_VAL    ;
  public    : SC_OUT(Taddress_t        )    * out_COMMIT_EVENT_ADDRESS_EPCR        ;
  public    : SC_OUT(Tcontrol_t        )    * out_COMMIT_EVENT_ADDRESS_EEAR_VAL    ;
  public    : SC_OUT(Tgeneral_data_t   )    * out_COMMIT_EVENT_ADDRESS_EEAR        ;

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_EVENT_VAL                        ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t        )  *** out_EVENT_ACK                        ;//[nb_front_end][nb_context]
  public    : SC_IN (Taddress_t        )  ***  in_EVENT_ADDRESS                    ;//[nb_front_end][nb_context]
  public    : SC_IN (Taddress_t        )  ***  in_EVENT_ADDRESS_NEXT               ;//[nb_front_end][nb_context] 
  public    : SC_IN (Tcontrol_t        )  ***  in_EVENT_ADDRESS_NEXT_VAL           ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t        )  ***  in_EVENT_IS_DS_TAKE                 ;//[nb_front_end][nb_context]

    // ~~~~~[ Interface "spr_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_EVENT_VAL                    ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t        )  *** out_SPR_EVENT_ACK                    ;//[nb_front_end][nb_context]
  public    : SC_IN (Tspr_t            )  ***  in_SPR_EVENT_EPCR                   ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_EVENT_EEAR_WEN               ;//[nb_front_end][nb_context]
  public    : SC_IN (Tspr_t            )  ***  in_SPR_EVENT_EEAR                   ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_EVENT_SR_DSX                 ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_EVENT_SR_TO_ESR              ;//[nb_front_end][nb_context]
                                                                                   
    // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
  public    : SC_OUT(Tcounter_t        )  *** out_NB_INST_COMMIT_ALL               ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcounter_t        )  *** out_NB_INST_COMMIT_MEM               ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcounter_t        )  ***  in_NB_INST_DECOD_ALL                ;//[nb_front_end][nb_context]
                                                                                   
    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
  public    : SC_IN (Tdepth_t          )  ***  in_DEPTH_MIN                        ;//[nb_front_end][nb_context]
  public    : SC_IN (Tdepth_t          )  ***  in_DEPTH_MAX                        ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t        )  ***  in_DEPTH_FULL                       ;//[nb_front_end][nb_context]

    // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
  public    : SC_OUT(Tcontrol_t        )  *** out_SPR_SR_IEE                       ;//[nb_front_end][nb_context] - Interrupt Exception Enabled
  public    : SC_OUT(Tcontrol_t        )  *** out_SPR_SR_EPH                       ;//[nb_front_end][nb_context] - Exception Prefix High

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit          ::Rename_unit           ** _component_rename_unit          ;
  private   : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit          ::Commit_unit            * _component_commit_unit          ;
  private   : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue          ::Issue_queue            * _component_issue_queue          ;
  private   : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::reexecute_unit       ::Reexecute_unit         * _component_reexecute_unit       ;   
  private   : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::special_register_unit::Special_Register_unit  * _component_special_register_unit;
  private   : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::ooo_engine_glue      ::OOO_Engine_Glue        * _component_glue                 ;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (OOO_Engine);
#endif
  public  :          OOO_Engine              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else                                          
   std::string                                   name,
#endif                                         
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~OOO_Engine             (void);
                                               
  private : void        allocation                (
#ifdef STATISTICS
                                                   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
                                                   void
#endif
                                                   );
  private : void        deallocation              (void);
                                               
#ifdef SYSTEMC                                 
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif                                        
#endif                                         

#if VHDL                                       
  public  : void        vhdl                      (void);
#endif                                         

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
