/*
 * $Id: Debug.cpp 109 2009-02-16 20:28:31Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Common/include/Environment.h"

namespace morpheo {

static bool       debug_initialized;
debug_verbosity_t debug;
bool              debug_cycle_test;
double            debug_cycle_start;
double            debug_cycle_stop ;
double            debug_cycle_idle;

#undef  FUNCTION
#define FUNCTION "debug_init"
void debug_init (void)
{
#ifdef DEBUG
  if (not debug_initialized)
    {
      debug = DEBUG;
      debug_cycle_test = false;
//    debug_initialized = true;
    }
#endif
}

#undef  FUNCTION
#define FUNCTION "debug_init"
void debug_init (debug_verbosity_t level,
                 double            cycle_start,
                 double            cycle_stop ,
                 double            cycle_idle)
{
  if (not debug_initialized)
    {
#ifdef DEBUG
      // Take min
      debug = (level < DEBUG)?level:DEBUG;
     
# ifdef SYSTEMC
      debug_cycle_test = (cycle_stop > cycle_start) or (cycle_stop == -1);
      debug_cycle_start= cycle_start;
      debug_cycle_stop = cycle_stop;
# else
      debug_cycle_test = false;
# endif
#endif
      debug_cycle_idle = cycle_idle;

      debug_initialized = true;
    }
}

}; // end namespace morpheo
