/*
 * $Id: Parameters.cpp 109 2009-02-16 20:28:31Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::Parameters"
  Parameters::Parameters (uint32_t          nb_context              ,
			  uint32_t          nb_front_end            ,
			  uint32_t          nb_rename_unit          ,
			  uint32_t          size_queue              ,
			  uint32_t          nb_bank                 ,
			  uint32_t          size_packet             ,
			  uint32_t          size_general_data       ,
			  uint32_t          size_special_data       ,
			  uint32_t          size_general_register   ,
			  uint32_t          size_special_register   ,
			  uint32_t          size_store_queue_ptr    ,
			  uint32_t          size_load_queue_ptr     ,
			  uint32_t          nb_inst_issue           ,
			  uint32_t        * nb_inst_rename          ,
			  uint32_t          nb_inst_reexecute       ,
			  uint32_t          nb_rename_unit_select   ,
			  Tpriority_t       priority                ,
			  Tload_balancing_t load_balancing          ,
			  bool           ** table_routing           ,
			  bool           ** table_issue_type        ,
                          bool              is_toplevel             )
  {
    log_begin(Issue_queue,FUNCTION);

    _nb_context               = nb_context           ;
    _nb_front_end             = nb_front_end         ;
    _nb_rename_unit           = nb_rename_unit       ;
    _size_queue               = size_queue           ;
    _nb_bank                  = nb_bank              ;   
    _nb_inst_issue            = nb_inst_issue        ;
    _nb_inst_rename           = nb_inst_rename       ;
    _nb_inst_reexecute        = nb_inst_reexecute    ;
    _nb_rename_unit_select    = nb_rename_unit_select;
    _priority                 = priority             ;
    _load_balancing           = load_balancing       ;
    _table_routing            = table_routing        ;
    _table_issue_type         = table_issue_type     ;

    log_printf(TRACE,Issue_queue,FUNCTION,"  * table_routing [nb_rename_unit][nb_inst_issue]");
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
      for (uint32_t j=0; j<_nb_inst_issue; ++j)
        if (_table_routing [i][j])
          log_printf(TRACE,Issue_queue,FUNCTION,"    [%d][%d] -> true",i,j);
        
    log_printf(TRACE,Issue_queue,FUNCTION,"  * table_issue_type [nb_inst_issue][nb_type]");
    for (uint32_t i=0; i<_nb_inst_issue; ++i)
      for (uint32_t j=0; j<_nb_type; ++j)
        if (_table_issue_type [i][j])
          log_printf(TRACE,Issue_queue,FUNCTION,"    [%d][%d] -> true",i,j);
    
    _max_nb_inst_rename       = max<uint32_t>(_nb_inst_rename,_nb_rename_unit);
    _nb_bank_select_out       = _nb_bank/nb_inst_issue;

    _size_bank                = _size_queue / _nb_bank;
    
    test();

    if (is_toplevel)
      {
        _size_context_id          = log2(nb_context  );
        _size_front_end_id        = log2(nb_front_end);
        _size_rob_ptr             = size_packet          ;
        _size_general_data        = size_general_data    ;
        _size_special_data        = size_special_data    ;
        _size_general_register    = size_general_register;
        _size_special_register    = size_special_register;
        _size_store_queue_ptr     = size_store_queue_ptr ;
        _size_load_queue_ptr      = size_load_queue_ptr  ;
        
        _have_port_context_id     = (_size_context_id     > 0);
        _have_port_front_end_id   = (_size_front_end_id   > 0);
        _have_port_rob_ptr        = (_size_rob_ptr        > 0);
        _have_port_load_queue_ptr = (_size_load_queue_ptr > 0);
        
        copy();
      }

    log_end(Issue_queue,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Issue_queue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Issue_queue,FUNCTION);
//     test();
//     log_end(Issue_queue,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Issue_queue::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_begin(Issue_queue,FUNCTION);
    log_end(Issue_queue,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Issue_queue::copy"
  void Parameters::copy (void) 
  {
    log_begin(Issue_queue,FUNCTION);
    log_end(Issue_queue,FUNCTION);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
