#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_Prediction_unit_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_Prediction_unit_h

/*
 * $Id: Prediction_unit.h 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/include/Branch_Target_Buffer.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/include/Direction.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Return_Address_Stack.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Update_Prediction_Table.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/include/Prediction_unit_Glue.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {


  class Prediction_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_VAL                         ; //[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_ACK                         ; //[nb_context]
  public    : SC_IN (Taddress_t         )  **  in_PREDICT_PC_PREVIOUS                 ; //[nb_context]
  public    : SC_IN (Taddress_t         )  **  in_PREDICT_PC_CURRENT                  ; //[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_PC_CURRENT_IS_DS_TAKE       ; //[nb_context]
  public    : SC_OUT(Taddress_t         )  ** out_PREDICT_PC_NEXT                     ; //[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_PC_NEXT_IS_DS_TAKE          ; //[nb_context]
  public    : SC_OUT(Tcontrol_t         ) *** out_PREDICT_INSTRUCTION_ENABLE          ; //[nb_context][nb_instruction]
  public    : SC_OUT(Tinst_ifetch_ptr_t )  ** out_PREDICT_INST_IFETCH_PTR             ; //[nb_context]
  public    : SC_OUT(Tbranch_state_t    )  ** out_PREDICT_BRANCH_STATE                ; //[nb_context]
  public    : SC_OUT(Tprediction_ptr_t  )  ** out_PREDICT_BRANCH_UPDATE_PREDICTION_ID ; //[nb_context]

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	      
  public    : SC_IN (Tcontrol_t         ) ***  in_DECOD_VAL                           ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         ) *** out_DECOD_ACK                           ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tcontext_t         ) ***  in_DECOD_CONTEXT_ID                    ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tcontrol_t         ) ***  in_DECOD_MATCH_INST_IFETCH_PTR         ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tbranch_state_t    ) ***  in_DECOD_BRANCH_STATE                  ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tprediction_ptr_t  ) ***  in_DECOD_BRANCH_UPDATE_PREDICTION_ID   ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tbranch_condition_t) ***  in_DECOD_BRANCH_CONDITION              ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tcontrol_t         ) ***  in_DECOD_BRANCH_DIRECTION              ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Taddress_t         ) ***  in_DECOD_ADDRESS_SRC                   ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Taddress_t         ) ***  in_DECOD_ADDRESS_DEST                  ; //[nb_decod_unit][nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         ) *** out_DECOD_CAN_CONTINUE                  ; //[nb_decod_unit][nb_inst_decod]

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_COMPLETE_VAL                 ; //[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_COMPLETE_ACK                 ; //[nb_inst_branch_complete]
  public    : SC_IN (Tcontext_t         )  **  in_BRANCH_COMPLETE_CONTEXT_ID          ; //[nb_inst_branch_complete]
  public    : SC_IN (Tdepth_t           )  **  in_BRANCH_COMPLETE_DEPTH               ; //[nb_inst_branch_complete]
  public    : SC_IN (Taddress_t         )  **  in_BRANCH_COMPLETE_ADDRESS             ; //[nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_COMPLETE_NO_SEQUENCE         ; //[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_COMPLETE_MISS_PREDICTION     ; //[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_COMPLETE_TAKE                ; //[nb_inst_branch_complete]
  public    : SC_OUT(Taddress_t         )  ** out_BRANCH_COMPLETE_ADDRESS_SRC         ; //[nb_inst_branch_complete]
  public    : SC_OUT(Taddress_t         )  ** out_BRANCH_COMPLETE_ADDRESS_DEST        ; //[nb_inst_branch_complete]

    // ~~~~~[ Interface : "branch_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_EVENT_VAL                    ; //[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_EVENT_ACK                    ; //[nb_context]
//public    : SC_OUT(Tcontext_t         )  ** out_BRANCH_EVENT_CONTEXT_ID             ; //[nb_context]
  public    : SC_OUT(Tdepth_t           )  ** out_BRANCH_EVENT_DEPTH                  ; //[nb_context]
//public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_EVENT_MISS_PREDICTION        ; //[nb_context]
  public    : SC_OUT(Taddress_t         )  ** out_BRANCH_EVENT_ADDRESS_SRC            ; //[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_EVENT_ADDRESS_DEST_VAL       ; //[nb_context]
  public    : SC_OUT(Taddress_t         )  ** out_BRANCH_EVENT_ADDRESS_DEST           ; //[nb_context]

    // ~~~~~[ Interface : "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_EVENT_VAL                           ; //[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_EVENT_ACK                           ; //[nb_context]
  public    : SC_IN (Tevent_type_t      )  **  in_EVENT_TYPE                          ; //[nb_context]
  public    : SC_IN (Tdepth_t           )  **  in_EVENT_DEPTH                         ; //[nb_context]

    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	      
  public    : SC_OUT(Tcontrol_t         )  ** out_DEPTH_VAL                           ; //[nb_context]
  public    : SC_OUT(Tdepth_t           )  ** out_DEPTH_CURRENT                       ; //[nb_context]
  public    : SC_OUT(Tdepth_t           )  ** out_DEPTH_MIN                           ; //[nb_context]
  public    : SC_OUT(Tdepth_t           )  ** out_DEPTH_MAX                           ; //[nb_context]
  public    : SC_OUT(Tcontrol_t         )  ** out_DEPTH_FULL                          ; //[nb_context]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  public    : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer   ::Branch_Target_Buffer    * _component_btb;
  public    : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction              ::Direction	        * _component_dir;
  public    : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::return_address_stack   ::Return_Address_Stack    * _component_ras;
  public    : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::Update_Prediction_Table * _component_upt;
  public    : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::prediction_unit_glue   ::Prediction_unit_Glue    * _component_glue;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Prediction_unit);
#endif
  public  :          Prediction_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Prediction_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif					       
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
