/*
 * $Id: Parameters.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {


#undef  FUNCTION
#define FUNCTION "OOO_Engine::Parameters"
  Parameters::Parameters (uint32_t              nb_front_end                     ,
                          uint32_t            * nb_context                       ,//[nb_front_end]
                          uint32_t              nb_rename_unit                   ,
                          uint32_t              nb_execute_loop                  ,
                          uint32_t            * nb_inst_decod                    ,//[nb_front_end]
                          uint32_t            * nb_inst_insert                   ,//[nb_rename_unit]
                          uint32_t            * nb_inst_retire                   ,//[nb_rename_unit]
                          uint32_t              nb_inst_issue                    ,
                          uint32_t            * nb_inst_execute                  ,//[nb_execute_loop]
                          uint32_t              nb_inst_reexecute                ,
                          uint32_t              nb_inst_commit                   ,
                          uint32_t              nb_inst_branch_complete          ,
                          uint32_t           ** nb_branch_speculated             ,//[nb_front_end][nb_context]
                          uint32_t              size_nb_inst_decod               ,
                          uint32_t              nb_rename_unit_select            ,
                          uint32_t              nb_execute_loop_select           ,
                          uint32_t              size_general_data                ,
                          uint32_t              size_special_data                ,
                          uint32_t            * link_rename_unit_with_front_end  ,//[nb_front_end]
                          // Commit
                          uint32_t              size_re_order_buffer             ,
                          uint32_t              nb_re_order_buffer_bank          ,
                          Tpriority_t           commit_priority                  ,
                          Tload_balancing_t     commit_load_balancing            ,
                          // Issue
                          uint32_t              size_issue_queue                 ,
                          uint32_t              nb_issue_queue_bank              ,
                          Tpriority_t           issue_priority                   ,
                          Tload_balancing_t     issue_load_balancing             ,
                          bool               ** table_routing                    ,//[nb_rename_unit][nb_inst_issue]
                          bool               ** table_issue_type                 ,//[nb_inst_issue][nb_type]
                          // Reexecute
                          uint32_t              size_reexecute_queue             ,
                          Tpriority_t           reexecute_priority               ,
                          Tload_balancing_t     reexecute_load_balancing         ,
                          // Rename_unit
                          Tpriority_t         * rename_select_priority           ,//[nb_rename_unit]
                          Tload_balancing_t   * rename_select_load_balancing     ,//[nb_rename_unit]
                          uint32_t            * rename_select_nb_front_end_select,//[nb_rename_unit]
                          uint32_t            * nb_general_register              ,//[nb_rename_unit]
                          uint32_t            * nb_special_register              ,//[nb_rename_unit]
                          uint32_t            * nb_reg_free                      ,//[nb_rename_unit]
                          uint32_t            * nb_rename_unit_bank              ,//[nb_rename_unit]
                          uint32_t            * size_read_counter                ,//[nb_rename_unit]
                          uint32_t            * nb_load_store_queue              ,//[nb_rename_unit]
                          uint32_t           ** size_store_queue                 ,//[nb_rename_unit][nb_load_store_queue]
                          uint32_t           ** size_load_queue                  ,//[nb_rename_unit][nb_load_store_queue]
                          uint32_t           ** nb_inst_memory                   ,//[nb_rename_unit][nb_load_store_queue]
                          uint32_t           ** link_load_store_unit_with_thread ,//[nb_front_end][nb_context]
                          // SPR
                          bool              *** implement_group                  ,//[nb_front_end][nb_context][NB_GROUP]
                          // Others
                          uint32_t              nb_thread                          ,
                          uint32_t           ** translate_num_context_to_num_thread, //[nb_front_end][nb_context]

                          bool                  is_toplevel
                          )
  {
    log_begin(OOO_Engine,FUNCTION);

    _nb_front_end                      = nb_front_end                     ;
    _nb_context                        = nb_context                       ;
    _nb_rename_unit                    = nb_rename_unit                   ;
    _nb_execute_loop                   = nb_execute_loop                  ;
    _nb_inst_decod                     = nb_inst_decod                    ;
    _nb_inst_insert                    = nb_inst_insert                   ;
    _nb_inst_retire                    = nb_inst_retire                   ;
    _nb_inst_issue                     = nb_inst_issue                    ;
    _nb_inst_execute                   = nb_inst_execute                  ;
    _nb_inst_reexecute                 = nb_inst_reexecute                ;
    _nb_inst_commit                    = nb_inst_commit                   ;
    _nb_inst_branch_complete           = nb_inst_branch_complete          ;
    _nb_branch_speculated              = nb_branch_speculated             ;
    _nb_rename_unit_select             = nb_rename_unit_select            ;
    _nb_execute_loop_select            = nb_execute_loop_select           ;
//  _size_general_data                 = size_general_data                ;
//  _size_special_data                 = size_special_data                ;
    _link_rename_unit_with_front_end   = link_rename_unit_with_front_end  ;
    _size_re_order_buffer              = size_re_order_buffer             ;
    _nb_re_order_buffer_bank           = nb_re_order_buffer_bank          ;
    _commit_priority                   = commit_priority                  ;
    _commit_load_balancing             = commit_load_balancing            ;
    _size_issue_queue                  = size_issue_queue                 ;
    _nb_issue_queue_bank               = nb_issue_queue_bank              ;
    _issue_priority                    = issue_priority                   ;
    _issue_load_balancing              = issue_load_balancing             ;
    _table_routing                     = table_routing                    ;
    _table_issue_type                  = table_issue_type                 ;
    _size_reexecute_queue              = size_reexecute_queue             ;
    _reexecute_priority                = reexecute_priority               ;
    _reexecute_load_balancing          = reexecute_load_balancing         ;
    _rename_select_priority            = rename_select_priority           ;
    _rename_select_load_balancing      = rename_select_load_balancing     ;
    _rename_select_nb_front_end_select = rename_select_nb_front_end_select;
    _nb_general_register               = nb_general_register              ;
    _nb_special_register               = nb_special_register              ;
    _nb_reg_free                       = nb_reg_free                      ;
    _nb_rename_unit_bank               = nb_rename_unit_bank              ;
    _size_read_counter                 = size_read_counter                ;
    _nb_load_store_queue               = nb_load_store_queue              ;
    _size_store_queue                  = size_store_queue                 ;
    _size_load_queue                   = size_load_queue                  ;
    _nb_inst_memory                    = nb_inst_memory                   ;
    _link_load_store_unit_with_thread  = link_load_store_unit_with_thread ;
    _implement_group                   = implement_group                  ;

    _nb_thread                           = nb_thread                          ;
    _translate_num_context_to_num_thread = translate_num_context_to_num_thread;

    test();

    _link_front_end_with_rename_unit = new std::vector<uint32_t> [_nb_rename_unit];
    for (uint32_t i=0; i<_nb_front_end; i++)
      _link_front_end_with_rename_unit[_link_rename_unit_with_front_end[i]].push_back(i);

    _rename_unit_size_front_end_id                = new uint32_t    [_nb_rename_unit];
    _rename_unit_size_context_id                  = new uint32_t    [_nb_rename_unit];
    _rename_unit_nb_front_end                     = new uint32_t    [_nb_rename_unit];
    _rename_unit_nb_context                       = new uint32_t *  [_nb_rename_unit];
    _rename_unit_nb_inst_decod                    = new uint32_t *  [_nb_rename_unit];
    _rename_unit_link_load_store_unit_with_thread = new uint32_t ** [_nb_rename_unit];
    
    for (uint32_t i=0; i<_nb_rename_unit; i++)
      {
        uint32_t x = _link_front_end_with_rename_unit[i].size(); // number of linked front_end

        _rename_unit_nb_front_end                     [i] = x;
        _rename_unit_nb_context                       [i] = new uint32_t   [x];
        _rename_unit_nb_inst_decod                    [i] = new uint32_t   [x];
        _rename_unit_link_load_store_unit_with_thread [i] = new uint32_t * [x];

        // Scan front_end list
        std::vector<uint32_t>::iterator it=_link_front_end_with_rename_unit[i].begin();
        for (uint32_t j=0; j<x; j++)
          {
            _rename_unit_nb_context    [i][j] = _nb_context    [*it];
            _rename_unit_nb_inst_decod [i][j] = _nb_inst_decod [*it];
            _rename_unit_link_load_store_unit_with_thread [i][j] = new uint32_t [_nb_context [*it]];
            
            for (uint32_t k=0; k<_nb_context [*it]; k++)
              _rename_unit_link_load_store_unit_with_thread [i][j][k] = _link_load_store_unit_with_thread [*it][k];

            ++it;            
          }

        _rename_unit_size_front_end_id                [i] = log2(_rename_unit_nb_front_end [i]);
        _rename_unit_size_context_id                  [i] = log2(max<uint32_t>(_rename_unit_nb_context [i], _rename_unit_nb_front_end [i]));
      }

    for (uint32_t i=0; i<_nb_rename_unit; i++)
      {
        log_printf(TRACE,OOO_Engine,FUNCTION,"Rename_unit [%d]",i);
        log_printf(TRACE,OOO_Engine,FUNCTION," * front_end : %d",_rename_unit_nb_front_end[i]);
        
        for (uint32_t j=0; j<_rename_unit_nb_front_end[i]; j++)
          {
            log_printf(TRACE,OOO_Engine,FUNCTION,"   * [%d] nb_context : %d, nb_inst_decod : %d",j,_rename_unit_nb_context[i][j],_rename_unit_nb_inst_decod[i][j]);

            for (uint32_t k=0; k<_rename_unit_nb_context[i][j]; ++k)
              log_printf(TRACE,OOO_Engine,FUNCTION,"     * [%d][%d] link_lsq : %d",j,k,_rename_unit_link_load_store_unit_with_thread[i][j][k]);
          }
      }

    _max_nb_context                = max<uint32_t>(_nb_context,_nb_front_end);
    _max_branch_speculated         = max<uint32_t>(_nb_branch_speculated,_nb_front_end,_nb_context);
    _size_rename_id                = log2(_nb_rename_unit);
//  _size_max_depth                = log2(_max_branch_speculated);
    uint32_t size_front_end_id     = log2(_nb_front_end);
    uint32_t size_context_id       = log2(_max_nb_context);
    uint32_t size_packet_id        = log2(nb_re_order_buffer_bank)+log2(size_re_order_buffer/nb_re_order_buffer_bank);
    uint32_t size_general_register = log2(max<uint32_t>(_nb_general_register,_nb_rename_unit));
    uint32_t size_special_register = log2(max<uint32_t>(_nb_special_register,_nb_rename_unit));
    uint32_t size_store_queue_ptr  = log2(max<uint32_t>(_size_store_queue,_nb_rename_unit,_nb_load_store_queue));
    uint32_t size_load_queue_ptr   = log2(max<uint32_t>(_size_load_queue ,_nb_rename_unit,_nb_load_store_queue));

    _sum_inst_insert = 0;
    _sum_inst_retire = 0;
    for (uint32_t i=0; i<_nb_rename_unit; i++)
      {
        _sum_inst_insert += _nb_inst_insert [i];
        _sum_inst_retire += _nb_inst_retire [i];

        log_printf(TRACE,OOO_Engine,FUNCTION,"rename_unit [%d] - nb_inst_insert %d, nb_inst_retire %d", i,_nb_inst_insert [i],_nb_inst_retire [i]);
      }
    
    log_printf(TRACE,OOO_Engine,FUNCTION,"sum_inst_insert %d, sum_inst_retire %d",_sum_inst_insert,_sum_inst_retire);

//  _have_port_front_end_id            = _size_front_end_id   > 0;
//  _have_port_context_id              = _size_context_id     > 0;
//  _have_port_packet_id               = _size_packet_id      > 0;
    _have_port_rename_id               = _size_rename_id      > 0;
//  _have_port_load_queue_ptr          = _size_load_queue_ptr > 0;
//  _have_port_max_depth               = _size_max_depth      > 0;
//  _have_port_depth                   = _param_commit_unit->_have_port_depth;

    _param_rename_unit           = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::Parameters * [_nb_rename_unit];
    for (uint32_t i=0; i<_nb_rename_unit; i++)
      _param_rename_unit [i] = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::Parameters
      (
       _rename_unit_nb_front_end                      [i],
       _rename_unit_nb_context                        [i],
       _rename_unit_nb_inst_decod                     [i],
       _nb_inst_insert                                [i],
       _nb_inst_retire                                [i],
       _nb_load_store_queue                           [i],
       _size_store_queue                              [i],
       _size_load_queue                               [i],
       _nb_inst_memory                                [i],
       _rename_unit_link_load_store_unit_with_thread  [i],
       _rename_select_priority                        [i],
       _rename_select_load_balancing                  [i],
       _rename_select_nb_front_end_select             [i],
       _max_branch_speculated                            ,
        size_general_data                                ,
       _nb_general_register                           [i],
       _nb_special_register                           [i],
       _nb_reg_free                                   [i],
       _nb_rename_unit_bank                           [i],
       _size_read_counter                             [i] 
       );

    _param_commit_unit           = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Parameters  
      (
       _nb_front_end            ,
       _nb_context              ,
       _nb_rename_unit          ,
       _size_re_order_buffer    ,
       _nb_re_order_buffer_bank ,
       _nb_inst_insert          ,
       _nb_inst_retire          ,
       _nb_inst_commit          ,
       _nb_inst_reexecute       ,
       _nb_inst_branch_complete ,
       _nb_branch_speculated    ,
        size_nb_inst_decod      ,
        size_general_data       ,
        size_store_queue_ptr    ,
        size_load_queue_ptr     ,
        size_general_register   ,
        size_special_register   ,
       _commit_priority         ,
       _commit_load_balancing   ,
       _nb_rename_unit_select   ,
       _nb_thread                          ,
       _translate_num_context_to_num_thread
       );


    _param_issue_queue           = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Parameters  
      (_max_nb_context          ,
       _nb_front_end            ,
       _nb_rename_unit          ,
       _size_issue_queue        ,
       _nb_issue_queue_bank     ,
        size_packet_id          ,
        size_general_data       ,
        size_special_data       ,
        size_general_register   ,//+_size_rename_id
        size_special_register   ,//+_size_rename_id
        size_store_queue_ptr    ,
        size_load_queue_ptr     ,
       _nb_inst_issue           ,
       _nb_inst_insert          ,
       _nb_inst_reexecute       ,
       _nb_rename_unit_select   ,
       _issue_priority          ,
       _issue_load_balancing    ,
       _table_routing           ,
       _table_issue_type        
       );

    _param_reexecute_unit        = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::reexecute_unit::Parameters  
      ( size_context_id         ,
        size_front_end_id       ,
        size_packet_id          ,
       _size_reexecute_queue    ,
       _nb_execute_loop         ,
       _nb_inst_execute         ,
       _nb_inst_commit          ,
       _nb_inst_reexecute       ,
       _nb_execute_loop_select  ,
       _reexecute_priority      ,
       _reexecute_load_balancing,
        size_general_register   ,//+_size_rename_id
        size_special_register   ,//+_size_rename_id
        size_general_data       ,
        size_special_data       ,
        size_store_queue_ptr    ,
        size_load_queue_ptr     
       );   

    _param_special_register_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::special_register_unit::Parameters  
      (
       _nb_front_end          ,
       _nb_context            ,
       _nb_inst_reexecute     ,
       _implement_group       
       );

    _param_glue                  = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::ooo_engine_glue::Parameters  
      (_nb_front_end                     ,
       _nb_context                       ,
       _nb_rename_unit                   ,
       _nb_inst_decod                    ,
       _nb_inst_insert                   ,
       _nb_inst_retire                   ,
        size_general_data                ,
        size_special_data                ,
       _link_rename_unit_with_front_end  ,
       _link_front_end_with_rename_unit  ,
        size_packet_id                   ,
        size_general_register            ,
        size_special_register            ,
        size_store_queue_ptr             ,
        size_load_queue_ptr              
       );

    if (is_toplevel)
      {
        _size_front_end_id                 = size_front_end_id;
        _size_context_id                   = size_context_id  ;
        _size_depth                        = log2(_max_branch_speculated);
        _size_instruction_address          = size_general_data-2;
        _size_general_data                 = size_general_data;
        _size_special_data                 = size_special_data;
        _size_general_register             = size_general_register;
        _size_special_register             = size_special_register;
        _size_store_queue_ptr              = size_store_queue_ptr ;
        _size_load_queue_ptr               = size_load_queue_ptr  ;
        _size_rob_ptr                      = size_packet_id;
        _size_nb_inst_commit               = log2(size_re_order_buffer)+1;
        _size_nb_inst_decod                = size_nb_inst_decod;

        _have_port_front_end_id            = _size_front_end_id   > 0;
        _have_port_context_id              = _size_context_id     > 0;
        _have_port_rob_ptr                 = _size_rob_ptr        > 0;
        _have_port_load_queue_ptr          = _size_load_queue_ptr > 0;
        _have_port_depth                   = _size_depth          > 0;
        
        copy();
      }


    log_end(OOO_Engine,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "OOO_Engine::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(OOO_Engine,FUNCTION);
//     test();
//     log_end(OOO_Engine,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "OOO_Engine::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_begin(OOO_Engine,FUNCTION);

    for (uint32_t i=0; i<_nb_rename_unit; i++)
      {
        for (uint32_t j=0; j<_nb_front_end; j++)
          delete [] _rename_unit_link_load_store_unit_with_thread [i][j];
        
        delete [] _rename_unit_link_load_store_unit_with_thread [i];
        delete [] _rename_unit_nb_inst_decod                    [i];
        delete [] _rename_unit_nb_context                       [i];
      }
    
    delete [] _rename_unit_link_load_store_unit_with_thread;
    delete [] _rename_unit_nb_inst_decod                   ;
    delete [] _rename_unit_nb_context                      ;
    delete [] _rename_unit_nb_front_end                    ;
    delete [] _rename_unit_size_front_end_id               ;
    delete [] _rename_unit_size_context_id                 ;
    delete [] _link_front_end_with_rename_unit             ;

    delete [] _param_rename_unit          ;
    delete    _param_commit_unit          ;
    delete    _param_issue_queue          ;
    delete    _param_reexecute_unit       ;   
    delete    _param_special_register_unit;
    delete    _param_glue                 ;
    
    log_end(OOO_Engine,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "OOO_Engine::copy"
  void Parameters::copy (void) 
  {
    log_begin(OOO_Engine,FUNCTION);

    for (uint32_t i=0; i<_nb_rename_unit; i++)
    COPY(_param_rename_unit       [i]);
    COPY(_param_commit_unit          );
    COPY(_param_issue_queue          );
    COPY(_param_reexecute_unit       );   
    COPY(_param_special_register_unit);
    COPY(_param_glue                 );
    
    log_end(OOO_Engine,FUNCTION);
  };

}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
