/*
 * $Id: Register_translation_unit_Glue_allocation.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_translation_unit_Glue/include/Register_translation_unit_Glue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_translation_unit_glue {



#undef  FUNCTION
#define FUNCTION "Register_translation_unit_Glue::allocation"
  void Register_translation_unit_Glue::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Register_translation_unit_Glue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Register_translation_unit_Glue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_NO);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_NO);
    }
     
    // ~~~~~[ Interface : "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("insert",OUT, EAST, "insert's interface", _param->_nb_inst_insert);
      
      ALLOC1_SIGNAL_IN ( in_INSERT_RENAME_VAL        ,"rename_val"        ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_RENAME_ACK        ,"rename_ack"        ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_INSERT_VAL        ,"insert_val"        ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_INSERT_ACK        ,"insert_ack"        ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_RAT_INSERT_VAL    ,"rat_insert_val"    ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_RAT_RENAME_ACK    ,"rat_rename_ack"    ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_RAT_INSERT_ACK    ,"rat_insert_ack"    ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_FREE_LIST_VAL     ,"free_list_val"     ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_FREE_LIST_ACK     ,"free_list_ack"     ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_FREE_LIST_GPR_VAL ,"free_list_gpr_val" ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_FREE_LIST_SPR_VAL ,"free_list_spr_val" ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_STAT_LIST_VAL     ,"stat_list_val"     ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_STAT_LIST_ACK     ,"stat_list_ack"     ,Tcontrol_t,1);

      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_READ_RA           ,"DEPENDENCY_CHECKING_READ_RA"           ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RA_PHY    ,"DEPENDENCY_CHECKING_NUM_REG_RA_PHY"    ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_READ_RB           ,"DEPENDENCY_CHECKING_READ_RB"           ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RB_PHY    ,"DEPENDENCY_CHECKING_NUM_REG_RB_PHY"    ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_READ_RC           ,"DEPENDENCY_CHECKING_READ_RC"           ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RC_PHY    ,"DEPENDENCY_CHECKING_NUM_REG_RC_PHY"    ,Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_WRITE_RD          ,"DEPENDENCY_CHECKING_WRITE_RD"          ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_LOG    ,"DEPENDENCY_CHECKING_NUM_REG_RD_LOG"    ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_OLD,"DEPENDENCY_CHECKING_NUM_REG_RD_PHY_OLD",Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_NEW,"DEPENDENCY_CHECKING_NUM_REG_RD_PHY_NEW",Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_WRITE_RE          ,"DEPENDENCY_CHECKING_WRITE_RE"          ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_LOG    ,"DEPENDENCY_CHECKING_NUM_REG_RE_LOG"    ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_OLD,"DEPENDENCY_CHECKING_NUM_REG_RE_PHY_OLD",Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_IN ( in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_NEW,"DEPENDENCY_CHECKING_NUM_REG_RE_PHY_NEW",Tspecial_address_t,_param->_size_special_register      );

      ALLOC1_SIGNAL_OUT(out_INSERT_STAT_LIST_READ_RA                     ,"STAT_LIST_READ_RA"                     ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_STAT_LIST_NUM_REG_RA_PHY              ,"STAT_LIST_NUM_REG_RA_PHY"              ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_STAT_LIST_READ_RB                     ,"STAT_LIST_READ_RB"                     ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_STAT_LIST_NUM_REG_RB_PHY              ,"STAT_LIST_NUM_REG_RB_PHY"              ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_STAT_LIST_READ_RC                     ,"STAT_LIST_READ_RC"                     ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_STAT_LIST_NUM_REG_RC_PHY              ,"STAT_LIST_NUM_REG_RC_PHY"              ,Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_STAT_LIST_WRITE_RD                    ,"STAT_LIST_WRITE_RD"                    ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_STAT_LIST_NUM_REG_RD_PHY_NEW          ,"STAT_LIST_NUM_REG_RD_PHY_NEW"          ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_STAT_LIST_WRITE_RE                    ,"STAT_LIST_WRITE_RE"                    ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_STAT_LIST_NUM_REG_RE_PHY_NEW          ,"STAT_LIST_NUM_REG_RE_PHY_NEW"          ,Tspecial_address_t,_param->_size_special_register      );

      ALLOC1_SIGNAL_OUT(out_INSERT_RAT_WRITE_RD                          ,"RAT_WRITE_RD"                          ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_RAT_NUM_REG_RD_LOG                    ,"RAT_NUM_REG_RD_LOG"                    ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_INSERT_RAT_NUM_REG_RD_PHY_NEW                ,"RAT_NUM_REG_RD_PHY_NEW"                ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_RAT_WRITE_RE                          ,"RAT_WRITE_RE"                          ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_RAT_NUM_REG_RE_LOG                    ,"RAT_NUM_REG_RE_LOG"                    ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT(out_INSERT_RAT_NUM_REG_RE_PHY_NEW                ,"RAT_NUM_REG_RE_PHY_NEW"                ,Tspecial_address_t,_param->_size_special_register      );

      ALLOC1_SIGNAL_OUT(out_INSERT_READ_RA                               ,"READ_RA"                               ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RA_PHY                        ,"NUM_REG_RA_PHY"                        ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_READ_RB                               ,"READ_RB"                               ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RB_PHY                        ,"NUM_REG_RB_PHY"                        ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_READ_RC                               ,"READ_RC"                               ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RC_PHY                        ,"NUM_REG_RC_PHY"                        ,Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_WRITE_RD                              ,"WRITE_RD"                              ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RD_LOG                        ,"NUM_REG_RD_LOG"                        ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RD_PHY_OLD                    ,"NUM_REG_RD_PHY_OLD"                    ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RD_PHY_NEW                    ,"NUM_REG_RD_PHY_NEW"                    ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_WRITE_RE                              ,"WRITE_RE"                              ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RE_LOG                        ,"NUM_REG_RE_LOG"                        ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RE_PHY_OLD                    ,"NUM_REG_RE_PHY_OLD"                    ,Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RE_PHY_NEW                    ,"NUM_REG_RE_PHY_NEW"                    ,Tspecial_address_t,_param->_size_special_register      );
    }

    // ~~~~~[ Interface : "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("retire", IN, WEST, "retire's interface", _param->_nb_inst_retire);
      
      ALLOC1_SIGNAL_IN ( in_RETIRE_VAL          ,"val"          ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_RETIRE_ACK          ,"ack"          ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_RETIRE_RAT_VAL      ,"rat_val"      ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_RETIRE_RAT_ACK      ,"rat_ack"      ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_RETIRE_STAT_LIST_VAL,"stat_list_val",Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_RETIRE_STAT_LIST_ACK,"stat_list_ack",Tcontrol_t,1);
    }

#ifdef STATISTICS
    ALLOC1(internal_INSERT_RENAME_ACK, Tcontrol_t,_param->_nb_inst_insert);
#endif

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Register_translation_unit_Glue,FUNCTION,"End");
  };

}; // end namespace register_translation_unit_glue
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
