#ifdef SYSTEMC
/*
 * $Id: Simulation_test_end.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Simulation.h"

namespace morpheo              {
namespace behavioural          {

  bool simulation_test_end (void)
  {
    msg("##########[ cycle %d ]\n",static_cast<uint32_t>(sc_simulation_time()));

    // Test if a stop condition is activate
    if ((_simulation_nb_cycle == 0) and
        (_simulation_nb_instruction == 0)
        )
      return false;

    bool end_cycle;
    bool end_inst ;

    if (_simulation_nb_cycle != 0)
      end_cycle = (_simulation_nb_cycle <= sc_simulation_time());
    else
      end_cycle = true;

    if (_simulation_nb_instruction != 0)
      {
        end_inst = true;

        std::vector<double>::iterator it=_simulation_nb_instruction_commited.begin();
        
        // Scan all context and test if all can finish
        while (end_inst and it!=_simulation_nb_instruction_commited.end())
          {
            end_inst &= (_simulation_nb_instruction <= *it);
            it ++;
          }
      }
    else
      end_inst = true;
    
    return end_cycle and end_inst;
  }

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
