#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_issue_queue_Parameters_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_issue_queue_Parameters_h

/*
 * $Id: Parameters.h 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Types.h"
#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"
#include <list>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t          _nb_context              ;
  public : uint32_t          _nb_front_end            ;
  public : uint32_t          _nb_rename_unit          ;
  public : uint32_t          _size_queue              ;
  public : uint32_t          _nb_bank                 ;
//public : uint32_t          _size_packet             ;
//public : uint32_t          _size_general_data       ;
//public : uint32_t          _size_special_data       ;
//public : uint32_t          _size_general_register   ;
//public : uint32_t          _size_special_register   ;
//public : uint32_t          _size_store_queue_ptr    ;
//public : uint32_t          _size_load_queue_ptr     ;
  public : uint32_t          _nb_inst_issue           ;
  public : uint32_t        * _nb_inst_rename          ;//[nb_rename_unit]
  public : uint32_t          _nb_inst_reexecute       ;
  public : uint32_t          _nb_rename_unit_select   ;
  public : Tpriority_t       _priority                ;
  public : Tload_balancing_t _load_balancing          ;
  public : bool           ** _table_routing           ;//[nb_rename_unit][nb_inst_issue]
  public : bool           ** _table_issue_type        ;//[nb_inst_issue][nb_type]
  public : uint32_t          _size_reexecute_queue    ;

//public : uint32_t          _nb_bank_select_out      ;
  public : uint32_t          _max_nb_inst_rename      ;

//public : uint32_t          _size_context_id         ;
//public : uint32_t          _size_front_end_id       ;
  public : uint32_t          _size_bank               ;

//public : bool              _have_port_context_id    ;
//public : bool              _have_port_front_end_id  ;
//public : bool              _have_port_packet_id     ;
//public : bool              _have_port_load_queue_ptr;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t          nb_context              ,
			uint32_t          nb_front_end            ,
			uint32_t          nb_rename_unit          ,
			uint32_t          size_queue              ,
			uint32_t          nb_bank                 ,
			uint32_t          size_packet             ,
			uint32_t          size_general_data       ,
			uint32_t          size_special_data       ,
			uint32_t          size_general_register   ,
			uint32_t          size_special_register   ,
			uint32_t          size_store_queue_ptr    ,
			uint32_t          size_load_queue_ptr     ,
			uint32_t          nb_inst_issue           ,
			uint32_t        * nb_inst_rename          ,
			uint32_t          nb_inst_reexecute       ,
			uint32_t          nb_rename_unit_select   ,
			Tpriority_t       priority                ,
			Tload_balancing_t load_balancing          ,
			bool           ** table_routing           ,
			bool           ** table_issue_type        ,
                        bool              is_toplevel=false);

//   public : Parameters  (Parameters & param) ;
  public : ~Parameters (void);

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Parameters & x);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
