#ifndef morpheo_behavioural_core_Parameters_h
#define morpheo_behavioural_core_Parameters_h

/*
 * $Id: Parameters.h 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/include/Parameters.h"
#include "Behavioural/Core/Icache_Access/include/Parameters.h"
#include "Behavioural/Core/Dcache_Access/include/Parameters.h"
#include "Behavioural/Core/Core_Glue/include/Parameters.h"

#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"

#include <list>
#include <vector>

namespace morpheo {
namespace behavioural {

  typedef std::pair<uint32_t,uint32_t> pair_dual;

namespace core {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------

  // Common
//public : uint32_t                _size_general_data                             ;
//public : uint32_t                _size_special_data                             ;
  public : morpheo::behavioural::custom::custom_information_t (*_get_custom_information) (void);
    
  // Thread
  public : uint32_t                _nb_thread                                     ;
  public : uint32_t              * _size_ifetch_queue                             ;//[nb_thread]
  public : uint32_t              * _nb_inst_fetch                                 ;//[nb_thread]
  public : bool                 ** _implement_group                               ;//[nb_thread][NB_GROUP]
  public : uint32_t              * _ras_size_queue                                ;//[nb_thread]
  public : uint32_t              * _upt_size_queue                                ;//[nb_thread]
  public : uint32_t              * _ufpt_size_queue                               ;//[nb_thread]

  // Decod bloc
  public : uint32_t                _nb_decod_bloc                                 ;//
  public : uint32_t              * _size_decod_queue                              ;//[nb_decod_bloc]
  public : uint32_t              * _nb_inst_decod                                 ;//[nb_decod_bloc]
  public : uint32_t              * _nb_context_select                             ;//[nb_decod_bloc]
  public : Tpriority_t           * _context_select_priority                       ;//[nb_decod_bloc]
  public : Tload_balancing_t     * _context_select_load_balancing                 ;//[nb_decod_bloc]

  // Rename bloc
  public : uint32_t                _nb_rename_bloc                                ;
  public : uint32_t              * _nb_inst_insert                                ;//[nb_rename_bloc]
  public : uint32_t              * _nb_inst_retire                                ;//[nb_rename_bloc]
  public : Tpriority_t           * _rename_select_priority                        ;//[nb_rename_bloc]
  public : Tload_balancing_t     * _rename_select_load_balancing                  ;//[nb_rename_bloc]
  public : uint32_t              * _rename_select_nb_front_end_select             ;//[nb_rename_bloc]
  public : uint32_t              * _nb_general_register                           ;//[nb_rename_bloc]
  public : uint32_t              * _nb_special_register                           ;//[nb_rename_bloc]
  public : uint32_t              * _nb_reg_free                                   ;//[nb_rename_bloc]
  public : uint32_t              * _nb_rename_unit_bank                           ;//[nb_rename_bloc]
  public : uint32_t              * _size_read_counter                             ;//[nb_rename_bloc]

  // Read bloc
  public : uint32_t                _nb_read_bloc                                  ;//
  public : uint32_t              * _size_read_queue                               ;//[nb_read_bloc]
  public : uint32_t              * _size_reservation_station                      ;//[nb_read_bloc]
  public : uint32_t              * _nb_inst_retire_reservation_station            ;//[nb_read_bloc]

  // Write bloc
  public : uint32_t                _nb_write_bloc                                 ;//
  public : uint32_t              * _size_write_queue                              ;//[nb_write_bloc]
  public : uint32_t              * _size_execute_queue                            ;//[nb_write_bloc]
  public : uint32_t              * _nb_bypass_write                               ;//[nb_write_bloc]

  // Load_store_unit
  public : uint32_t                _nb_load_store_unit                            ;
  public : uint32_t              * _size_store_queue                              ;//[nb_load_store_unit]
  public : uint32_t              * _size_load_queue                               ;//[nb_load_store_unit]
  public : uint32_t              * _size_speculative_access_queue                 ;//[nb_load_store_unit]
  public : uint32_t              * _nb_port_check                                 ;//[nb_load_store_unit]
  public : multi_execute_loop::execute_loop::Tspeculative_load_t  
                                 * _speculative_load                              ;//[nb_load_store_unit]
  public : uint32_t              * _nb_bypass_memory                              ;//[nb_load_store_unit]
  public : uint32_t              * _nb_cache_port                                 ;//[nb_load_store_unit]
  public : uint32_t              * _nb_inst_memory                                ;//[nb_load_store_unit]

  // Functionnal_unit
  public : uint32_t                _nb_functionnal_unit                           ;
  public : uint32_t              * _nb_inst_functionnal_unit                      ;//[nb_functionnal_unit]
  public : multi_execute_loop::execute_loop::execute_timing_t
                               *** _timing                                        ;//[nb_functionnal_unit][nb_type][nb_operation]

  // Icache_Access
  public : uint32_t                _nb_icache_port                                ;
  public : Tpriority_t             _icache_port_priority                          ;
  public : Tload_balancing_t       _icache_port_load_balancing                    ;

  // Dcache_Access
  public : uint32_t                _nb_dcache_port                                ;
  public : Tpriority_t             _dcache_port_priority                          ;
  public : Tload_balancing_t       _dcache_port_load_balancing                    ;

  // Front_end
  public : uint32_t                _nb_front_end                                  ;
  public : uint32_t              * _nb_context                                    ;//[nb_front_end]
  public : uint32_t              * _nb_decod_unit                                 ;//[nb_front_end]
  public : uint32_t              * _nb_inst_branch_predict                        ;//[nb_front_end]
  public : uint32_t              * _nb_inst_branch_decod                          ;//[nb_front_end]
  public : uint32_t              * _nb_inst_branch_update                         ;//[nb_front_end]
  public : uint32_t              * _btb_size_queue                                ;//[nb_front_end]
  public : uint32_t              * _btb_associativity                             ;//[nb_front_end]
  public : uint32_t              * _btb_size_counter                              ;//[nb_front_end]
  public : Tvictim_t             * _btb_victim_scheme                             ;//[nb_front_end]
  public : Tpredictor_t          * _dir_predictor_scheme                          ;//[nb_front_end]
  public : bool                 ** _dir_have_bht                                  ;//[nb_front_end][3]
  public : uint32_t             ** _dir_bht_size_shifter                          ;//[nb_front_end][3]
  public : uint32_t             ** _dir_bht_nb_shifter                            ;//[nb_front_end][3]
  public : bool                 ** _dir_have_pht                                  ;//[nb_front_end][3]
  public : uint32_t             ** _dir_pht_size_counter                          ;//[nb_front_end][3]
  public : uint32_t             ** _dir_pht_nb_counter                            ;//[nb_front_end][3]
  public : uint32_t             ** _dir_pht_size_address_share                    ;//[nb_front_end][3]

  // OOO_Engine
  public : uint32_t                _nb_ooo_engine                                 ;
  public : uint32_t              * _nb_rename_unit                                ;//[nb_ooo_engine]
  public : uint32_t              * _nb_inst_issue                                 ;//[nb_ooo_engine]
  public : uint32_t              * _nb_inst_reexecute                             ;//[nb_ooo_engine]
  public : uint32_t              * _nb_inst_commit                                ;//[nb_ooo_engine]
  public : uint32_t              * _nb_inst_branch_complete                       ;//[nb_ooo_engine]
  public : uint32_t              * _nb_rename_unit_select                         ;//[nb_ooo_engine]
  public : uint32_t              * _nb_execute_loop_select                        ;//[nb_ooo_engine]
  public : uint32_t              * _size_re_order_buffer                          ;//[nb_ooo_engine]
  public : uint32_t              * _nb_re_order_buffer_bank                       ;//[nb_ooo_engine]
  public : Tpriority_t           * _commit_priority                               ;//[nb_ooo_engine]
  public : Tload_balancing_t     * _commit_load_balancing                         ;//[nb_ooo_engine]
  public : uint32_t              * _size_issue_queue                              ;//[nb_ooo_engine]
  public : uint32_t              * _nb_issue_queue_bank                           ;//[nb_ooo_engine]
  public : Tpriority_t           * _issue_priority                                ;//[nb_ooo_engine]
  public : Tload_balancing_t     * _issue_load_balancing                          ;//[nb_ooo_engine]
  public : uint32_t              * _size_reexecute_queue                          ;//[nb_ooo_engine]
  public : Tpriority_t           * _reexecute_priority                            ;//[nb_ooo_engine]
  public : Tload_balancing_t     * _reexecute_load_balancing                      ;//[nb_ooo_engine]

  //Execute_loop
  public : uint32_t                _nb_execute_loop                               ;
  public : uint32_t              * _nb_read_unit                                  ;//[nb_execute_loop]
  public : uint32_t              * _nb_execute_unit                               ;//[nb_execute_loop]
  public : uint32_t              * _nb_write_unit                                 ;//[nb_execute_loop]
  public : uint32_t              * _nb_gpr_bank                                   ;//[nb_execute_loop]
  public : uint32_t              * _nb_gpr_port_read_by_bank                      ;//[nb_execute_loop]
  public : uint32_t              * _nb_gpr_port_write_by_bank                     ;//[nb_execute_loop]
  public : uint32_t              * _nb_spr_bank                                   ;//[nb_execute_loop]
  public : uint32_t              * _nb_spr_port_read_by_bank                      ;//[nb_execute_loop]
  public : uint32_t              * _nb_spr_port_write_by_bank                     ;//[nb_execute_loop]
  public : Tpriority_t           * _execution_unit_to_write_unit_priority         ;//[nb_execute_loop]
  public : Tpriority_t           * _read_unit_to_execution_unit_priority          ;//[nb_execute_loop]

  // Link
  public : pair_dual             * _link_context_with_thread                      ;//[nb_thread]
  public : pair_dual             * _link_decod_unit_with_decod_bloc               ;//[nb_decod_bloc]
  public : pair_dual             * _link_rename_unit_with_rename_bloc             ;//[nb_rename_bloc]
  public : pair_dual             * _link_read_unit_with_read_bloc                 ;//[nb_read_bloc]
  public : pair_dual             * _link_write_unit_with_write_bloc               ;//[nb_write_bloc]
  public : pair_dual             * _link_execute_unit_with_functionnal_unit       ;//[nb_functionnal_unit]
  public : pair_dual             * _link_execute_unit_with_load_store_unit        ;//[nb_load_store_unit]
  public : uint32_t              * _link_decod_bloc_with_thread                   ;//[nb_thread]
  public : uint32_t              * _link_rename_bloc_with_front_end               ;//[nb_front_end]
  public : bool                *** _table_dispatch                                ;//[nb_ooo_engine][nb_inst_issue][nb_read_bloc]
  public : bool                 ** _link_read_bloc_and_load_store_unit            ;//[nb_read_bloc][nb_load_store_unit]
  public : bool                 ** _link_read_bloc_and_functionnal_unit           ;//[nb_read_bloc][nb_functionnal_unit]
  public : bool                 ** _link_write_bloc_and_load_store_unit           ;//[nb_write_bloc][nb_load_store_unit]
  public : bool                 ** _link_write_bloc_and_functionnal_unit          ;//[nb_write_bloc][nb_functionnal_unit]
  public : uint32_t              * _link_load_store_unit_with_thread              ;//[nb_thread]
  public : bool                 ** _link_thread_and_functionnal_unit              ;//[nb_thread][nb_functionnal_unit]
  public : uint32_t              * _link_icache_port_with_thread                  ;//[nb_thread]
  public : uint32_t             ** _link_dcache_port_with_load_store_unit         ;//[nb_load_store_unit][nb_cache_port]

  public : Tpriority_t             _dispatch_priority                             ;
  public : Tload_balancing_t       _dispatch_load_balancing                       ;

    //----------------------------------------------------------------------------
    //----------------------------------------------------------------------------
    //----------------------------------------------------------------------------

  // inverse link
  public : uint32_t             ** _link_thread_with_context                      ;//[nb_front_end][nb_context]
  public : uint32_t             ** _link_decod_bloc_with_decod_unit               ;//[nb_front_end][nb_decod_unit]
  public : uint32_t             ** _link_rename_bloc_with_rename_unit             ;//[nb_ooo_engine][nb_rename_unit]
  public : uint32_t             ** _link_read_bloc_with_read_unit                 ;//[nb_execute_loop][nb_read_unit]
  public : uint32_t             ** _link_write_bloc_with_write_unit               ;//[nb_execute_loop][nb_write_unit]
  public : uint32_t             ** _link_functionnal_unit_with_execute_unit       ;//[nb_execute_loop][nb_execute_unit]
  public : uint32_t             ** _link_load_store_unit_with_execute_unit        ;//[nb_execute_loop][nb_execute_unit]
//public : std::vector<uint32_t> * _list_thread_with_decod_bloc                   ;//[nb_decod_bloc]
//public : std::vector<uint32_t> * _list_front_end_with_rename_bloc               ;//[nb_rename_bloc]
  public : std::vector<uint32_t>** _list_functionnal_unit_with_rename_unit        ;//[nb_ooo_engine][nb_rename_unit]{nb_ooo_engine_nb_functionnal_unit}
  public : std::vector<uint32_t>** _list_load_store_unit_with_rename_unit         ;//[nb_ooo_engine][nb_rename_unit]{nb_ooo_engine_nb_load_store_unit}
  public : std::vector<uint32_t> * _list_functionnal_unit_with_execute_unit       ;//[nb_execute_loop]{execute_loop_nb_functionnal_unit}
  public : std::vector<uint32_t> * _list_load_store_unit_with_execute_unit        ;//[nb_execute_loop]{execute_loop_nb_load_store_unit}
  public : std::vector<uint32_t> * _list_ooo_engine_with_execute_loop             ;//[nb_execute_loop]{execute_loop_nb_ooo_engine}
  public : std::vector<uint32_t> * _list_front_end_with_execute_loop              ;//[nb_execute_loop]{execute_loop_nb_front_end}

  // translate for front_end
  public : uint32_t             ** _front_end_size_ifetch_queue                   ;//[nb_front_end][nb_context]
  public : uint32_t             ** _front_end_nb_inst_fetch                       ;//[nb_front_end][nb_context]
  public : bool                *** _front_end_instruction_implemeted              ;//[nb_front_end][nb_context][nb_instruction]
  public : uint32_t             ** _front_end_link_decod_unit_with_context        ;//[nb_front_end][nb_context]
  public : uint32_t              * _front_end_nb_inst_branch_complete             ;//[nb_front_end]
  public : uint32_t             ** _front_end_size_decod_queue                    ;//[nb_front_end][nb_decod_unit]
  public : uint32_t             ** _front_end_nb_inst_decod                       ;//[nb_front_end][nb_decod_unit]
  public : uint32_t              * _front_end_sum_inst_decod                      ;//[nb_front_end]
  public : uint32_t             ** _front_end_nb_context_select                   ;//[nb_front_end][nb_decod_unit]
  public : Tpriority_t          ** _front_end_context_select_priority             ;//[nb_front_end][nb_decod_unit]
  public : Tload_balancing_t    ** _front_end_context_select_load_balancing       ;//[nb_front_end][nb_decod_unit]
  public : uint32_t             ** _front_end_ras_size_queue                      ;//[nb_front_end][nb_context]
  public : uint32_t             ** _front_end_upt_size_queue                      ;//[nb_front_end][nb_context]
  public : uint32_t             ** _front_end_ufpt_size_queue                     ;//[nb_front_end][nb_context]

  // translate for ooo_engine
  public : uint32_t              * _ooo_engine_nb_front_end                       ;//[nb_ooo_engine]
  public : uint32_t             ** _ooo_engine_nb_context                         ;//[nb_ooo_engine][ooo_engine_nb_front_end]    
  public : uint32_t              * _ooo_engine_nb_execute_loop                    ;//[nb_ooo_engine]
  public : uint32_t             ** _ooo_engine_nb_inst_decod                      ;//[nb_ooo_engine][ooo_engine_nb_front_end]
  public : uint32_t             ** _ooo_engine_nb_inst_insert                     ;//[nb_ooo_engine][ooo_engine_nb_rename_unit]
  public : uint32_t              * _ooo_engine_nb_inst_insert_rob                 ;//[nb_ooo_engine][ooo_engine_nb_rename_unit]
  public : uint32_t             ** _ooo_engine_nb_inst_retire                     ;//[nb_ooo_engine][ooo_engine_nb_rename_unit]
  public : uint32_t             ** _ooo_engine_nb_inst_execute                    ;//[nb_ooo_engine][ooo_engine_nb_execute_loop]
  public : uint32_t            *** _ooo_engine_nb_branch_speculated               ;//[nb_ooo_engine][ooo_engine_nb_front_end][ooo_engine_nb_context]
  public : uint32_t             ** _ooo_engine_link_rename_unit_with_front_end    ;//[nb_ooo_engine][ooo_engine_nb_front_end]
  public : Tpriority_t          ** _ooo_engine_rename_select_priority             ;//[nb_ooo_engine][nb_rename_unit]
  public : Tload_balancing_t    ** _ooo_engine_rename_select_load_balancing       ;//[nb_ooo_engine][nb_rename_unit]
  public : uint32_t             ** _ooo_engine_rename_select_nb_front_end_select  ;//[nb_ooo_engine][nb_rename_unit]
  public : uint32_t             ** _ooo_engine_nb_general_register                ;//[nb_ooo_engine][nb_rename_unit]
  public : uint32_t             ** _ooo_engine_nb_special_register                ;//[nb_ooo_engine][nb_rename_unit]
  public : uint32_t             ** _ooo_engine_nb_reg_free                        ;//[nb_ooo_engine][nb_rename_unit]
  public : uint32_t             ** _ooo_engine_nb_rename_unit_bank                ;//[nb_ooo_engine][nb_rename_unit]
  public : uint32_t             ** _ooo_engine_size_read_counter                  ;//[nb_ooo_engine][nb_rename_unit]
  public : bool                *** _ooo_engine_table_routing                      ;//[nb_ooo_engine][nb_rename_unit][nb_inst_issue]
  public : bool                *** _ooo_engine_table_issue_type                   ;//[nb_ooo_engine][nb_inst_issue][nb_type]
  public : uint32_t             ** _ooo_engine_nb_load_store_unit                 ;//[nb_ooo_engine][nb_rename_unit]
  public : uint32_t            *** _ooo_engine_size_store_queue                   ;//[nb_ooo_engine][nb_rename_unit][ooo_engine_nb_load_store_unit]
  public : uint32_t            *** _ooo_engine_size_load_queue                    ;//[nb_ooo_engine][nb_rename_unit][ooo_engine_nb_load_store_unit]
  public : uint32_t            *** _ooo_engine_nb_inst_memory                     ;//[nb_ooo_engine][nb_rename_unit][ooo_engine_nb_load_store_unit]
  public : uint32_t            *** _ooo_engine_link_load_store_unit_with_context  ;//[nb_ooo_engine][ooo_engine_nb_front_end][nb_context]
  public : bool               **** _ooo_engine_implement_group                    ;//[nb_ooo_engine][ooo_engine_nb_front_end][nb_context][NB_GROUP]
  public : uint32_t            *** _ooo_engine_translate_num_context_to_num_thread;//[nb_ooo_engine][ooo_engine_nb_front_end][nb_context]

  // translate for execute_loop
  public : uint32_t              * _execute_loop_nb_functionnal_unit                       ;//[nb_execute_loop]
  public : uint32_t              * _execute_loop_nb_load_store_unit                        ;//[nb_execute_loop]
  public : uint32_t              * _execute_loop_nb_context                                ;//[nb_execute_loop]
  public : uint32_t              * _execute_loop_nb_front_end                              ;//[nb_execute_loop]
  public : uint32_t              * _execute_loop_nb_ooo_engine                             ;//[nb_execute_loop]
  public : uint32_t              * _execute_loop_nb_thread                                 ;//[nb_execute_loop]
  public : uint32_t              * _execute_loop_nb_packet                                 ;//[nb_execute_loop]
  public : uint32_t             ** _execute_loop_size_read_queue                           ;//[nb_execute_loop][nb_read_unit]
  public : uint32_t             ** _execute_loop_size_reservation_station                  ;//[nb_execute_loop][nb_read_unit]
  public : uint32_t             ** _execute_loop_nb_inst_retire                            ;//[nb_execute_loop][nb_read_unit]
  public : uint32_t             ** _execute_loop_nb_inst_functionnal_unit                  ;//[nb_execute_loop][execute_loop_nb_functionnal_unit]
  public : multi_execute_loop::execute_loop::execute_timing_t
                              **** _execute_loop_timing                                    ;//[nb_execute_loop][nb_execute_unit_nb_functionnal_unit][nb_type][nb_operation]
  public : uint32_t             ** _execute_loop_size_store_queue                          ;//[nb_execute_loop][execute_loop_nb_load_store_unit]
  public : uint32_t             ** _execute_loop_size_load_queue                           ;//[nb_execute_loop][execute_loop_nb_load_store_unit]
  public : uint32_t             ** _execute_loop_size_speculative_access_queue             ;//[nb_execute_loop][execute_loop_nb_load_store_unit]
  public : uint32_t             ** _execute_loop_nb_port_check                             ;//[nb_execute_loop][execute_loop_nb_load_store_unit]
  public : multi_execute_loop::execute_loop::Tspeculative_load_t
                                ** _execute_loop_speculative_load                          ;//[nb_execute_loop][execute_loop_nb_load_store_unit]
  public : uint32_t             ** _execute_loop_nb_bypass_memory                          ;//[nb_execute_loop][execute_loop_nb_load_store_unit]
  public : uint32_t             ** _execute_loop_nb_cache_port                             ;//[nb_execute_loop][execute_loop_nb_load_store_unit]
  public : uint32_t             ** _execute_loop_nb_inst_memory                            ;//[nb_execute_loop][execute_loop_nb_load_store_unit]
  public : uint32_t             ** _execute_loop_size_write_queue                          ;//[nb_execute_loop][nb_write_unit]
  public : uint32_t             ** _execute_loop_size_execute_queue                        ;//[nb_execute_loop][nb_write_unit]
  public : uint32_t             ** _execute_loop_nb_bypass_write                           ;//[nb_execute_loop][nb_write_unit]
  public : uint32_t             ** _execute_loop_nb_general_register                       ;//[nb_execute_loop][execute_loop_nb_ooo_engine]
  public : uint32_t             ** _execute_loop_nb_special_register                       ;//[nb_execute_loop][execute_loop_nb_ooo_engine]
  public : uint32_t             ** _execute_loop_nb_inst_insert_rob                        ;//[nb_execute_loop][execute_loop_nb_ooo_engine]
  public : uint32_t             ** _execute_loop_nb_inst_retire_rob                        ;//[nb_execute_loop][execute_loop_nb_ooo_engine]
  public : uint32_t             ** _execute_loop_nb_execute_unit_port                      ;//[nb_execute_loop][nb_execute_unit]
  public : bool               **** _execute_loop_execution_unit_to_write_unit_table_routing;//[nb_execute_loop][nb_execute_unit][execute_loop_nb_execute_unit_port][nb_write_unit]
  public : bool                *** _execute_loop_execution_unit_to_write_unit_table_thread ;//[nb_execute_loop][nb_write_unit][execute_loop_nb_thread]
  public : bool               **** _execute_loop_read_unit_to_execution_unit_table_routing ;//[nb_execute_loop][nb_read_unit][nb_execute_unit][execute_loop_nb_execute_unit_port]
  public : bool                *** _execute_loop_read_unit_to_execution_unit_table_thread  ;//[nb_execute_loop][nb_execute_unit][execute_loop_nb_thread]
  public : bool                 ** _execute_loop_is_load_store_unit                        ;//[nb_execute_loop][nb_execute_unit]
  public : uint32_t             ** _execute_loop_translate_num_execute_unit                ;//[nb_execute_loop][nb_execute_unit]

  // translate for icache_access
  public : uint32_t             ** _icache_access_table_routing                   ;//[nb_front_end][nb_context]
  public : uint32_t              * _icache_nb_instruction                         ;//[nb_icache_port]
  public : uint32_t             ** _icache_access_size_packet_id                  ;//[nb_front_end][nb_context]

  public : uint32_t                _size_icache_thread_id                         ;
  public : uint32_t                _size_icache_packet_id                         ;
  public : uint32_t                _size_icache_address                           ;

  public : bool                    _have_port_icache_thread_id                    ;
  public : bool                    _have_port_icache_packet_id                    ;

  // translate for dcache_access
  public : uint32_t             ** _dcache_access_size_thread_id                  ;//[nb_execute_loop][execute_loop_nb_load_store_unit]
  public : uint32_t             ** _dcache_access_size_packet_id                  ;//[nb_execute_loop][execute_loop_nb_load_store_unit]
  public : uint32_t            *** _dcache_access_table_routing                   ;//[nb_execute_loop][execute_loop_nb_load_store_unit][execute_loop_nb_cache_port]
  public : uint32_t              * _dcache_access_nb_context                         ;//[nb_execute_loop]
  public : uint32_t            *** _dcache_access_translate_load_store_unit_to_thread;//[nb_execute_loop][execute_loop_nb_load_store_unit][dcache_access_nb_context]


  public : uint32_t                _size_dcache_thread_id                         ;
  public : uint32_t                _size_dcache_packet_id                         ;
  public : uint32_t                _size_dcache_address                           ;
  public : uint32_t                _size_dcache_data                              ;

  public : bool                    _have_port_dcache_thread_id                    ;
  public : bool                    _have_port_dcache_packet_id                    ;


  public : bool               **** _network_table_dispatch                        ;//[nb_ooo_engine][nb_inst_issue][nb_execute_loop][nb_read_unit]


  // Translate
  public : uint32_t             ** _translate_ooo_engine_num_front_end            ;//[nb_ooo_engine][ooo_engine_nb_front_end]
  public : uint32_t             ** _translate_ooo_engine_num_execute_loop         ;//[nb_ooo_engine][ooo_engine_nb_execute_loop]
//public : uint32_t            *** _translate_rename_unit_num_load_store_unit     ;//[nb_ooo_engine][nb_rename_unit][ooo_engine_nb_load_store_unit]
  public : uint32_t             ** _translate_execute_loop_num_ooo_engine         ;//[nb_execute_loop][execute_loop_nb_ooo_engine]

  public : core::multi_front_end::front_end::      Parameters ** _param_front_end;
  public : core::multi_ooo_engine::ooo_engine::    Parameters ** _param_ooo_engine;
  public : core::multi_execute_loop::execute_loop::Parameters ** _param_execute_loop;
  public : core::icache_access::                   Parameters *  _param_icache_access;
  public : core::dcache_access::                   Parameters *  _param_dcache_access;
  public : core::core_glue::                       Parameters *  _param_glue;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (
  // Common
  uint32_t                size_general_data                             ,
  uint32_t                size_special_data                             ,
  morpheo::behavioural::custom::custom_information_t (*get_custom_information) (void),
    
  // Thread
  uint32_t                nb_thread                                     ,
  uint32_t              * size_ifetch_queue                             ,//[nb_thread]
  uint32_t              * nb_inst_fetch                                 ,//[nb_thread]
  bool                 ** implement_group                               ,//[nb_thread][NB_GROUP]
  uint32_t              * ras_size_queue                                ,//[nb_thread]
  uint32_t              * upt_size_queue                                ,//[nb_thread]
  uint32_t              * ufpt_size_queue                               ,//[nb_thread]

  // Decod bloc
  uint32_t                nb_decod_bloc                                 ,
  uint32_t              * size_decod_queue                              ,//[nb_decod_bloc]
  uint32_t              * nb_inst_decod                                 ,//[nb_decod_bloc]
  uint32_t              * nb_context_select                             ,//[nb_decod_bloc]
  Tpriority_t           * context_select_priority                       ,//[nb_decod_bloc]
  Tload_balancing_t     * context_select_load_balancing                 ,//[nb_decod_bloc]

  // Rename bloc
  uint32_t                nb_rename_bloc                                ,
  uint32_t              * nb_inst_insert                                ,//[nb_rename_bloc]
  uint32_t              * nb_inst_retire                                ,//[nb_rename_bloc]
  Tpriority_t           * rename_select_priority                        ,//[nb_rename_bloc]
  Tload_balancing_t     * rename_select_load_balancing                  ,//[nb_rename_bloc]
  uint32_t              * rename_select_nb_front_end_select             ,//[nb_rename_bloc]
  uint32_t              * nb_general_register                           ,//[nb_rename_bloc]
  uint32_t              * nb_special_register                           ,//[nb_rename_bloc]
  uint32_t              * nb_reg_free                                   ,//[nb_rename_bloc]
  uint32_t              * nb_rename_unit_bank                           ,//[nb_rename_bloc]
  uint32_t              * size_read_counter                             ,//[nb_rename_bloc]

  // Read bloc
  uint32_t                nb_read_bloc                                  ,//
  uint32_t              * size_read_queue                               ,//[nb_read_bloc]
  uint32_t              * size_reservation_station                      ,//[nb_read_bloc]
  uint32_t              * nb_inst_retire_reservation_station            ,//[nb_read_bloc]

  // Write bloc
  uint32_t                nb_write_bloc                                 ,//
  uint32_t              * size_write_queue                              ,//[nb_write_bloc]
  uint32_t              * size_execute_queue                            ,//[nb_write_bloc]
  uint32_t              * nb_bypass_write                               ,//[nb_write_bloc]

  // Load_store_unit
  uint32_t                nb_load_store_unit                            ,
  uint32_t              * size_store_queue                              ,//[nb_load_store_unit]
  uint32_t              * size_load_queue                               ,//[nb_load_store_unit]
  uint32_t              * size_speculative_access_queue                 ,//[nb_load_store_unit]
  uint32_t              * nb_port_check                                 ,//[nb_load_store_unit]
  multi_execute_loop::execute_loop::Tspeculative_load_t  
                        * speculative_load                              ,//[nb_load_store_unit]
  uint32_t              * nb_bypass_memory                              ,//[nb_load_store_unit]
  uint32_t              * nb_cache_port                                 ,//[nb_load_store_unit]
  uint32_t              * nb_inst_memory                                ,//[nb_load_store_unit]

  // Functionnal_unit
  uint32_t                nb_functionnal_unit                           ,
  uint32_t              * nb_inst_functionnal_unit                      ,//[nb_functionnal_unit]
  multi_execute_loop::execute_loop::execute_timing_t
                      *** timing                                        ,//[nb_functionnal_unit][nb_type][nb_operation]

  // Icache_Access
  uint32_t                nb_icache_port                                ,
  Tpriority_t             icache_port_priority                          ,
  Tload_balancing_t       icache_port_load_balancing                    ,

  // Dcache_Access
  uint32_t                nb_dcache_port                                ,
  Tpriority_t             dcache_port_priority                          ,
  Tload_balancing_t       dcache_port_load_balancing                    ,

  // Front_end
  uint32_t                nb_front_end                                  ,
  uint32_t              * nb_context                                    ,//[nb_front_end]
  uint32_t              * nb_decod_unit                                 ,//[nb_front_end]
  uint32_t              * nb_inst_branch_predict                        ,//[nb_front_end]
  uint32_t              * nb_inst_branch_decod                          ,//[nb_front_end]
  uint32_t              * nb_inst_branch_update                         ,//[nb_front_end]
  uint32_t              * btb_size_queue                                ,//[nb_front_end]
  uint32_t              * btb_associativity                             ,//[nb_front_end]
  uint32_t              * btb_size_counter                              ,//[nb_front_end]
  Tvictim_t             * btb_victim_scheme                             ,//[nb_front_end]
  Tpredictor_t          * dir_predictor_scheme                          ,//[nb_front_end]
  bool                 ** dir_have_bht                                  ,//[nb_front_end][3]
  uint32_t             ** dir_bht_size_shifter                          ,//[nb_front_end][3]
  uint32_t             ** dir_bht_nb_shifter                            ,//[nb_front_end][3]
  bool                 ** dir_have_pht                                  ,//[nb_front_end][3]
  uint32_t             ** dir_pht_size_counter                          ,//[nb_front_end][3]
  uint32_t             ** dir_pht_nb_counter                            ,//[nb_front_end][3]
  uint32_t             ** dir_pht_size_address_share                    ,//[nb_front_end][3]

  // OOO_Engine
  uint32_t                nb_ooo_engine                                 ,
  uint32_t              * nb_rename_unit                                ,//[nb_ooo_engine]
  uint32_t              * nb_inst_issue                                 ,//[nb_ooo_engine]
  uint32_t              * nb_inst_reexecute                             ,//[nb_ooo_engine]
  uint32_t              * nb_inst_commit                                ,//[nb_ooo_engine]
  uint32_t              * nb_inst_branch_complete                       ,//[nb_ooo_engine]
  uint32_t              * nb_rename_unit_select                         ,//[nb_ooo_engine]
  uint32_t              * nb_execute_loop_select                        ,//[nb_ooo_engine]
  uint32_t              * size_re_order_buffer                          ,//[nb_ooo_engine]
  uint32_t              * nb_re_order_buffer_bank                       ,//[nb_ooo_engine]
  Tpriority_t           * commit_priority                               ,//[nb_ooo_engine]
  Tload_balancing_t     * commit_load_balancing                         ,//[nb_ooo_engine]
  uint32_t              * size_issue_queue                              ,//[nb_ooo_engine]
  uint32_t              * nb_issue_queue_bank                           ,//[nb_ooo_engine]
  Tpriority_t           * issue_priority                                ,//[nb_ooo_engine]
  Tload_balancing_t     * issue_load_balancing                          ,//[nb_ooo_engine]
  uint32_t              * size_reexecute_queue                          ,//[nb_ooo_engine]
  Tpriority_t           * reexecute_priority                            ,//[nb_ooo_engine]
  Tload_balancing_t     * reexecute_load_balancing                      ,//[nb_ooo_engine]

  //Execute_loop
  uint32_t                nb_execute_loop                               ,
  uint32_t              * nb_read_unit                                  ,//[nb_execute_loop]
  uint32_t              * nb_execute_unit                               ,//[nb_execute_loop]
  uint32_t              * nb_write_unit                                 ,//[nb_execute_loop]
  uint32_t              * nb_gpr_bank                                   ,//[nb_execute_loop]
  uint32_t              * nb_gpr_port_read_by_bank                      ,//[nb_execute_loop]
  uint32_t              * nb_gpr_port_write_by_bank                     ,//[nb_execute_loop]
  uint32_t              * nb_spr_bank                                   ,//[nb_execute_loop]
  uint32_t              * nb_spr_port_read_by_bank                      ,//[nb_execute_loop]
  uint32_t              * nb_spr_port_write_by_bank                     ,//[nb_execute_loop]
  Tpriority_t           * execution_unit_to_write_unit_priority         ,//[nb_execute_loop]
  Tpriority_t           * read_unit_to_execution_unit_priority          ,//[nb_execute_loop]

  // Link
  pair_dual             * link_context_with_thread                      ,//[nb_thread]
  pair_dual             * link_decod_unit_with_decod_bloc               ,//[nb_decod_bloc]
  pair_dual             * link_rename_unit_with_rename_bloc             ,//[nb_rename_bloc]
  pair_dual             * link_read_unit_with_read_bloc                 ,//[nb_read_bloc]
  pair_dual             * link_write_unit_with_write_bloc               ,//[nb_write_bloc]
  pair_dual             * link_execute_unit_with_functionnal_unit       ,//[nb_functionnal_unit]
  pair_dual             * link_execute_unit_with_load_store_unit        ,//[nb_load_store_unit]
  uint32_t              * link_decod_bloc_with_thread                   ,//[nb_thread]
  uint32_t              * link_rename_bloc_with_front_end               ,//[nb_front_end]
  bool                *** table_dispatch                                ,//[nb_ooo_engine][nb_inst_issue][nb_read_bloc]
  bool                 ** link_read_bloc_and_load_store_unit            ,//[nb_read_bloc][nb_load_store_unit]
  bool                 ** link_read_bloc_and_functionnal_unit           ,//[nb_read_bloc][nb_functionnal_unit]
  bool                 ** link_write_bloc_and_load_store_unit           ,//[nb_write_bloc][nb_load_store_unit]
  bool                 ** link_write_bloc_and_functionnal_unit          ,//[nb_write_bloc][nb_functionnal_unit]
  uint32_t              * link_load_store_unit_with_thread              ,//[nb_thread]
  bool                 ** link_thread_and_functionnal_unit              ,//[nb_thread][nb_functionnal_unit]
  uint32_t              * link_icache_port_with_thread                  ,//[nb_thread]
  uint32_t             ** link_dcache_port_with_load_store_unit         ,//[nb_load_store_unit][nb_cache_port]

  Tpriority_t             dispatch_priority                             ,
  Tload_balancing_t       dispatch_load_balancing                       
                        );
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  private:        Tcontext_t      execute_loop_get_num_thread (uint32_t num_execute_loop,
                                                               uint32_t num_thread);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
                                            morpheo::behavioural::core::Parameters & x);
  };

}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
