#ifndef morpheo_behavioural_configuration_Parameters_h
#define morpheo_behavioural_configuration_Parameters_h

/*
 * $Id: Parameters.h 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

  class Parameters
  {
    // -----[ parameters ]------------------------------------------------
    // Common
  public : uint32_t                _size_general_data                             ;
  public : uint32_t                _size_special_data                             ;
  public : morpheo::behavioural::custom::custom_information_t (*_get_custom_information) (void);

    // Thread
  public : uint32_t                _nb_thread                                     ;
  public : uint32_t              * _size_ifetch_queue                             ;//[nb_thread]
  public : uint32_t              * _nb_inst_fetch                                 ;//[nb_thread]
  public : bool                 ** _implement_group                               ;//[nb_thread][NB_GROUP]
  public : uint32_t              * _ras_size_queue                                ;//[nb_thread]
  public : uint32_t              * _upt_size_queue                                ;//[nb_thread]
  public : uint32_t              * _ufpt_size_queue                               ;//[nb_thread]
 
    // Decod bloc
  public : uint32_t                _nb_decod_bloc                                 ;
  public : uint32_t              * _size_decod_queue                              ;//[nb_decod_bloc]
  public : morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t
                                 * _decod_queue_scheme                            ;//[nb_decod_bloc]
  public : uint32_t              * _nb_inst_decod                                 ;//[nb_decod_bloc]
  public : uint32_t              * _nb_context_select                             ;//[nb_decod_bloc]
  public : Tpriority_t           * _context_select_priority                       ;//[nb_decod_bloc]
  public : Tload_balancing_t     * _context_select_load_balancing                 ;//[nb_decod_bloc]
 
    // Rename bloc
  public : uint32_t                _nb_rename_bloc                                ;
  public : uint32_t              * _nb_inst_insert                                ;//[nb_rename_bloc]
  public : uint32_t              * _nb_inst_retire                                ;//[nb_rename_bloc]
  public : Tpriority_t           * _rename_select_priority                        ;//[nb_rename_bloc]
  public : Tload_balancing_t     * _rename_select_load_balancing                  ;//[nb_rename_bloc]
  public : uint32_t              * _rename_select_nb_front_end_select             ;//[nb_rename_bloc]
  public : uint32_t              * _nb_general_register                           ;//[nb_rename_bloc]
  public : uint32_t              * _nb_special_register                           ;//[nb_rename_bloc]
  public : uint32_t              * _nb_reg_free                                   ;//[nb_rename_bloc]
  public : uint32_t              * _nb_rename_unit_bank                           ;//[nb_rename_bloc]
  public : uint32_t              * _size_read_counter                             ;//[nb_rename_bloc]
 
    // Read bloc
  public : uint32_t                _nb_read_bloc                                  ;//
  public : uint32_t              * _size_read_queue                               ;//[nb_read_bloc]
  public : uint32_t              * _size_reservation_station                      ;//[nb_read_bloc]
  public : uint32_t              * _nb_inst_retire_reservation_station            ;//[nb_read_bloc]
 
    // Write bloc
  public : uint32_t                _nb_write_bloc                                 ;//
  public : uint32_t              * _size_write_queue                              ;//[nb_write_bloc]
  public : uint32_t              * _size_execute_queue                            ;//[nb_write_bloc]
  public : uint32_t              * _nb_bypass_write                               ;//[nb_write_bloc]
 
    // Load_store_unit
  public : uint32_t                _nb_load_store_unit                            ;
  public : uint32_t              * _size_store_queue                              ;//[nb_load_store_unit]
  public : uint32_t              * _size_load_queue                               ;//[nb_load_store_unit]
  public : uint32_t              * _size_speculative_access_queue                 ;//[nb_load_store_unit]
  public : uint32_t              * _nb_port_check                                 ;//[nb_load_store_unit]
  public : core::multi_execute_loop::execute_loop::Tspeculative_load_t  
                                 * _speculative_load                              ;//[nb_load_store_unit]
  public : uint32_t              * _nb_bypass_memory                              ;//[nb_load_store_unit]
  public : uint32_t              * _nb_cache_port                                 ;//[nb_load_store_unit]
  public : uint32_t              * _nb_inst_memory                                ;//[nb_load_store_unit]
 
    // Functionnal_unit
  public : uint32_t                _nb_functionnal_unit                           ;
  public : uint32_t              * _nb_inst_functionnal_unit                      ;//[nb_functionnal_unit]
  public : core::multi_execute_loop::execute_loop::execute_timing_t
                                *** _timing                                       ;//[nb_functionnal_unit][nb_type][nb_operation]
 
    // Icache_port
  public : uint32_t                _nb_icache_port                                ;
  public : Tpriority_t             _icache_port_priority                          ;
  public : Tload_balancing_t       _icache_port_load_balancing                    ;
 
    // Dcache_port
  public : uint32_t                _nb_dcache_port                                ;
  public : Tpriority_t             _dcache_port_priority                          ;
  public : Tload_balancing_t       _dcache_port_load_balancing                    ;
 
    // Front_end
  public : uint32_t                _nb_front_end                                  ;
  public : uint32_t              * _nb_context                                    ;//[nb_front_end]
  public : uint32_t              * _nb_decod_unit                                 ;//[nb_front_end]
  public : uint32_t              * _nb_inst_branch_predict                        ;//[nb_front_end]
  public : uint32_t              * _nb_inst_branch_decod                          ;//[nb_front_end]
  public : uint32_t              * _nb_inst_branch_update                         ;//[nb_front_end]
  public : uint32_t              * _btb_size_queue                                ;//[nb_front_end]
  public : uint32_t              * _btb_associativity                             ;//[nb_front_end]
  public : uint32_t              * _btb_size_counter                              ;//[nb_front_end]
  public : Tvictim_t             * _btb_victim_scheme                             ;//[nb_front_end]
  public : Tpredictor_t          * _dir_predictor_scheme                          ;//[nb_front_end]
  public : bool                 ** _dir_have_bht                                  ;//[nb_front_end][3]
  public : uint32_t             ** _dir_bht_size_shifter                          ;//[nb_front_end][3]
  public : uint32_t             ** _dir_bht_nb_shifter                            ;//[nb_front_end][3]
  public : bool                 ** _dir_have_pht                                  ;//[nb_front_end][3]
  public : uint32_t             ** _dir_pht_size_counter                          ;//[nb_front_end][3]
  public : uint32_t             ** _dir_pht_nb_counter                            ;//[nb_front_end][3]
  public : uint32_t             ** _dir_pht_size_address_share                    ;//[nb_front_end][3]
 
    // OOO_Engine
  public : uint32_t                _nb_ooo_engine                                 ;
  public : uint32_t              * _nb_rename_unit                                ;//[nb_ooo_engine]
  public : uint32_t              * _nb_inst_issue                                 ;//[nb_ooo_engine]
  public : uint32_t              * _nb_inst_reexecute                             ;//[nb_ooo_engine]
  public : uint32_t              * _nb_inst_commit                                ;//[nb_ooo_engine]
  public : uint32_t              * _nb_inst_branch_complete                       ;//[nb_ooo_engine]
  public : uint32_t              * _nb_rename_unit_select                         ;//[nb_ooo_engine]
  public : uint32_t              * _nb_execute_loop_select                        ;//[nb_ooo_engine]
  public : uint32_t              * _size_re_order_buffer                          ;//[nb_ooo_engine]
  public : uint32_t              * _nb_re_order_buffer_bank                       ;//[nb_ooo_engine]
  public : Tpriority_t           * _commit_priority                               ;//[nb_ooo_engine]
  public : Tload_balancing_t     * _commit_load_balancing                         ;//[nb_ooo_engine]
  public : uint32_t              * _size_issue_queue                              ;//[nb_ooo_engine]
  public : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Tissue_queue_scheme_t
                                 * _issue_queue_scheme                            ;//[nb_ooo_engine]
  public : uint32_t              * _nb_issue_queue_bank                           ;//[nb_ooo_engine]
  public : Tpriority_t           * _issue_priority                                ;//[nb_ooo_engine]
  public : Tload_balancing_t     * _issue_load_balancing                          ;//[nb_ooo_engine]
  public : uint32_t              * _size_reexecute_queue                          ;//[nb_ooo_engine]
  public : Tpriority_t           * _reexecute_priority                            ;//[nb_ooo_engine]
  public : Tload_balancing_t     * _reexecute_load_balancing                      ;//[nb_ooo_engine]
 
    // Execute_loop
  public : uint32_t                _nb_execute_loop                               ;
  public : uint32_t              * _nb_read_unit                                  ;//[nb_execute_loop]
  public : uint32_t              * _nb_execute_unit                               ;//[nb_execute_loop]
  public : uint32_t              * _nb_write_unit                                 ;//[nb_execute_loop]
  public : uint32_t              * _nb_gpr_bank                                   ;//[nb_execute_loop]
  public : uint32_t              * _nb_gpr_port_read_by_bank                      ;//[nb_execute_loop]
  public : uint32_t              * _nb_gpr_port_write_by_bank                     ;//[nb_execute_loop]
  public : uint32_t              * _nb_spr_bank                                   ;//[nb_execute_loop]
  public : uint32_t              * _nb_spr_port_read_by_bank                      ;//[nb_execute_loop]
  public : uint32_t              * _nb_spr_port_write_by_bank                     ;//[nb_execute_loop]
  public : Tpriority_t           * _execution_unit_to_write_unit_priority         ;//[nb_execute_loop]
  public : Tpriority_t           * _read_unit_to_execution_unit_priority          ;//[nb_execute_loop]
 
    // Link
  public : pair_dual             * _link_context_with_thread                      ;//[nb_thread]
  public : pair_dual             * _link_decod_unit_with_decod_bloc               ;//[nb_decod_bloc]
  public : pair_dual             * _link_rename_unit_with_rename_bloc             ;//[nb_rename_bloc]
  public : pair_dual             * _link_read_unit_with_read_bloc                 ;//[nb_read_bloc]
  public : pair_dual             * _link_write_unit_with_write_bloc               ;//[nb_write_bloc]
  public : pair_dual             * _link_execute_unit_with_functionnal_unit       ;//[nb_functionnal_unit]
  public : pair_dual             * _link_execute_unit_with_load_store_unit        ;//[nb_load_store_unit]
  public : uint32_t              * _link_decod_bloc_with_thread                   ;//[nb_thread]
  public : uint32_t              * _link_rename_bloc_with_front_end               ;//[nb_front_end]
  public : bool                *** _table_dispatch                                ;//[nb_ooo_engine][nb_inst_issue][nb_read_bloc]
  public : bool                 ** _link_read_bloc_and_load_store_unit            ;//[nb_read_bloc][nb_load_store_unit]
  public : bool                 ** _link_read_bloc_and_functionnal_unit           ;//[nb_read_bloc][nb_functionnal_unit]
  public : bool                 ** _link_write_bloc_and_load_store_unit           ;//[nb_write_bloc][nb_load_store_unit]
  public : bool                 ** _link_write_bloc_and_functionnal_unit          ;//[nb_write_bloc][nb_functionnal_unit]
  public : uint32_t              * _link_load_store_unit_with_thread              ;//[nb_thread]
  public : bool                 ** _link_thread_and_functionnal_unit              ;//[nb_thread][nb_functionnal_unit]
  public : uint32_t              * _link_icache_port_with_thread                  ;//[nb_thread]
  public : uint32_t             ** _link_dcache_port_with_load_store_unit         ;//[nb_load_store_unit][nb_cache_port]

  public : Tpriority_t             _dispatch_priority                             ;
  public : Tload_balancing_t       _dispatch_load_balancing                       ;
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
