#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_meta_predictor_glue_Meta_Predictor_Glue_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_meta_predictor_glue_Meta_Predictor_Glue_h

/*
 * $Id: Meta_Predictor_Glue.h 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace meta_predictor_glue {


  class Meta_Predictor_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_VAL                    ;//              [nb_inst_predict]
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK                    ;//              [nb_inst_predict]
  public    : SC_OUT(Thistory_t)           ** out_PREDICT_HISTORY                ;//              [nb_inst_predict]
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_DIRECTION              ;//              [nb_inst_predict]

  public    : SC_OUT(Tcontrol_t)          *** out_PREDICT_PREDICTOR_VAL          ;//[nb_predictor][nb_inst_predict]
  public    : SC_IN (Tcontrol_t)          ***  in_PREDICT_PREDICTOR_ACK          ;//[nb_predictor][nb_inst_predict]
  public    : SC_IN (Thistory_t)          ***  in_PREDICT_PREDICTOR_HISTORY      ;//[nb_predictor][nb_inst_predict]
  public    : SC_IN (Tcontrol_t)          ***  in_PREDICT_PREDICTOR_DIRECTION    ;//[nb_predictor][nb_inst_predict]
  public    : SC_OUT(Tcontrol_t)          *** out_PREDICT_PREDICTOR_DIRECTION_VAL;//[nb_predictor][nb_inst_predict] // if update_on_prediction
  public    : SC_OUT(Tcontrol_t)          *** out_PREDICT_PREDICTOR_DIRECTION    ;//[nb_predictor][nb_inst_predict] // if update_on_prediction

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_VAL                     ;//              [nb_inst_update]
  public    : SC_OUT(Tcontrol_t)           ** out_UPDATE_ACK                     ;//              [nb_inst_update]
  public    : SC_IN (Thistory_t)           **  in_UPDATE_HISTORY                 ;//              [nb_inst_update]
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_DIRECTION               ;//              [nb_inst_update]

  public    : SC_OUT(Tcontrol_t)          *** out_UPDATE_PREDICTOR_VAL           ;//[nb_predictor][nb_inst_update]
  public    : SC_IN (Tcontrol_t)          ***  in_UPDATE_PREDICTOR_ACK           ;//[nb_predictor][nb_inst_update]
  public    : SC_OUT(Thistory_t)          *** out_UPDATE_PREDICTOR_HISTORY       ;//[nb_predictor][nb_inst_update]
  public    : SC_OUT(Tcontrol_t)          *** out_UPDATE_PREDICTOR_DIRECTION     ;//[nb_predictor][nb_inst_update]
  public    : SC_OUT(Tcontrol_t)          *** out_UPDATE_PREDICTOR_MISS          ;//[nb_predictor][nb_inst_update] // if update_on_prediction

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Meta_Predictor_Glue);
#endif
  public  :          Meta_Predictor_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Meta_Predictor_Glue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
//public  : void        genMoore                  (void);

  public  : void        genMealy_predict_valack   (void);
  public  : void        genMealy_predict          (void);

  public  : void        genMealy_update_valack    (void);
  public  : void        genMealy_update           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
