#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_meta_predictor_glue_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_meta_predictor_glue_Parameters_h

/*
 * $Id: Parameters.h 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace meta_predictor_glue {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t     _nb_inst_predict               ;
  public : uint32_t     _nb_inst_update                ;
  public : uint32_t     _nb_predictor                  ;
  public : uint32_t   * _predictor_size_history        ;//[nb_predictor]
  public : bool       * _predictor_update_on_prediction;//[nb_predictor]
                      
  public : uint32_t     _size_history                  ;
  public : uint32_t   * _predictor_history_shift       ;//[nb_predictor]
  public : uint32_t   * _predictor_history_shift_msb   ;//[nb_predictor]
  public : Thistory_t * _predictor_history_mask        ;//[nb_predictor]    


    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t   nb_inst_predict               ,
			uint32_t   nb_inst_update                ,
                        uint32_t   nb_predictor                  ,
                        uint32_t * predictor_size_history        ,//[nb_predictor]
                        bool     * predictor_update_on_prediction,//[nb_predictor]
                        bool       is_toplevel=false);
//public : Parameters  (Parameters & param) ;
  public : ~Parameters (void);

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
                                              morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::meta_predictor_glue::Parameters & x);
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
