/*
 * $Id: Decod_queue.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Decod_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::Decod_queue"
  Decod_queue::Decod_queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Decod_queue,FUNCTION);

    usage_environment(_usage);

#if DEBUG_Decod_queue == true
    log_printf(INFO,Decod_queue,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    log_printf(INFO,Decod_queue,FUNCTION,_("Allocation"));

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Decod_queue,FUNCTION,_("Allocation of statistics"));

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Decod_queue,FUNCTION,_("Generate the vhdl"));
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        // Function pointer
        switch (_param->_queue_scheme)
          {
          case DECOD_QUEUE_SCHEME_ONE_FIFO :
            {
              function_transition         = &morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Decod_queue::function_one_fifo_transition        ;
              function_genMoore           = &morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Decod_queue::function_one_fifo_genMoore          ;
              function_genMealy_decod_out = &morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Decod_queue::function_one_fifo_genMealy_decod_out;
              
              break;
            }
          case DECOD_QUEUE_SCHEME_MULTI_FIFO :
            {
              function_transition         = &morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Decod_queue::function_multi_fifo_transition        ;
              function_genMoore           = &morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Decod_queue::function_multi_fifo_genMoore          ;
              function_genMealy_decod_out = &morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Decod_queue::function_multi_fifo_genMealy_decod_out;
              
              break;
            }
          default :
            {
              break;
            }
          }

	log_printf(INFO,Decod_queue,FUNCTION,_("Method - transition"));

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Decod_queue,FUNCTION,_("Method - genMoore"));

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Decod_queue,FUNCTION,_("Method - genMealy_decod_out"));

	SC_METHOD (genMealy_decod_out);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal register

	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  sensitive << (*(in_DECOD_OUT_ACK [i]));
	  for (uint32_t i=0; i<_param->_nb_context; i++)
            {
              if (_param->_have_port_depth)
                {
              sensitive << (*(in_DEPTH_MIN [i]));
              sensitive << (*(in_DEPTH_MAX [i]));
                }
              sensitive << (*(in_DEPTH_FULL[i]));
            }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    (*(out_DECOD_OUT_VAL [i])) (*(in_DECOD_OUT_ACK [i]));
            for (uint32_t j=0; j<_param->_nb_context; j++)
              {
                if (_param->_have_port_depth)
                  {
                (*(out_DECOD_OUT_VAL [i])) (*(in_DEPTH_MIN [j]));
                (*(out_DECOD_OUT_VAL [i])) (*(in_DEPTH_MAX [j]));
                  }
              }
	  }
# endif    
	
#endif
      }
    log_end(Decod_queue,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Decod_queue::~Decod_queue"
  Decod_queue::~Decod_queue (void)
  {
    log_begin(Decod_queue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Decod_queue,FUNCTION,_("Deallocation"));
    deallocation ();

    log_end(Decod_queue,FUNCTION);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
