/*
 * $Id: test.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::meta_predictor_glue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

  if (setlocale (LC_ALL, "") == NULL)
    msg(_("setlocale ko.\n"));

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Meta_Predictor_Glue * _Meta_Predictor_Glue = new Meta_Predictor_Glue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");
  
  ALLOC1_SC_SIGNAL( in_PREDICT_VAL                    ," in_PREDICT_VAL                    ",Tcontrol_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_ACK                    ,"out_PREDICT_ACK                    ",Tcontrol_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_HISTORY                ,"out_PREDICT_HISTORY                ",Thistory_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_DIRECTION              ,"out_PREDICT_DIRECTION              ",Tcontrol_t,_param->_nb_inst_predict);
  ALLOC2_SC_SIGNAL(out_PREDICT_PREDICTOR_VAL          ,"out_PREDICT_PREDICTOR_VAL          ",Tcontrol_t,_param->_nb_predictor,_param->_nb_inst_predict);
  ALLOC2_SC_SIGNAL( in_PREDICT_PREDICTOR_ACK          ," in_PREDICT_PREDICTOR_ACK          ",Tcontrol_t,_param->_nb_predictor,_param->_nb_inst_predict);
  ALLOC2_SC_SIGNAL( in_PREDICT_PREDICTOR_HISTORY      ," in_PREDICT_PREDICTOR_HISTORY      ",Thistory_t,_param->_nb_predictor,_param->_nb_inst_predict);
  ALLOC2_SC_SIGNAL( in_PREDICT_PREDICTOR_DIRECTION    ," in_PREDICT_PREDICTOR_DIRECTION    ",Tcontrol_t,_param->_nb_predictor,_param->_nb_inst_predict);
  ALLOC2_SC_SIGNAL(out_PREDICT_PREDICTOR_DIRECTION_VAL,"out_PREDICT_PREDICTOR_DIRECTION_VAL",Tcontrol_t,_param->_nb_predictor,_param->_nb_inst_predict); // if update_on_prediction
  ALLOC2_SC_SIGNAL(out_PREDICT_PREDICTOR_DIRECTION    ,"out_PREDICT_PREDICTOR_DIRECTION    ",Tcontrol_t,_param->_nb_predictor,_param->_nb_inst_predict); // if update_on_prediction
  ALLOC1_SC_SIGNAL( in_UPDATE_VAL                     ," in_UPDATE_VAL                     ",Tcontrol_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_ACK                     ,"out_UPDATE_ACK                     ",Tcontrol_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_HISTORY                 ," in_UPDATE_HISTORY                 ",Thistory_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_DIRECTION               ," in_UPDATE_DIRECTION               ",Tcontrol_t,_param->_nb_inst_update);
  ALLOC2_SC_SIGNAL(out_UPDATE_PREDICTOR_VAL           ,"out_UPDATE_PREDICTOR_VAL           ",Tcontrol_t,_param->_nb_predictor,_param->_nb_inst_update);
  ALLOC2_SC_SIGNAL( in_UPDATE_PREDICTOR_ACK           ," in_UPDATE_PREDICTOR_ACK           ",Tcontrol_t,_param->_nb_predictor,_param->_nb_inst_update);
  ALLOC2_SC_SIGNAL(out_UPDATE_PREDICTOR_HISTORY       ,"out_UPDATE_PREDICTOR_HISTORY       ",Thistory_t,_param->_nb_predictor,_param->_nb_inst_update);
  ALLOC2_SC_SIGNAL(out_UPDATE_PREDICTOR_DIRECTION     ,"out_UPDATE_PREDICTOR_DIRECTION     ",Tcontrol_t,_param->_nb_predictor,_param->_nb_inst_update);
  ALLOC2_SC_SIGNAL(out_UPDATE_PREDICTOR_MISS          ,"out_UPDATE_PREDICTOR_MISS          ",Tcontrol_t,_param->_nb_predictor,_param->_nb_inst_update);

  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Meta_Predictor_Glue.\n"),name.c_str());

  (*(_Meta_Predictor_Glue->in_CLOCK))        (*(in_CLOCK));
  (*(_Meta_Predictor_Glue->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Meta_Predictor_Glue, in_PREDICT_VAL                    ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Meta_Predictor_Glue,out_PREDICT_ACK                    ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Meta_Predictor_Glue,out_PREDICT_HISTORY                ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Meta_Predictor_Glue,out_PREDICT_DIRECTION              ,_param->_nb_inst_predict);

  INSTANCE2_SC_SIGNAL(_Meta_Predictor_Glue,out_PREDICT_PREDICTOR_VAL          ,_param->_nb_predictor,_param->_nb_inst_predict);
  INSTANCE2_SC_SIGNAL(_Meta_Predictor_Glue, in_PREDICT_PREDICTOR_ACK          ,_param->_nb_predictor,_param->_nb_inst_predict);
  INSTANCE2_SC_SIGNAL(_Meta_Predictor_Glue, in_PREDICT_PREDICTOR_HISTORY      ,_param->_nb_predictor,_param->_nb_inst_predict);
  INSTANCE2_SC_SIGNAL(_Meta_Predictor_Glue, in_PREDICT_PREDICTOR_DIRECTION    ,_param->_nb_predictor,_param->_nb_inst_predict);
  
  for (uint32_t i=0; i<_param->_nb_predictor; ++i)
    if (_param->_predictor_update_on_prediction [i])
      {
  INSTANCE1_SC_SIGNAL(_Meta_Predictor_Glue,out_PREDICT_PREDICTOR_DIRECTION_VAL[i],_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Meta_Predictor_Glue,out_PREDICT_PREDICTOR_DIRECTION    [i],_param->_nb_inst_predict);
      }

  INSTANCE1_SC_SIGNAL(_Meta_Predictor_Glue, in_UPDATE_VAL                     ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Meta_Predictor_Glue,out_UPDATE_ACK                     ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Meta_Predictor_Glue, in_UPDATE_HISTORY                 ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Meta_Predictor_Glue, in_UPDATE_DIRECTION               ,_param->_nb_inst_update);

  INSTANCE2_SC_SIGNAL(_Meta_Predictor_Glue,out_UPDATE_PREDICTOR_VAL           ,_param->_nb_predictor,_param->_nb_inst_update);
  INSTANCE2_SC_SIGNAL(_Meta_Predictor_Glue, in_UPDATE_PREDICTOR_ACK           ,_param->_nb_predictor,_param->_nb_inst_update);
  INSTANCE2_SC_SIGNAL(_Meta_Predictor_Glue,out_UPDATE_PREDICTOR_HISTORY       ,_param->_nb_predictor,_param->_nb_inst_update);
  INSTANCE2_SC_SIGNAL(_Meta_Predictor_Glue,out_UPDATE_PREDICTOR_DIRECTION     ,_param->_nb_predictor,_param->_nb_inst_update);
  for (uint32_t i=0; i<_param->_nb_predictor; ++i)
    if (_param->_predictor_update_on_prediction [i])
  INSTANCE1_SC_SIGNAL(_Meta_Predictor_Glue,out_UPDATE_PREDICTOR_MISS [i]                            ,_param->_nb_inst_update);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL( in_PREDICT_VAL                    ,_param->_nb_inst_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_ACK                    ,_param->_nb_inst_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_HISTORY                ,_param->_nb_inst_predict);
  DELETE1_SC_SIGNAL(out_PREDICT_DIRECTION              ,_param->_nb_inst_predict);

  DELETE2_SC_SIGNAL(out_PREDICT_PREDICTOR_VAL          ,_param->_nb_predictor,_param->_nb_inst_predict);
  DELETE2_SC_SIGNAL( in_PREDICT_PREDICTOR_ACK          ,_param->_nb_predictor,_param->_nb_inst_predict);
  DELETE2_SC_SIGNAL( in_PREDICT_PREDICTOR_HISTORY      ,_param->_nb_predictor,_param->_nb_inst_predict);
  DELETE2_SC_SIGNAL( in_PREDICT_PREDICTOR_DIRECTION    ,_param->_nb_predictor,_param->_nb_inst_predict);
  DELETE2_SC_SIGNAL(out_PREDICT_PREDICTOR_DIRECTION_VAL,_param->_nb_predictor,_param->_nb_inst_predict);
  DELETE2_SC_SIGNAL(out_PREDICT_PREDICTOR_DIRECTION    ,_param->_nb_predictor,_param->_nb_inst_predict);

  DELETE1_SC_SIGNAL( in_UPDATE_VAL                     ,_param->_nb_inst_update);
  DELETE1_SC_SIGNAL(out_UPDATE_ACK                     ,_param->_nb_inst_update);
  DELETE1_SC_SIGNAL( in_UPDATE_HISTORY                 ,_param->_nb_inst_update);
  DELETE1_SC_SIGNAL( in_UPDATE_DIRECTION               ,_param->_nb_inst_update);

  DELETE2_SC_SIGNAL(out_UPDATE_PREDICTOR_VAL           ,_param->_nb_predictor,_param->_nb_inst_update);
  DELETE2_SC_SIGNAL( in_UPDATE_PREDICTOR_ACK           ,_param->_nb_predictor,_param->_nb_inst_update);
  DELETE2_SC_SIGNAL(out_UPDATE_PREDICTOR_HISTORY       ,_param->_nb_predictor,_param->_nb_inst_update);
  DELETE2_SC_SIGNAL(out_UPDATE_PREDICTOR_DIRECTION     ,_param->_nb_predictor,_param->_nb_inst_update);
  DELETE2_SC_SIGNAL(out_UPDATE_PREDICTOR_MISS          ,_param->_nb_predictor,_param->_nb_inst_update);
    }
#endif

  delete _Meta_Predictor_Glue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
