#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_two_level_branch_predictor_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_two_level_branch_predictor_Parameters_h

/*
 * $Id: Parameters.h 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/include/Types.h"
#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace two_level_branch_predictor {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t   _nb_inst_predict         ;
  public : uint32_t   _nb_inst_update          ;
  public : uint32_t   _size_address            ;
  public : bool       _have_bht                ;
  public : uint32_t   _bht_size_shifter        ;
  public : uint32_t   _bht_nb_shifter          ;
  public : bool       _have_pht                ;
  public : uint32_t   _pht_size_counter        ;
  public : uint32_t   _pht_nb_counter          ;
  public : uint32_t   _pht_size_address_share  ;
  public : bool       _update_on_prediction    ;
                                       
  public : Thistory_t _pht_counter_max         ;
        
  public : uint32_t   _size_history            ;
                                               
  public : Thistory_t _bht_history_mask        ;
  public : Thistory_t _bht_history_rshift      ;
  public : Thistory_t _pht_history_mask        ;
  public : Thistory_t _pht_history_rshift      ;
                                               
  public : uint32_t   _bht_size_address        ;
  public : uint32_t   _pht_size_address        ;
                                               
  public : Taddress_t _bht_address_mask        ;
  public : uint32_t   _pht_nb_bank             ;
  public : uint32_t   _pht_size_bank           ;
  public : Taddress_t _pht_address_share_mask  ;
  public : Taddress_t _pht_address_share_lshift;
  public : Taddress_t _pht_address_bank_mask   ;
  public : Taddress_t _pht_address_bank_rshift ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t nb_inst_predict       ,
			uint32_t nb_inst_update        ,
			uint32_t size_address          ,
                        bool     have_bht              ,
			uint32_t bht_size_shifter      ,
			uint32_t bht_nb_shifter        ,
			bool     have_pht              ,
			uint32_t pht_size_counter      ,
			uint32_t pht_nb_counter        ,
			uint32_t pht_size_address_share,
                        bool     update_on_prediction  ,
                        bool is_toplevel=false);
//public : Parameters  (Parameters & param) ;
  public : ~Parameters (void);

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
                                              morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor::Parameters & x);
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
