/*
 * $Id: Meta_Predictor_Glue_deallocation.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace meta_predictor_glue {


#undef  FUNCTION
#define FUNCTION "Meta_Predictor_Glue::deallocation"
  void Meta_Predictor_Glue::deallocation (void)
  {
    log_begin(Meta_Predictor_Glue,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL( in_PREDICT_VAL                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_ACK                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_HISTORY                ,_param->_nb_inst_predict,_param->_size_history);
        DELETE1_SIGNAL(out_PREDICT_DIRECTION              ,_param->_nb_inst_predict,1);

        DELETE2_SIGNAL(out_PREDICT_PREDICTOR_VAL          ,_param->_nb_predictor,_param->_nb_inst_predict,1);
        DELETE2_SIGNAL( in_PREDICT_PREDICTOR_ACK          ,_param->_nb_predictor,_param->_nb_inst_predict,1);
        DELETE2_SIGNAL( in_PREDICT_PREDICTOR_HISTORY      ,_param->_nb_predictor,_param->_nb_inst_predict,_param->_predictor_size_history[it1]);
        DELETE2_SIGNAL( in_PREDICT_PREDICTOR_DIRECTION    ,_param->_nb_predictor,_param->_nb_inst_predict,1);
        DELETE2_SIGNAL(out_PREDICT_PREDICTOR_DIRECTION_VAL,_param->_nb_predictor,_param->_nb_inst_predict,(_param->_predictor_update_on_prediction [it1])?1:0);
        DELETE2_SIGNAL(out_PREDICT_PREDICTOR_DIRECTION    ,_param->_nb_predictor,_param->_nb_inst_predict,(_param->_predictor_update_on_prediction [it1])?1:0);

        DELETE1_SIGNAL( in_UPDATE_VAL                     ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL(out_UPDATE_ACK                     ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_HISTORY                 ,_param->_nb_inst_update,_param->_size_history);
        DELETE1_SIGNAL( in_UPDATE_DIRECTION               ,_param->_nb_inst_update,1);

        DELETE2_SIGNAL(out_UPDATE_PREDICTOR_VAL           ,_param->_nb_predictor,_param->_nb_inst_update,1);
        DELETE2_SIGNAL( in_UPDATE_PREDICTOR_ACK           ,_param->_nb_predictor,_param->_nb_inst_update,1);
        DELETE2_SIGNAL(out_UPDATE_PREDICTOR_HISTORY       ,_param->_nb_predictor,_param->_nb_inst_update,_param->_predictor_size_history[it1]);
        DELETE2_SIGNAL(out_UPDATE_PREDICTOR_DIRECTION     ,_param->_nb_predictor,_param->_nb_inst_update,1);
        DELETE2_SIGNAL(out_UPDATE_PREDICTOR_MISS          ,_param->_nb_predictor,_param->_nb_inst_update,(_param->_predictor_update_on_prediction [it1])?1:0);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    
    delete _component;

    log_end(Meta_Predictor_Glue,FUNCTION);
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
